/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.register.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.tenant.register.stub.TenantMgtServiceStub;
import org.wso2.carbon.tenant.register.stub.beans.xsd.CaptchaInfoBean;
import org.wso2.carbon.tenant.register.stub.beans.xsd.TenantInfoBean;
import org.wso2.carbon.ui.CarbonUIUtil;

public class TenantSelfRegistrationClient {
    private static final Log log = LogFactory.getLog(TenantSelfRegistrationClient.class);
    private TenantMgtServiceStub stub;
    private String epr;

    public TenantSelfRegistrationClient(String cookie, String backendServerURL, ConfigurationContext configContext) throws RegistryException {
        this.epr = backendServerURL + "TenantMgtService";
        try {
            this.stub = new TenantMgtServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate AddServices service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public TenantSelfRegistrationClient(ServletConfig config, HttpSession session) throws RegistryException {
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "TenantMgtService";
        try {
            this.stub = new TenantMgtServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate Add Services service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public String registerTenant(TenantInfoBean tenantInfoBean, CaptchaInfoBean captchaInfoBean) throws Exception {
        return this.stub.registerTenant(tenantInfoBean, captchaInfoBean);
    }

    public boolean checkDomainAvailability(String domainName) throws Exception {
        return this.stub.checkDomainAvailability(domainName);
    }

    public String validateOrSuggestDomain(String domainName, String successKey) throws Exception {
        return this.stub.validateOrSuggestDomain(domainName, successKey);
    }

    public CaptchaInfoBean generateRandomCaptcha() throws Exception {
        return this.stub.generateRandomCaptcha();
    }
}

