/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.qpid.internal;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.qpid.server.Main;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.wso2.service.QpidNotificationService;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.event.core.EventBundleNotificationService;
import org.wso2.carbon.event.core.qpid.QpidServerDetails;
import org.wso2.carbon.qpid.authentication.service.AuthenticationService;
import org.wso2.carbon.qpid.internal.QpidServiceDataHolder;
import org.wso2.carbon.qpid.service.QpidService;
import org.wso2.carbon.qpid.service.QpidServiceImpl;

public class QpidServiceComponent {
    private static final Log log = LogFactory.getLog(QpidServiceComponent.class);
    private static final String VM_BROKER_AUTO_CREATE = "amqj.AutoCreateVMBroker";
    private static final String DERBY_LOG_FILE = "derby.stream.error.file";
    private static final String QPID_DERBY_LOG_FILE = "/repository/logs/qpid-derby-store.log";
    private ServiceRegistration qpidService = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext ctx) {
        System.setProperty(VM_BROKER_AUTO_CREATE, "true");
        System.setProperty(DERBY_LOG_FILE, System.getProperty("carbon.home") + QPID_DERBY_LOG_FILE);
        QpidServiceImpl qpidServiceImpl = new QpidServiceImpl(QpidServiceDataHolder.getInstance().getAccessKey());
        try {
            System.setProperty("QPID_HOME", qpidServiceImpl.getQpidHome());
            String[] args = new String[]{"-p" + qpidServiceImpl.getPort(), "-s" + qpidServiceImpl.getSSLPort()};
            Main.setStandaloneMode((boolean)false);
            Main.main((String[])args);
            Runtime.getRuntime().removeShutdownHook(ApplicationRegistry.getShutdownHook());
            while (!this.isBrokerRunning()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            boolean isServerStarted = false;
            int port = Integer.parseInt(qpidServiceImpl.getPort());
            while (!isServerStarted) {
                Socket socket = null;
                try {
                    InetAddress address = InetAddress.getByName("localhost");
                    socket = new Socket(address, port);
                    isServerStarted = socket.isConnected();
                    if (!isServerStarted) continue;
                    log.info((Object)("Successfully connected to the server on port " + qpidServiceImpl.getPort()));
                }
                catch (IOException e) {
                    log.info((Object)("Wait until Qpid server starts on port " + qpidServiceImpl.getPort()));
                    Thread.sleep(500L);
                }
                finally {
                    try {
                        if (socket == null || !socket.isConnected()) continue;
                        socket.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Can not close the socket with is used to check the server status ");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to start Qpid broker : " + e.getMessage()));
        }
        finally {
            this.qpidService = ctx.getBundleContext().registerService(QpidService.class.getName(), (Object)qpidServiceImpl, null);
            QpidServerDetails qpidServerDetails = new QpidServerDetails(qpidServiceImpl.getAccessKey(), qpidServiceImpl.getClientID(), qpidServiceImpl.getVirtualHostName(), qpidServiceImpl.getHostname(), qpidServiceImpl.getPort());
            QpidServiceDataHolder.getInstance().getEventBundleNotificationService().notifyStart(qpidServerDetails);
        }
    }

    protected void deactivate(ComponentContext ctx) {
        try {
            if (null != this.qpidService) {
                this.qpidService.unregister();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ApplicationRegistry.removeAll();
    }

    protected void setAccessKey(AuthenticationService authenticationService) {
        QpidServiceDataHolder.getInstance().setAccessKey(authenticationService.getAccessKey());
    }

    protected void unsetAccessKey(AuthenticationService authenticationService) {
        QpidServiceDataHolder.getInstance().setAccessKey(null);
    }

    protected void setQpidNotificationService(QpidNotificationService qpidNotificationService) {
    }

    protected void unsetQpidNotificationService(QpidNotificationService qpidNotificationService) {
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
        QpidServiceDataHolder.getInstance().setCarbonConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
        QpidServiceDataHolder.getInstance().setCarbonConfiguration(null);
    }

    protected void setEventBundleNotificationService(EventBundleNotificationService eventBundleNotificationService) {
        QpidServiceDataHolder.getInstance().registerEventBundleNotificationService(eventBundleNotificationService);
    }

    protected void unsetEventBundleNotificationService(EventBundleNotificationService eventBundleNotificationService) {
    }

    private boolean isBrokerRunning() {
        boolean response = false;
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> set = mBeanServer.queryNames(new ObjectName("org.apache.qpid:type=VirtualHost.VirtualHostManager,*"), null);
            if (set.size() > 0) {
                response = true;
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return response;
    }
}

