/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.qpid.messagestore.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.ConfigStoreMessages;
import org.apache.qpid.server.logging.messages.MessageStoreMessages;
import org.apache.qpid.server.logging.messages.TransactionLogMessages;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.store.ConfigurationRecoveryHandler;
import org.apache.qpid.server.store.MessageMetaDataType;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreRecoveryHandler;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.TransactionLog;
import org.apache.qpid.server.store.TransactionLogRecoveryHandler;
import org.apache.qpid.server.store.TransactionLogResource;

public class JDBCMessageStore
implements MessageStore {
    private static final Logger _logger = Logger.getLogger(JDBCMessageStore.class);
    private static final String EXCHANGE_TABLE_NAME = "QPID_EXCHANGE";
    private static final String QUEUE_TABLE_NAME = "QPID_QUEUE";
    private static final String BINDINGS_TABLE_NAME = "QPID_BINDINGS";
    private static final String QUEUE_ENTRY_TABLE_NAME = "QPID_QUEUE_ENTRY";
    private static final String META_DATA_TABLE_NAME = "QPID_META_DATA";
    private static final String MESSAGE_CONTENT_TABLE_NAME = "QPID_MESSAGE_CONTENT";
    public static final String JDBC_CONNECTION_URL = "url";
    public static final String JDBC_CONNECTION_USER_NAME = "userName";
    public static final String JDBC_CONNECTION_PASSWORD = "password";
    public static final String JDBC_DRIVER_NAME = "driverName";
    public static final String JDBC_MAX_ACTIVE = "maxActive";
    public static final String JDBC_MAX_WAIT = "maxWait";
    public static final String JDBC_MIN_IDLE = "minIdle";
    private final AtomicLong _messageId = new AtomicLong(0L);
    private AtomicBoolean _closed = new AtomicBoolean(false);
    private BasicDataSource _basicDataSource;
    private static final String SELECT_FROM_QUEUE = "SELECT name, owner, exclusive, arguments FROM QPID_QUEUE";
    private static final String FIND_QUEUE = "SELECT name, owner FROM QPID_QUEUE WHERE name = ?";
    private static final String UPDATE_QUEUE_EXCLUSIVITY = "UPDATE QPID_QUEUE SET exclusive = ? WHERE name = ?";
    private static final String SELECT_FROM_EXCHANGE = "SELECT name, type, autodelete FROM QPID_EXCHANGE";
    private static final String SELECT_FROM_BINDINGS = "SELECT exchange_name, queue_name, binding_key, arguments FROM QPID_BINDINGS ORDER BY exchange_name";
    private static final String FIND_BINDING = "SELECT * FROM QPID_BINDINGS WHERE exchange_name = ? AND queue_name = ? AND binding_key = ? ";
    private static final String INSERT_INTO_EXCHANGE = "INSERT INTO QPID_EXCHANGE ( name, type, autodelete ) VALUES ( ?, ?, ? )";
    private static final String DELETE_FROM_EXCHANGE = "DELETE FROM QPID_EXCHANGE WHERE name = ?";
    private static final String FIND_EXCHANGE = "SELECT name FROM QPID_EXCHANGE WHERE name = ?";
    private static final String INSERT_INTO_BINDINGS = "INSERT INTO QPID_BINDINGS ( exchange_name, queue_name, binding_key, arguments ) values ( ?, ?, ?, ? )";
    private static final String DELETE_FROM_BINDINGS = "DELETE FROM QPID_BINDINGS WHERE exchange_name = ? AND queue_name = ? AND binding_key = ?";
    private static final String INSERT_INTO_QUEUE = "INSERT INTO QPID_QUEUE (name, owner, exclusive, arguments) VALUES (?, ?, ?, ?)";
    private static final String DELETE_FROM_QUEUE = "DELETE FROM QPID_QUEUE WHERE name = ?";
    private static final String INSERT_INTO_QUEUE_ENTRY = "INSERT INTO QPID_QUEUE_ENTRY (queue_name, message_id) values (?,?)";
    private static final String DELETE_FROM_QUEUE_ENTRY = "DELETE FROM QPID_QUEUE_ENTRY WHERE queue_name = ? AND message_id =?";
    private static final String SELECT_FROM_QUEUE_ENTRY = "SELECT queue_name, message_id FROM QPID_QUEUE_ENTRY ORDER BY queue_name, message_id";
    private static final String INSERT_INTO_MESSAGE_CONTENT = "INSERT INTO QPID_MESSAGE_CONTENT( message_id, offset, last_byte, content ) values (?, ?, ?, ?)";
    private static final String SELECT_FROM_MESSAGE_CONTENT = "SELECT offset, content FROM QPID_MESSAGE_CONTENT WHERE message_id = ? AND last_byte > ? AND offset < ? ORDER BY message_id, offset";
    private static final String DELETE_FROM_MESSAGE_CONTENT = "DELETE FROM QPID_MESSAGE_CONTENT WHERE message_id = ?";
    private static final String INSERT_INTO_META_DATA = "INSERT INTO QPID_META_DATA( message_id , meta_data ) values (?, ?)";
    private static final String SELECT_FROM_META_DATA = "SELECT meta_data FROM QPID_META_DATA WHERE message_id = ?";
    private static final String DELETE_FROM_META_DATA = "DELETE FROM QPID_META_DATA WHERE message_id = ?";
    private static final String SELECT_ALL_FROM_META_DATA = "SELECT message_id, meta_data FROM QPID_META_DATA";
    private LogSubject _logSubject;
    private boolean _configured;
    private static final int DEFAULT_MAX_ACTIVE = 50;
    private static final long DEFAULT_MAX_WAIT = 60000L;
    private static final int DEFAULT_MIN_IDLE = 10;
    private State _state = State.INITIAL;

    public void configureConfigStore(String name, ConfigurationRecoveryHandler recoveryHandler, Configuration storeConfiguration, LogSubject logSubject) throws Exception {
        this.stateTransition(State.INITIAL, State.CONFIGURING);
        this._logSubject = logSubject;
        CurrentActor.get().message(this._logSubject, ConfigStoreMessages.CREATED((String)this.getClass().getName()));
        if (!this._configured) {
            this.commonConfiguration(name, storeConfiguration, logSubject);
            this._configured = true;
        }
        this.recover(recoveryHandler);
        this.stateTransition(State.RECOVERING, State.STARTED);
    }

    public void configureMessageStore(String name, MessageStoreRecoveryHandler recoveryHandler, Configuration storeConfiguration, LogSubject logSubject) throws Exception {
        CurrentActor.get().message(this._logSubject, MessageStoreMessages.CREATED((String)this.getClass().getName()));
        if (!this._configured) {
            this._logSubject = logSubject;
            this.commonConfiguration(name, storeConfiguration, logSubject);
            this._configured = true;
        }
        this.recoverMessages(recoveryHandler);
    }

    public void configureTransactionLog(String name, TransactionLogRecoveryHandler recoveryHandler, Configuration storeConfiguration, LogSubject logSubject) throws Exception {
        CurrentActor.get().message(this._logSubject, TransactionLogMessages.CREATED((String)this.getClass().getName()));
        if (!this._configured) {
            this._logSubject = logSubject;
            this.commonConfiguration(name, storeConfiguration, logSubject);
            this._configured = true;
        }
        this.recoverQueueEntries(recoveryHandler);
    }

    private void commonConfiguration(String name, Configuration storeConfiguration, LogSubject logSubject) throws ClassNotFoundException, SQLException {
        this._basicDataSource = JDBCMessageStore.buildDataSource(storeConfiguration);
    }

    public static BasicDataSource buildDataSource(Configuration storeConfiguration) {
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setUrl(storeConfiguration.getString(JDBC_CONNECTION_URL));
        basicDataSource.setDriverClassName(storeConfiguration.getString(JDBC_DRIVER_NAME));
        basicDataSource.setUsername(storeConfiguration.getString(JDBC_CONNECTION_USER_NAME));
        basicDataSource.setPassword(storeConfiguration.getString(JDBC_CONNECTION_PASSWORD));
        if (storeConfiguration.getString(JDBC_MAX_ACTIVE) != null) {
            basicDataSource.setMaxActive(Integer.parseInt(storeConfiguration.getString(JDBC_MAX_ACTIVE)));
        } else {
            basicDataSource.setMaxActive(50);
        }
        if (storeConfiguration.getString(JDBC_MAX_WAIT) != null) {
            basicDataSource.setMaxWait((long)Integer.parseInt(storeConfiguration.getString(JDBC_MAX_WAIT)));
        } else {
            basicDataSource.setMaxWait(60000L);
        }
        if (storeConfiguration.getString(JDBC_MIN_IDLE) != null) {
            basicDataSource.setMaxIdle(Integer.parseInt(storeConfiguration.getString(JDBC_MIN_IDLE)));
        } else {
            basicDataSource.setMinIdle(10);
        }
        return basicDataSource;
    }

    public void recover(ConfigurationRecoveryHandler recoveryHandler) throws AMQException {
        this.stateTransition(State.CONFIGURING, State.RECOVERING);
        CurrentActor.get().message(this._logSubject, MessageStoreMessages.RECOVERY_START());
        try {
            ConfigurationRecoveryHandler.QueueRecoveryHandler qrh = recoveryHandler.begin((MessageStore)this);
            this.loadQueues(qrh);
            ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh = qrh.completeQueueRecovery();
            List<String> exchanges = this.loadExchanges(erh);
            ConfigurationRecoveryHandler.BindingRecoveryHandler brh = erh.completeExchangeRecovery();
            this.recoverBindings(brh, exchanges);
            brh.completeBindingRecovery();
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadQueues(ConfigurationRecoveryHandler.QueueRecoveryHandler qrh) throws SQLException {
        Connection conn = this.newAutoCommitConnection();
        try {
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(SELECT_FROM_QUEUE);
                try {
                    while (rs.next()) {
                        FieldTable arguments;
                        String queueName = rs.getString(1);
                        String owner = rs.getString(2);
                        boolean exclusive = rs.getBoolean(3);
                        Blob argumentsAsBlob = rs.getBlob(4);
                        byte[] dataAsBytes = argumentsAsBlob.getBytes(1L, (int)argumentsAsBlob.length());
                        if (dataAsBytes.length > 0) {
                            ByteBuffer buffer = ByteBuffer.wrap((byte[])dataAsBytes);
                            arguments = new FieldTable(buffer, (long)buffer.limit());
                        } else {
                            arguments = null;
                        }
                        qrh.queue(queueName, owner, exclusive, arguments);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * Exception decompiling
     */
    private List<String> loadExchanges(ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverBindings(ConfigurationRecoveryHandler.BindingRecoveryHandler brh, List<String> exchanges) throws SQLException {
        _logger.info((Object)"Recovering bindings...");
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            PreparedStatement stmt = conn.prepareStatement(SELECT_FROM_BINDINGS);
            try {
                ResultSet rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        java.nio.ByteBuffer buf;
                        String exchangeName = rs.getString(1);
                        String queueName = rs.getString(2);
                        String bindingKey = rs.getString(3);
                        Blob arguments = rs.getBlob(4);
                        if (arguments != null && arguments.length() != 0L) {
                            byte[] argumentBytes = arguments.getBytes(1L, (int)arguments.length());
                            buf = java.nio.ByteBuffer.wrap(argumentBytes);
                        } else {
                            buf = null;
                        }
                        brh.binding(exchangeName, queueName, bindingKey, buf);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void close() throws Exception {
        CurrentActor.get().message(this._logSubject, MessageStoreMessages.CLOSED());
        this._closed.getAndSet(true);
        try {
            this._basicDataSource.close();
        }
        catch (SQLException e) {
            _logger.error((Object)("Exception whilst shutting down the store: " + e));
        }
    }

    public StoredMessage addMessage(StorableMessageMetaData metaData) {
        if (metaData.isPersistent()) {
            return new StoredJDBCMessage(this._messageId.incrementAndGet(), metaData);
        }
        return new StoredJDBCMessage(this._messageId.incrementAndGet(), metaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(long messageId) {
        try {
            Connection conn = this.newConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_META_DATA);
                try {
                    stmt.setLong(1, messageId);
                    int results = stmt.executeUpdate();
                    stmt.close();
                    if (results == 0) {
                        throw new RuntimeException("Message metadata not found for message id " + messageId);
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Deleted metadata for message " + messageId));
                    }
                    stmt = conn.prepareStatement(DELETE_FROM_MESSAGE_CONTENT);
                    stmt.setLong(1, messageId);
                    results = stmt.executeUpdate();
                }
                finally {
                    stmt.close();
                }
                conn.commit();
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException t) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error removing message with id " + messageId + " from database: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExchange(Exchange exchange) throws AMQStoreException {
        block15: {
            if (this._state != State.RECOVERING) {
                try {
                    Connection conn = this.newAutoCommitConnection();
                    try {
                        PreparedStatement stmt = conn.prepareStatement(FIND_EXCHANGE);
                        try {
                            stmt.setString(1, exchange.getNameShortString().toString());
                            ResultSet rs = stmt.executeQuery();
                            try {
                                if (rs.next()) break block15;
                                PreparedStatement insertStmt = conn.prepareStatement(INSERT_INTO_EXCHANGE);
                                try {
                                    insertStmt.setString(1, exchange.getName());
                                    insertStmt.setString(2, exchange.getTypeShortString().asString());
                                    insertStmt.setShort(3, exchange.isAutoDelete() ? (short)1 : 0);
                                    insertStmt.execute();
                                }
                                finally {
                                    insertStmt.close();
                                }
                            }
                            finally {
                                rs.close();
                            }
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    finally {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    throw new AMQStoreException("Error writing Exchange with name " + exchange.getNameShortString() + " to database: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExchange(Exchange exchange) throws AMQStoreException {
        try {
            Connection conn = this.newAutoCommitConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_EXCHANGE);
                try {
                    stmt.setString(1, exchange.getNameShortString().toString());
                    int results = stmt.executeUpdate();
                    stmt.close();
                    if (results == 0) {
                        throw new AMQStoreException("Exchange " + exchange.getNameShortString() + " not found");
                    }
                }
                finally {
                    stmt.close();
                }
            }
            finally {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error deleting Exchange with name " + exchange.getNameShortString() + " from database: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
        block17: {
            if (this._state != State.RECOVERING) {
                try {
                    Connection conn = this.newAutoCommitConnection();
                    try {
                        PreparedStatement stmt = conn.prepareStatement(FIND_BINDING);
                        try {
                            stmt.setString(1, exchange.getNameShortString().toString());
                            stmt.setString(2, queue.getNameShortString().toString());
                            stmt.setString(3, routingKey == null ? null : routingKey.toString());
                            ResultSet rs = stmt.executeQuery();
                            try {
                                if (rs.next()) break block17;
                                PreparedStatement insertStmt = conn.prepareStatement(INSERT_INTO_BINDINGS);
                                try {
                                    insertStmt.setString(1, exchange.getNameShortString().toString());
                                    insertStmt.setString(2, queue.getNameShortString().toString());
                                    insertStmt.setString(3, routingKey == null ? null : routingKey.toString());
                                    if (args != null) {
                                        byte[] bytes = args.getDataAsBytes();
                                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                                        insertStmt.setBinaryStream(4, (InputStream)bis, bytes.length);
                                    } else {
                                        insertStmt.setNull(4, 2004);
                                    }
                                    insertStmt.executeUpdate();
                                }
                                finally {
                                    insertStmt.close();
                                }
                            }
                            finally {
                                rs.close();
                            }
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    finally {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    throw new AMQStoreException("Error writing binding for AMQQueue with name " + queue.getNameShortString() + " to exchange " + exchange.getNameShortString() + " to database: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void unbindQueue(Exchange exchange, AMQShortString routingKey, AMQQueue queue, FieldTable args) throws AMQStoreException {
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_BINDINGS);
            stmt.setString(1, exchange.getNameShortString().toString());
            stmt.setString(2, queue.getNameShortString().toString());
            stmt.setString(3, routingKey == null ? null : routingKey.toString());
            int result = stmt.executeUpdate();
            stmt.close();
            if (result != 1) {
                throw new AMQStoreException("Queue binding for queue with name " + queue.getNameShortString() + " to exchange " + exchange.getNameShortString() + "  not found");
            }
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error removing binding for AMQQueue with name " + queue.getNameShortString() + " to exchange " + exchange.getNameShortString() + " in database: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    _logger.error((Object)e);
                }
            }
        }
    }

    public void createQueue(AMQQueue queue) throws AMQStoreException {
        this.createQueue(queue, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQStoreException {
        _logger.debug((Object)("public void createQueue(AMQQueue queue = " + queue + "): called"));
        if (this._state != State.RECOVERING) {
            try {
                Connection conn;
                block12: {
                    conn = this.newAutoCommitConnection();
                    PreparedStatement stmt = conn.prepareStatement(FIND_QUEUE);
                    try {
                        stmt.setString(1, queue.getNameShortString().toString());
                        ResultSet rs = stmt.executeQuery();
                        try {
                            if (rs.next()) break block12;
                            PreparedStatement insertStmt = conn.prepareStatement(INSERT_INTO_QUEUE);
                            try {
                                String owner = queue.getOwner() == null ? null : queue.getOwner().toString();
                                insertStmt.setString(1, queue.getNameShortString().toString());
                                insertStmt.setString(2, owner);
                                insertStmt.setBoolean(3, queue.isExclusive());
                                byte[] underlying = arguments != null ? arguments.getDataAsBytes() : new byte[]{};
                                ByteArrayInputStream bis = new ByteArrayInputStream(underlying);
                                insertStmt.setBinaryStream(4, (InputStream)bis, underlying.length);
                                insertStmt.execute();
                            }
                            finally {
                                insertStmt.close();
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
                conn.close();
            }
            catch (SQLException e) {
                throw new AMQStoreException("Error writing AMQQueue with name " + queue.getNameShortString() + " to database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQueue(AMQQueue queue) throws AMQStoreException {
        block15: {
            if (this._state != State.RECOVERING) {
                try {
                    Connection conn = this.newAutoCommitConnection();
                    try {
                        PreparedStatement stmt = conn.prepareStatement(FIND_QUEUE);
                        try {
                            stmt.setString(1, queue.getNameShortString().toString());
                            ResultSet rs = stmt.executeQuery();
                            try {
                                if (!rs.next()) break block15;
                                PreparedStatement stmt2 = conn.prepareStatement(UPDATE_QUEUE_EXCLUSIVITY);
                                try {
                                    stmt2.setBoolean(1, queue.isExclusive());
                                    stmt2.setString(2, queue.getNameShortString().toString());
                                    stmt2.execute();
                                }
                                finally {
                                    stmt2.close();
                                }
                            }
                            finally {
                                rs.close();
                            }
                        }
                        finally {
                            stmt.close();
                        }
                    }
                    finally {
                        conn.close();
                    }
                }
                catch (SQLException e) {
                    throw new AMQStoreException("Error updating AMQQueue with name " + queue.getNameShortString() + " to database: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection newAutoCommitConnection() throws SQLException {
        Connection connection = this.newConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection newConnection() throws SQLException {
        Connection connection = this._basicDataSource.getConnection();
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
            }
            finally {
                throw sqlEx;
            }
        }
        return connection;
    }

    public void removeQueue(AMQQueue queue) throws AMQStoreException {
        AMQShortString name = queue.getNameShortString();
        _logger.debug((Object)("public void removeQueue(AMQShortString name = " + name + "): called"));
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_QUEUE);
            stmt.setString(1, name.toString());
            int results = stmt.executeUpdate();
            stmt.close();
            if (results == 0) {
                throw new AMQStoreException("Queue " + name + " not found");
            }
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error deleting AMQQueue with name " + name + " from database: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    _logger.error((Object)e);
                }
            }
        }
    }

    public TransactionLog.Transaction newTransaction() {
        return new JDBCTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMessage(ConnectionWrapper connWrapper, TransactionLogResource queue, Long messageId) throws AMQStoreException {
        String name = queue.getResourceName();
        Connection conn = connWrapper.getConnection();
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Enqueuing message " + messageId + " on queue " + name + "[Connection" + conn + "]"));
            }
            PreparedStatement stmt = conn.prepareStatement(INSERT_INTO_QUEUE_ENTRY);
            try {
                stmt.setString(1, name);
                stmt.setLong(2, messageId);
                stmt.executeUpdate();
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            _logger.error((Object)("Failed to enqueue: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error writing enqueued message with id " + messageId + " for queue " + name + " to database", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeueMessage(ConnectionWrapper connWrapper, TransactionLogResource queue, Long messageId) throws AMQStoreException {
        String name = queue.getResourceName();
        Connection conn = connWrapper.getConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_QUEUE_ENTRY);
            try {
                stmt.setString(1, name);
                stmt.setLong(2, messageId);
                int results = stmt.executeUpdate();
                if (results != 1) {
                    throw new AMQStoreException("Unable to find message with id " + messageId + " on queue " + name);
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Dequeuing message " + messageId + " on queue " + name));
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            _logger.error((Object)("Failed to dequeue: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error deleting enqueued message with id " + messageId + " for queue " + name + " from database", (Throwable)e);
        }
    }

    public void commitTran(ConnectionWrapper connWrapper) throws AMQStoreException {
        try {
            Connection conn = connWrapper.getConnection();
            conn.commit();
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)"commit tran completed");
            }
            conn.close();
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error commit tx: " + e.getMessage(), (Throwable)e);
        }
    }

    public TransactionLog.StoreFuture commitTranAsync(ConnectionWrapper connWrapper) throws AMQStoreException {
        this.commitTran(connWrapper);
        return new TransactionLog.StoreFuture(){

            public boolean isComplete() {
                return true;
            }

            public void waitForCompletion() {
            }
        };
    }

    public void abortTran(ConnectionWrapper connWrapper) throws AMQStoreException {
        if (connWrapper == null) {
            throw new AMQStoreException("Fatal internal error: transactional context is empty at abortTran");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("abort tran called: " + connWrapper.getConnection()));
        }
        try {
            Connection conn = connWrapper.getConnection();
            conn.rollback();
            conn.close();
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error aborting transaction: " + e.getMessage(), (Throwable)e);
        }
    }

    public Long getNewMessageId() {
        return this._messageId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMetaData(Connection conn, long messageId, StorableMessageMetaData metaData) throws SQLException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Adding metadata for message " + messageId));
        }
        PreparedStatement stmt = conn.prepareStatement(INSERT_INTO_META_DATA);
        try {
            stmt.setLong(1, messageId);
            int bodySize = 1 + metaData.getStorableSize();
            byte[] underlying = new byte[bodySize];
            underlying[0] = (byte)metaData.getType().ordinal();
            java.nio.ByteBuffer buf = java.nio.ByteBuffer.wrap(underlying);
            buf.position(1);
            buf = buf.slice();
            metaData.writeToBuffer(0, buf);
            ByteArrayInputStream bis = new ByteArrayInputStream(underlying);
            try {
                stmt.setBinaryStream(2, (InputStream)bis, underlying.length);
                int result = stmt.executeUpdate();
                if (result == 0) {
                    throw new RuntimeException("Unable to add meta data for message " + messageId);
                }
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
            }
        }
        finally {
            stmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverMessages(MessageStoreRecoveryHandler recoveryHandler) throws SQLException {
        Connection conn = this.newAutoCommitConnection();
        try {
            MessageStoreRecoveryHandler.StoredMessageRecoveryHandler messageHandler = recoveryHandler.begin();
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(SELECT_ALL_FROM_META_DATA);
                try {
                    long maxId = 0L;
                    while (rs.next()) {
                        long messageId = rs.getLong(1);
                        Blob dataAsBlob = rs.getBlob(2);
                        if (messageId > maxId) {
                            maxId = messageId;
                        }
                        byte[] dataAsBytes = dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
                        java.nio.ByteBuffer buf = java.nio.ByteBuffer.wrap(dataAsBytes);
                        buf.position(1);
                        buf = buf.slice();
                        MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                        StorableMessageMetaData metaData = type.getFactory().createMetaData(buf);
                        StoredJDBCMessage message = new StoredJDBCMessage(messageId, metaData, false);
                        messageHandler.message((StoredMessage)message);
                    }
                    this._messageId.set(maxId);
                    messageHandler.completeMessageRecovery();
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverQueueEntries(TransactionLogRecoveryHandler recoveryHandler) throws SQLException {
        Connection conn = this.newAutoCommitConnection();
        try {
            TransactionLogRecoveryHandler.QueueEntryRecoveryHandler queueEntryHandler = recoveryHandler.begin((TransactionLog)this);
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(SELECT_FROM_QUEUE_ENTRY);
                try {
                    while (rs.next()) {
                        String queueName = rs.getString(1);
                        long messageId = rs.getLong(2);
                        queueEntryHandler.queueEntry(queueName, messageId);
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
            queueEntryHandler.completeQueueEntryRecovery();
        }
        finally {
            conn.close();
        }
    }

    StorableMessageMetaData getMetaData(long messageId) throws SQLException {
        Connection conn = this.newAutoCommitConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement(SELECT_FROM_META_DATA);
            try {
                stmt.setLong(1, messageId);
                ResultSet rs = stmt.executeQuery();
                try {
                    if (rs.next()) {
                        Blob dataAsBlob = rs.getBlob(1);
                        byte[] dataAsBytes = dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
                        java.nio.ByteBuffer buf = java.nio.ByteBuffer.wrap(dataAsBytes);
                        buf.position(1);
                        buf = buf.slice();
                        MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                        StorableMessageMetaData storableMessageMetaData = type.getFactory().createMetaData(buf);
                        return storableMessageMetaData;
                    }
                    throw new RuntimeException("Meta data not found for message with id " + messageId);
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        finally {
            conn.close();
        }
    }

    private void addContent(Connection conn, long messageId, int offset, java.nio.ByteBuffer src) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Adding content chunk offset " + offset + " for message " + messageId));
        }
        try {
            src = src.slice();
            byte[] chunkData = new byte[src.limit()];
            src.duplicate().get(chunkData);
            PreparedStatement stmt = conn.prepareStatement(INSERT_INTO_MESSAGE_CONTENT);
            stmt.setLong(1, messageId);
            stmt.setInt(2, offset);
            stmt.setInt(3, offset + chunkData.length);
            ByteArrayInputStream bis = new ByteArrayInputStream(chunkData);
            stmt.setBinaryStream(4, (InputStream)bis, chunkData.length);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Error adding content chunk offset " + offset + " for message " + messageId + ": " + e.getMessage(), e);
        }
    }

    public int getContent(long messageId, int offset, java.nio.ByteBuffer dst) {
        Connection conn = null;
        try {
            conn = this.newAutoCommitConnection();
            PreparedStatement stmt = conn.prepareStatement(SELECT_FROM_MESSAGE_CONTENT);
            stmt.setLong(1, messageId);
            stmt.setInt(2, offset);
            stmt.setInt(3, offset + dst.remaining());
            ResultSet rs = stmt.executeQuery();
            int written = 0;
            while (rs.next()) {
                int offsetInMessage = rs.getInt(1);
                Blob dataAsBlob = rs.getBlob(2);
                int size = (int)dataAsBlob.length();
                byte[] dataAsBytes = dataAsBlob.getBytes(1L, size);
                int posInArray = offset + written - offsetInMessage;
                int count = size - posInArray;
                if (count > dst.remaining()) {
                    count = dst.remaining();
                }
                dst.put(dataAsBytes, posInArray, count);
                written += count;
                if (dst.remaining() != 0) continue;
                break;
            }
            stmt.close();
            conn.close();
            return written;
        }
        catch (SQLException e) {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    // empty catch block
                }
            }
            throw new RuntimeException("Error retrieving content from offset " + offset + " for message " + messageId + ": " + e.getMessage(), e);
        }
    }

    public boolean isPersistent() {
        return true;
    }

    private synchronized void stateTransition(State requiredState, State newState) throws AMQStoreException {
        if (this._state != requiredState) {
            throw new AMQStoreException("Cannot transition to the state: " + (Object)((Object)newState) + "; need to be in state: " + (Object)((Object)requiredState) + "; currently in state: " + (Object)((Object)this._state));
        }
        this._state = newState;
    }

    private class StoredJDBCMessage
    implements StoredMessage {
        private final long _messageId;
        private volatile SoftReference<StorableMessageMetaData> _metaDataRef;
        private Connection _conn;

        StoredJDBCMessage(long messageId, StorableMessageMetaData metaData) {
            this(messageId, metaData, true);
        }

        StoredJDBCMessage(long messageId, StorableMessageMetaData metaData, boolean persist) {
            try {
                this._messageId = messageId;
                this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
                if (persist) {
                    this._conn = JDBCMessageStore.this.newConnection();
                    JDBCMessageStore.this.storeMetaData(this._conn, messageId, metaData);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public StorableMessageMetaData getMetaData() {
            StorableMessageMetaData metaData = this._metaDataRef.get();
            if (metaData == null) {
                try {
                    metaData = JDBCMessageStore.this.getMetaData(this._messageId);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
            }
            return metaData;
        }

        public long getMessageNumber() {
            return this._messageId;
        }

        public void addContent(int offsetInMessage, java.nio.ByteBuffer src) {
            JDBCMessageStore.this.addContent(this._conn, this._messageId, offsetInMessage, src);
        }

        public int getContent(int offsetInMessage, java.nio.ByteBuffer dst) {
            return JDBCMessageStore.this.getContent(this._messageId, offsetInMessage, dst);
        }

        public TransactionLog.StoreFuture flushToStore() {
            try {
                if (this._conn != null) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Flushing message " + this._messageId + " to store"));
                    }
                    this._conn.commit();
                    this._conn.close();
                }
            }
            catch (SQLException e) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Error when trying to flush message " + this._messageId + " to store: " + e));
                }
                throw new RuntimeException(e);
            }
            finally {
                this._conn = null;
            }
            return MessageStore.IMMEDIATE_FUTURE;
        }

        public void remove() {
            this.flushToStore();
            JDBCMessageStore.this.removeMessage(this._messageId);
        }
    }

    private class JDBCTransaction
    implements TransactionLog.Transaction {
        private final ConnectionWrapper _connWrapper;

        private JDBCTransaction() {
            try {
                this._connWrapper = new ConnectionWrapper(JDBCMessageStore.this.newConnection());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public void enqueueMessage(TransactionLogResource queue, Long messageId) throws AMQStoreException {
            JDBCMessageStore.this.enqueueMessage(this._connWrapper, queue, messageId);
        }

        public void dequeueMessage(TransactionLogResource queue, Long messageId) throws AMQStoreException {
            JDBCMessageStore.this.dequeueMessage(this._connWrapper, queue, messageId);
        }

        public void commitTran() throws AMQStoreException {
            JDBCMessageStore.this.commitTran(this._connWrapper);
        }

        public TransactionLog.StoreFuture commitTranAsync() throws AMQStoreException {
            return JDBCMessageStore.this.commitTranAsync(this._connWrapper);
        }

        public void abortTran() throws AMQStoreException {
            JDBCMessageStore.this.abortTran(this._connWrapper);
        }
    }

    private static final class ConnectionWrapper {
        private final Connection _connection;

        public ConnectionWrapper(Connection conn) {
            this._connection = conn;
        }

        public Connection getConnection() {
            return this._connection;
        }
    }

    private static enum State {
        INITIAL,
        CONFIGURING,
        RECOVERING,
        STARTED,
        CLOSING,
        CLOSED;

    }
}

