/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.server.transport.ServerSessionDelegate;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionClose;
import org.apache.qpid.transport.ConnectionCloseCode;
import org.apache.qpid.transport.ConnectionOpen;
import org.apache.qpid.transport.ConnectionOpenOk;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ServerDelegate;
import org.apache.qpid.transport.SessionAttach;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnectionDelegate
extends ServerDelegate {
    private String _localFQDN;
    private final IApplicationRegistry _appRegistry;

    public ServerConnectionDelegate(IApplicationRegistry appRegistry, String localFQDN) {
        this(new HashMap<String, Object>(Collections.singletonMap("qpid.federation_tag", appRegistry.getBroker().getFederationTag())), Collections.singletonList("en_US"), appRegistry, localFQDN);
    }

    public ServerConnectionDelegate(Map<String, Object> properties, List<Object> locales, IApplicationRegistry appRegistry, String localFQDN) {
        super(properties, ServerConnectionDelegate.parseToList(appRegistry.getAuthenticationManager().getMechanisms()), locales);
        this._appRegistry = appRegistry;
        this._localFQDN = localFQDN;
    }

    private static List<Object> parseToList(String mechanisms) {
        ArrayList<Object> list = new ArrayList<Object>();
        StringTokenizer tokenizer = new StringTokenizer(mechanisms, " ");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    @Override
    public ServerSession getSession(Connection conn, SessionAttach atc) {
        ServerSessionDelegate serverSessionDelegate = new ServerSessionDelegate(this._appRegistry);
        ServerSession ssn = new ServerSession(conn, serverSessionDelegate, new Binary(atc.getName()), 0L);
        return ssn;
    }

    @Override
    protected SaslServer createSaslServer(String mechanism) throws SaslException {
        return this._appRegistry.getAuthenticationManager().createSaslServer(mechanism, this._localFQDN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionClose(Connection conn, ConnectionClose close) {
        try {
            ((ServerConnection)conn).logClosed();
        }
        finally {
            super.connectionClose(conn, close);
        }
    }

    @Override
    public void connectionOpen(Connection conn, ConnectionOpen open) {
        ServerConnection sconn = (ServerConnection)conn;
        String vhostName = open.hasVirtualHost() ? open.getVirtualHost() : "";
        VirtualHost vhost = this._appRegistry.getVirtualHostRegistry().getVirtualHost(vhostName);
        SecurityManager.setThreadPrincipal(conn.getAuthorizationID());
        if (vhost != null) {
            sconn.setVirtualHost(vhost);
            if (!vhost.getSecurityManager().accessVirtualhost(vhostName, ((ProtocolEngine)((Object)sconn.getConfig())).getRemoteAddress())) {
                sconn.invoke(new ConnectionClose(ConnectionCloseCode.CONNECTION_FORCED, "Permission denied '" + vhostName + "'", new Option[0]));
                sconn.setState(Connection.State.CLOSING);
            } else {
                sconn.invoke(new ConnectionOpenOk(Collections.<Object>emptyList(), new Option[0]));
                sconn.setState(Connection.State.OPEN);
            }
        } else {
            sconn.invoke(new ConnectionClose(ConnectionCloseCode.INVALID_PATH, "Unknown virtualhost '" + vhostName + "'", new Option[0]));
            sconn.setState(Connection.State.CLOSING);
        }
    }

    @Override
    protected int getHeartbeatMax() {
        return 0;
    }

    @Override
    protected int getChannelMax() {
        return ApplicationRegistry.getInstance().getConfiguration().getMaxChannelCount();
    }
}

