/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import org.apache.qpid.AMQException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.subscription.ClientDeliveryMethod;
import org.apache.qpid.server.subscription.RecordDeliveryMethod;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.subscription.SubscriptionFactory;
import org.apache.qpid.server.subscription.SubscriptionImpl;

public class SubscriptionFactoryImpl
implements SubscriptionFactory {
    public static final SubscriptionFactoryImpl INSTANCE = new SubscriptionFactoryImpl();

    public Subscription createSubscription(int channelId, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager) throws AMQException {
        AMQChannel channel = protocolSession.getChannel(channelId);
        if (channel == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "channel :" + channelId + " not found in protocol session");
        }
        ClientDeliveryMethod clientMethod = channel.getClientDeliveryMethod();
        RecordDeliveryMethod recordMethod = channel.getRecordDeliveryMethod();
        return this.createSubscription(channel, protocolSession, consumerTag, acks, filters, noLocal, creditManager, clientMethod, recordMethod);
    }

    public Subscription createSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod clientMethod, RecordDeliveryMethod recordMethod) throws AMQException {
        Boolean isBrowserObj;
        boolean isBrowser = filters != null ? (isBrowserObj = (Boolean)filters.get(AMQPFilterTypes.NO_CONSUME.getValue())) != null && isBrowserObj != false : false;
        if (isBrowser) {
            return new SubscriptionImpl.BrowserSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
        }
        if (acks) {
            return new SubscriptionImpl.AckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
        }
        return new SubscriptionImpl.NoAckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod);
    }
}

