/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.sasl;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;

public class UsernamePrincipal
implements Principal {
    private final String _name;

    public UsernamePrincipal(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this._name;
    }

    public int hashCode() {
        int prime = 31;
        return 31 * this._name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UsernamePrincipal) {
            UsernamePrincipal other = (UsernamePrincipal)obj;
            return this._name.equals(other._name);
        }
        return false;
    }

    public static UsernamePrincipal getUsernamePrincipalFromSubject(Subject authSubject) {
        if (authSubject == null) {
            throw new IllegalArgumentException("No authenticated subject.");
        }
        Set<UsernamePrincipal> principals = authSubject.getPrincipals(UsernamePrincipal.class);
        if (principals.size() != 1) {
            throw new IllegalArgumentException("Can't find single UsernamePrincipal in authenticated subject");
        }
        return principals.iterator().next();
    }
}

