/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.qmf.QMFService;
import org.apache.qpid.server.configuration.BrokerConfig;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfigurationManager;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.SystemConfig;
import org.apache.qpid.server.configuration.SystemConfigImpl;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.logging.CompositeStartupMessageLogger;
import org.apache.qpid.server.logging.Log4jMessageLogger;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractActor;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.management.ManagedObjectRegistry;
import org.apache.qpid.server.management.NoopManagedObjectRegistry;
import org.apache.qpid.server.plugins.PluginManager;
import org.apache.qpid.server.registry.BrokerConfigAdapter;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.auth.database.ConfigurationFilePrincipalDatabaseManager;
import org.apache.qpid.server.security.auth.database.PrincipalDatabaseManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

public abstract class ApplicationRegistry
implements IApplicationRegistry {
    protected static final Logger _logger = Logger.getLogger(ApplicationRegistry.class);
    private static Map<Integer, IApplicationRegistry> _instanceMap = new HashMap<Integer, IApplicationRegistry>();
    protected final ServerConfiguration _configuration;
    public static final int DEFAULT_INSTANCE = 1;
    protected final Map<InetSocketAddress, QpidAcceptor> _acceptors = new HashMap<InetSocketAddress, QpidAcceptor>();
    protected ManagedObjectRegistry _managedObjectRegistry;
    protected AuthenticationManager _authenticationManager;
    protected VirtualHostRegistry _virtualHostRegistry;
    protected SecurityManager _securityManager;
    protected PrincipalDatabaseManager _databaseManager;
    protected PluginManager _pluginManager;
    protected ConfigurationManager _configurationManager;
    protected RootMessageLogger _rootMessageLogger;
    protected CompositeStartupMessageLogger _startupMessageLogger;
    protected UUID _brokerId = UUID.randomUUID();
    protected QMFService _qmfService;
    private BrokerConfig _broker;
    private ConfigStore _configStore;
    protected String _registryName;
    private Timer _reportingTimer;
    private boolean _statisticsEnabled = false;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private static Thread _shutdownHook = new Thread(new ShutdownService());

    public static Thread getShutdownHook() {
        return _shutdownHook;
    }

    public static void initialise(IApplicationRegistry instance) throws Exception {
        ApplicationRegistry.initialise(instance, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialise(IApplicationRegistry instance, int instanceID) throws Exception {
        if (instance != null) {
            _logger.info((Object)("Initialising Application Registry(" + instance + "):" + instanceID));
            _instanceMap.put(instanceID, instance);
            ConfigStore store = ConfigStore.newInstance();
            store.setRoot(new SystemConfigImpl(store));
            instance.setConfigStore(store);
            BrokerConfigAdapter broker = new BrokerConfigAdapter(instance);
            SystemConfig system = store.getRoot();
            system.addBroker(broker);
            instance.setBroker(broker);
            try {
                instance.initialise(instanceID);
            }
            catch (Exception e) {
                _instanceMap.remove(instanceID);
                try {
                    system.removeBroker(broker);
                }
                finally {
                    throw e;
                }
            }
        } else {
            ApplicationRegistry.remove(instanceID);
        }
    }

    public ConfigStore getConfigStore() {
        return this._configStore;
    }

    public void setConfigStore(ConfigStore configStore) {
        this._configStore = configStore;
    }

    public static boolean isConfigured() {
        return ApplicationRegistry.isConfigured(1);
    }

    public static boolean isConfigured(int instanceID) {
        return _instanceMap.containsKey(instanceID);
    }

    public static void remove() {
        ApplicationRegistry.remove(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(int instanceID) {
        try {
            IApplicationRegistry instance = _instanceMap.get(instanceID);
            if (instance != null) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Shutting down ApplicationRegistry(" + instanceID + "):" + instance));
                }
                instance.close();
                instance.getBroker().getSystem().removeBroker(instance.getBroker());
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error shutting down Application Registry(" + instanceID + "): " + e), (Throwable)e);
        }
        finally {
            _instanceMap.remove(instanceID);
        }
    }

    public static void removeAll() {
        Object[] keys;
        for (Object k : keys = _instanceMap.keySet().toArray()) {
            ApplicationRegistry.remove((Integer)k);
        }
    }

    protected ApplicationRegistry(ServerConfiguration configuration) {
        this._configuration = configuration;
    }

    public void configure() throws ConfigurationException {
        this._configurationManager = new ConfigurationManager();
        try {
            this._pluginManager = new PluginManager(this._configuration.getPluginDirectory(), this._configuration.getCacheDirectory());
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        this._configuration.initialise();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise(int instanceID) throws Exception {
        this._rootMessageLogger = new Log4jMessageLogger(this._configuration);
        this._registryName = String.valueOf(instanceID);
        RootMessageLogger[] messageLoggers = new RootMessageLogger[]{this._rootMessageLogger};
        this._startupMessageLogger = new CompositeStartupMessageLogger(messageLoggers);
        CurrentActor.set(new BrokerActor(this._startupMessageLogger));
        try {
            this.configure();
            this._qmfService = new QMFService(this.getConfigStore(), this);
            CurrentActor.get().message(BrokerMessages.STARTUP(QpidProperties.getReleaseVersion(), QpidProperties.getBuildVersion()));
            this.initialiseManagedObjectRegistry();
            this._virtualHostRegistry = new VirtualHostRegistry(this);
            this._securityManager = new SecurityManager(this._configuration, this._pluginManager);
            this.createDatabaseManager(this._configuration);
            this._authenticationManager = new PrincipalDatabaseAuthenticationManager();
            this._databaseManager.initialiseManagement(this._configuration);
            this._managedObjectRegistry.start();
        }
        finally {
            CurrentActor.remove();
        }
        CurrentActor.set(new BrokerActor(this._rootMessageLogger));
        try {
            this.initialiseVirtualHosts();
            this.initialiseStatistics();
            this.initialiseStatisticsReporting();
        }
        finally {
            CurrentActor.remove();
        }
    }

    protected void createDatabaseManager(ServerConfiguration configuration) throws Exception {
        this._databaseManager = new ConfigurationFilePrincipalDatabaseManager(this._configuration);
    }

    protected void initialiseVirtualHosts() throws Exception {
        for (String name : this._configuration.getVirtualHosts()) {
            this.createVirtualHost(this._configuration.getVirtualHostConfig(name));
        }
        this.getVirtualHostRegistry().setDefaultVirtualHostName(this._configuration.getDefaultVirtualHost());
    }

    protected void initialiseManagedObjectRegistry() throws AMQException {
        this._managedObjectRegistry = new NoopManagedObjectRegistry();
    }

    public void initialiseStatisticsReporting() {
        long report = this._configuration.getStatisticsReportingPeriod() * 1000L;
        final boolean broker = this._configuration.isStatisticsGenerationBrokerEnabled();
        final boolean virtualhost = this._configuration.isStatisticsGenerationVirtualhostsEnabled();
        final boolean reset = this._configuration.isStatisticsReportResetEnabled();
        if (report > 0L && (broker || virtualhost)) {
            this._reportingTimer = new Timer("Statistics-Reporting", true);
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class StatisticsReportingTask
            extends TimerTask {
                private final int DELIVERED = 0;
                private final int RECEIVED = 1;

                StatisticsReportingTask() {
                }

                @Override
                public void run() {
                    CurrentActor.set(new AbstractActor(ApplicationRegistry.getInstance().getRootMessageLogger()){

                        public String getLogMessage() {
                            return "[" + Thread.currentThread().getName() + "] ";
                        }
                    });
                    if (broker) {
                        CurrentActor.get().message(BrokerMessages.STATS_DATA(0, ApplicationRegistry.this._dataDelivered.getPeak() / 1024.0, ApplicationRegistry.this._dataDelivered.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_MSGS(0, ApplicationRegistry.this._messagesDelivered.getPeak(), ApplicationRegistry.this._messagesDelivered.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_DATA(1, ApplicationRegistry.this._dataReceived.getPeak() / 1024.0, ApplicationRegistry.this._dataReceived.getTotal()));
                        CurrentActor.get().message(BrokerMessages.STATS_MSGS(1, ApplicationRegistry.this._messagesReceived.getPeak(), ApplicationRegistry.this._messagesReceived.getTotal()));
                    }
                    if (virtualhost) {
                        for (VirtualHost vhost : ApplicationRegistry.this.getVirtualHostRegistry().getVirtualHosts()) {
                            String name = vhost.getName();
                            StatisticsCounter dataDelivered = vhost.getDataDeliveryStatistics();
                            StatisticsCounter messagesDelivered = vhost.getMessageDeliveryStatistics();
                            StatisticsCounter dataReceived = vhost.getDataReceiptStatistics();
                            StatisticsCounter messagesReceived = vhost.getMessageReceiptStatistics();
                            CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 0, dataDelivered.getPeak() / 1024.0, dataDelivered.getTotal()));
                            CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 0, messagesDelivered.getPeak(), messagesDelivered.getTotal()));
                            CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 1, dataReceived.getPeak() / 1024.0, dataReceived.getTotal()));
                            CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 1, messagesReceived.getPeak(), messagesReceived.getTotal()));
                        }
                    }
                    if (reset) {
                        ApplicationRegistry.this.resetStatistics();
                    }
                    CurrentActor.remove();
                }
            }
            this._reportingTimer.scheduleAtFixedRate((TimerTask)new StatisticsReportingTask(), report / 2L, report);
        }
    }

    public static IApplicationRegistry getInstance() {
        return ApplicationRegistry.getInstance(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IApplicationRegistry getInstance(int instanceID) {
        Class<IApplicationRegistry> clazz = IApplicationRegistry.class;
        synchronized (IApplicationRegistry.class) {
            IApplicationRegistry instance = _instanceMap.get(instanceID);
            if (instance == null) {
                throw new IllegalStateException("Application Registry (" + instanceID + ") not created");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private void close(Closeable close) {
        try {
            if (close != null) {
                close.close();
            }
        }
        catch (Throwable e) {
            _logger.error((Object)("Error thrown whilst closing " + close.getClass().getSimpleName()), e);
        }
    }

    public void close() {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Shutting down ApplicationRegistry:" + this));
        }
        if (this._reportingTimer != null) {
            this._reportingTimer.cancel();
        }
        this.unbind();
        this.close(this._virtualHostRegistry);
        this.close(this._authenticationManager);
        this.close(this._managedObjectRegistry);
        this.close(this._qmfService);
        this.close(this._pluginManager);
        CurrentActor.get().message(BrokerMessages.STOPPED());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        Map<InetSocketAddress, QpidAcceptor> map = this._acceptors;
        synchronized (map) {
            for (InetSocketAddress bindAddress : this._acceptors.keySet()) {
                QpidAcceptor acceptor = this._acceptors.get(bindAddress);
                try {
                    acceptor.getNetworkDriver().close();
                }
                catch (Throwable e) {
                    _logger.error((Object)("Unable to close network driver due to:" + e.getMessage()));
                }
                CurrentActor.get().message(BrokerMessages.SHUTTING_DOWN(acceptor.toString(), bindAddress.getPort()));
            }
        }
    }

    public ServerConfiguration getConfiguration() {
        return this._configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAcceptor(InetSocketAddress bindAddress, QpidAcceptor acceptor) {
        Map<InetSocketAddress, QpidAcceptor> map = this._acceptors;
        synchronized (map) {
            this._acceptors.put(bindAddress, acceptor);
        }
    }

    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    public ManagedObjectRegistry getManagedObjectRegistry() {
        return this._managedObjectRegistry;
    }

    public PrincipalDatabaseManager getDatabaseManager() {
        return this._databaseManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this._authenticationManager;
    }

    public PluginManager getPluginManager() {
        return this._pluginManager;
    }

    public ConfigurationManager getConfigurationManager() {
        return this._configurationManager;
    }

    public RootMessageLogger getRootMessageLogger() {
        return this._rootMessageLogger;
    }

    public RootMessageLogger getCompositeStartupMessageLogger() {
        return this._startupMessageLogger;
    }

    public UUID getBrokerId() {
        return this._brokerId;
    }

    public QMFService getQMFService() {
        return this._qmfService;
    }

    public BrokerConfig getBroker() {
        return this._broker;
    }

    public void setBroker(BrokerConfig broker) {
        this._broker = broker;
    }

    public VirtualHost createVirtualHost(VirtualHostConfiguration vhostConfig) throws Exception {
        VirtualHostImpl virtualHost = new VirtualHostImpl(this, vhostConfig);
        this._virtualHostRegistry.registerVirtualHost(virtualHost);
        this.getBroker().addVirtualHost(virtualHost);
        return virtualHost;
    }

    public void registerMessageDelivered(long messageSize) {
        if (this.isStatisticsEnabled()) {
            this._messagesDelivered.registerEvent(1L);
            this._dataDelivered.registerEvent(messageSize);
        }
    }

    public void registerMessageReceived(long messageSize, long timestamp) {
        if (this.isStatisticsEnabled()) {
            this._messagesReceived.registerEvent(1L, timestamp);
            this._dataReceived.registerEvent(messageSize, timestamp);
        }
    }

    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (VirtualHost vhost : this._virtualHostRegistry.getVirtualHosts()) {
            vhost.resetStatistics();
        }
    }

    public void initialiseStatistics() {
        this.setStatisticsEnabled(!StatisticsCounter.DISABLE_STATISTICS && this.getConfiguration().isStatisticsGenerationBrokerEnabled());
        this._messagesDelivered = new StatisticsCounter("messages-delivered");
        this._dataDelivered = new StatisticsCounter("bytes-delivered");
        this._messagesReceived = new StatisticsCounter("messages-received");
        this._dataReceived = new StatisticsCounter("bytes-received");
    }

    public boolean isStatisticsEnabled() {
        return this._statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean enabled) {
        this._statisticsEnabled = enabled;
    }

    static {
        Runtime.getRuntime().addShutdownHook(_shutdownHook);
    }

    private static class ShutdownService
    implements Runnable {
        private ShutdownService() {
        }

        public void run() {
            ApplicationRegistry.removeAll();
        }
    }
}

