/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultQueueRegistry
implements QueueRegistry {
    private ConcurrentMap<AMQShortString, AMQQueue> _queueMap = new ConcurrentHashMap<AMQShortString, AMQQueue>();
    private final VirtualHost _virtualHost;

    public DefaultQueueRegistry(VirtualHost virtualHost) {
        this._virtualHost = virtualHost;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void registerQueue(AMQQueue queue) {
        this._queueMap.put(queue.getNameShortString(), queue);
    }

    @Override
    public void unregisterQueue(AMQShortString name) {
        this._queueMap.remove(name);
    }

    @Override
    public AMQQueue getQueue(AMQShortString name) {
        return (AMQQueue)this._queueMap.get(name);
    }

    @Override
    public Collection<AMQShortString> getQueueNames() {
        return this._queueMap.keySet();
    }

    @Override
    public Collection<AMQQueue> getQueues() {
        return this._queueMap.values();
    }

    @Override
    public AMQQueue getQueue(String queue) {
        return this.getQueue(new AMQShortString(queue));
    }
}

