/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.JMException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.qpid.AMQChannelException;
import org.apache.qpid.AMQConnectionException;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.codec.AMQCodecFactory;
import org.apache.qpid.common.ClientProperties;
import org.apache.qpid.framing.AMQBody;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQProtocolHeaderException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ChannelCloseBody;
import org.apache.qpid.framing.ChannelCloseOkBody;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.HeartbeatBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.ProtocolInitiation;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.pool.Job;
import org.apache.qpid.pool.ReferenceCountingExecutorService;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.protocol.AMQMethodListener;
import org.apache.qpid.protocol.ProtocolEngine;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.configuration.ConfigStore;
import org.apache.qpid.server.configuration.ConfiguredObject;
import org.apache.qpid.server.configuration.ConnectionConfig;
import org.apache.qpid.server.configuration.ConnectionConfigType;
import org.apache.qpid.server.handler.ServerMethodDispatcherImpl;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.AMQPConnectionActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.ManagementActor;
import org.apache.qpid.server.logging.messages.ConnectionMessages;
import org.apache.qpid.server.logging.subjects.ConnectionLogSubject;
import org.apache.qpid.server.management.Managable;
import org.apache.qpid.server.management.ManagedObject;
import org.apache.qpid.server.output.ProtocolOutputConverter;
import org.apache.qpid.server.output.ProtocolOutputConverterRegistry;
import org.apache.qpid.server.protocol.AMQNoMethodHandlerException;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.protocol.AMQProtocolSessionMBean;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.state.AMQState;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;
import org.apache.qpid.transport.NetworkDriver;
import org.apache.qpid.transport.Sender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQProtocolEngine
implements ProtocolEngine,
Managable,
AMQProtocolSession,
ConnectionConfig {
    private static final Logger _logger = Logger.getLogger(AMQProtocolEngine.class);
    private static final String CLIENT_PROPERTIES_INSTANCE = ClientProperties.instance.toString();
    private static final AtomicLong idGenerator = new AtomicLong(0L);
    private static final int CHANNEL_CACHE_SIZE = 255;
    private AMQShortString _contextKey;
    private AMQShortString _clientVersion = null;
    private VirtualHost _virtualHost;
    private final Map<Integer, AMQChannel> _channelMap = new HashMap<Integer, AMQChannel>();
    private final AMQChannel[] _cachedChannels = new AMQChannel[256];
    private final CopyOnWriteArraySet<AMQMethodListener> _frameListeners = new CopyOnWriteArraySet();
    private final AMQStateManager _stateManager;
    private AMQCodecFactory _codecFactory;
    private AMQProtocolSessionMBean _managedObject;
    private SaslServer _saslServer;
    private Object _lastReceived;
    private Object _lastSent;
    protected volatile boolean _closed;
    private long _maxNoOfChannels = ApplicationRegistry.getInstance().getConfiguration().getMaxChannelCount();
    private ProtocolVersion _protocolVersion = ProtocolVersion.getLatestSupportedVersion();
    private FieldTable _clientProperties;
    private final List<AMQProtocolSession.Task> _taskList = new CopyOnWriteArrayList<AMQProtocolSession.Task>();
    private Map<Integer, Long> _closingChannelsList = new ConcurrentHashMap<Integer, Long>();
    private ProtocolOutputConverter _protocolOutputConverter;
    private Principal _authorizedID;
    private MethodDispatcher _dispatcher;
    private AMQProtocolSession.ProtocolSessionIdentifier _sessionIdentifier;
    private final long _sessionID = idGenerator.getAndIncrement();
    private AMQPConnectionActor _actor;
    private LogSubject _logSubject;
    private NetworkDriver _networkDriver;
    private long _lastIoTime;
    private long _writtenBytes;
    private long _readBytes;
    private Job _readJob;
    private Job _writeJob;
    private ReferenceCountingExecutorService _poolReference = ReferenceCountingExecutorService.getInstance();
    private long _maxFrameSize;
    private final AtomicBoolean _closing = new AtomicBoolean(false);
    private final UUID _id;
    private final ConfigStore _configStore;
    private long _createTime = System.currentTimeMillis();
    private ApplicationRegistry _registry;
    private boolean _statisticsEnabled = false;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;

    @Override
    public ManagedObject getManagedObject() {
        return this._managedObject;
    }

    public AMQProtocolEngine(VirtualHostRegistry virtualHostRegistry, NetworkDriver driver) {
        this._stateManager = new AMQStateManager(virtualHostRegistry, this);
        this._networkDriver = driver;
        this._codecFactory = new AMQCodecFactory(true, this);
        this._poolReference.acquireExecutorService();
        this._readJob = new Job(this._poolReference, Job.MAX_JOB_EVENTS, true);
        this._writeJob = new Job(this._poolReference, Job.MAX_JOB_EVENTS, false);
        this._actor = new AMQPConnectionActor(this, virtualHostRegistry.getApplicationRegistry().getRootMessageLogger());
        this._logSubject = new ConnectionLogSubject(this);
        this._configStore = virtualHostRegistry.getConfigStore();
        this._id = this._configStore.createId();
        this._actor.message(ConnectionMessages.OPEN(null, null, false, false));
        this._registry = virtualHostRegistry.getApplicationRegistry();
        this.initialiseStatistics();
    }

    private AMQProtocolSessionMBean createMBean() throws JMException {
        return new AMQProtocolSessionMBean(this);
    }

    @Override
    public long getSessionID() {
        return this._sessionID;
    }

    @Override
    public LogActor getLogActor() {
        return this._actor;
    }

    @Override
    public void setMaxFrameSize(long frameMax) {
        this._maxFrameSize = frameMax;
    }

    @Override
    public long getMaxFrameSize() {
        return this._maxFrameSize;
    }

    @Override
    public boolean isClosing() {
        return this._closing.get();
    }

    @Override
    public void received(ByteBuffer msg) {
        this._lastIoTime = System.currentTimeMillis();
        try {
            final ArrayList<AMQDataBlock> dataBlocks = this._codecFactory.getDecoder().decodeBuffer(msg);
            Job.fireAsynchEvent(this._poolReference.getPool(), this._readJob, new Runnable(){

                public void run() {
                    for (AMQDataBlock dataBlock : dataBlocks) {
                        try {
                            AMQProtocolEngine.this.dataBlockReceived(dataBlock);
                        }
                        catch (Exception e) {
                            _logger.error((Object)"Unexpected exception when processing datablock", (Throwable)e);
                            AMQProtocolEngine.this.closeProtocolSession();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            _logger.error((Object)"Unexpected exception when processing datablock", (Throwable)e);
            this.closeProtocolSession();
        }
    }

    @Override
    public void dataBlockReceived(AMQDataBlock message) throws Exception {
        this._lastReceived = message;
        if (message instanceof ProtocolInitiation) {
            this.protocolInitiationReceived((ProtocolInitiation)message);
        } else if (message instanceof AMQFrame) {
            AMQFrame frame = (AMQFrame)message;
            this.frameReceived(frame);
        } else {
            throw new AMQException("Unknown message type: " + message.getClass().getName() + ": " + message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frameReceived(AMQFrame frame) throws AMQException {
        int channelId = frame.getChannel();
        AMQBody body = frame.getBodyFrame();
        LogActor channelActor = null;
        if (this._channelMap.get(channelId) != null) {
            channelActor = this._channelMap.get(channelId).getLogActor();
        }
        CurrentActor.set(channelActor == null ? this._actor : channelActor);
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Frame Received: " + frame));
            }
            if (this.channelAwaitingClosure(channelId)) {
                if (frame.getBodyFrame() instanceof ChannelCloseOkBody) {
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Channel[" + channelId + "] awaiting closure - processing close-ok"));
                    }
                } else {
                    return;
                }
            }
            try {
                body.handle(channelId, this);
            }
            catch (AMQException e) {
                this.closeChannel(channelId);
                throw e;
            }
        }
        finally {
            CurrentActor.remove();
        }
    }

    private void protocolInitiationReceived(ProtocolInitiation pi) {
        this._codecFactory.getDecoder().setExpectProtocolInitiation(false);
        try {
            this._actor.message(ConnectionMessages.OPEN(null, pi._protocolMajor + "-" + pi._protocolMinor, false, true));
            ProtocolVersion pv = pi.checkVersion();
            this.setProtocolVersion(pv);
            String mechanisms = ApplicationRegistry.getInstance().getAuthenticationManager().getMechanisms();
            String locales = "en_US";
            ConnectionStartBody responseBody = this.getMethodRegistry().createConnectionStartBody(this.getProtocolMajorVersion(), pv.getActualMinorVersion(), null, mechanisms.getBytes(), locales.getBytes());
            this._networkDriver.send(responseBody.generateFrame(0).toNioByteBuffer());
        }
        catch (AMQException e) {
            _logger.info((Object)("Received unsupported protocol initiation for protocol version: " + this.getProtocolVersion()));
            this._networkDriver.send(new ProtocolInitiation(ProtocolVersion.getLatestSupportedVersion()).toNioByteBuffer());
        }
    }

    @Override
    public void methodFrameReceived(int channelId, AMQMethodBody methodBody) {
        block14: {
            AMQMethodEvent<AMQMethodBody> evt = new AMQMethodEvent<AMQMethodBody>(channelId, methodBody);
            try {
                try {
                    boolean wasAnyoneInterested = this._stateManager.methodReceived(evt);
                    if (!this._frameListeners.isEmpty()) {
                        for (AMQMethodListener listener : this._frameListeners) {
                            wasAnyoneInterested = listener.methodReceived(evt) || wasAnyoneInterested;
                        }
                    }
                    if (!wasAnyoneInterested) {
                        throw new AMQNoMethodHandlerException(evt);
                    }
                }
                catch (AMQChannelException e) {
                    if (this.getChannel(channelId) != null) {
                        if (_logger.isInfoEnabled()) {
                            _logger.info((Object)("Closing channel due to: " + e.getMessage()));
                        }
                        this.writeFrame(e.getCloseFrame(channelId));
                        this.closeChannel(channelId);
                        break block14;
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("ChannelException occured on non-existent channel:" + e.getMessage()));
                    }
                    if (_logger.isInfoEnabled()) {
                        _logger.info((Object)("Closing connection due to: " + e.getMessage()));
                    }
                    AMQConnectionException ce = evt.getMethod().getConnectionException(AMQConstant.CHANNEL_ERROR, AMQConstant.CHANNEL_ERROR.getName().toString());
                    _logger.info((Object)(e.getMessage() + " whilst processing:" + methodBody));
                    this.closeConnection(channelId, ce, false);
                }
                catch (AMQConnectionException e) {
                    _logger.info((Object)(e.getMessage() + " whilst processing:" + methodBody));
                    this.closeConnection(channelId, e, false);
                }
                catch (AMQSecurityException e) {
                    AMQConnectionException ce = evt.getMethod().getConnectionException(AMQConstant.ACCESS_REFUSED, e.getMessage());
                    _logger.info((Object)(e.getMessage() + " whilst processing:" + methodBody));
                    this.closeConnection(channelId, ce, false);
                }
            }
            catch (Exception e) {
                for (AMQMethodListener listener : this._frameListeners) {
                    listener.error(e);
                }
                _logger.error((Object)"Unexpected exception while processing frame.  Closing connection.", (Throwable)e);
                this.closeProtocolSession();
            }
        }
    }

    @Override
    public void contentHeaderReceived(int channelId, ContentHeaderBody body) throws AMQException {
        AMQChannel channel = this.getAndAssertChannel(channelId);
        channel.publishContentHeader(body);
    }

    @Override
    public void contentBodyReceived(int channelId, ContentBody body) throws AMQException {
        AMQChannel channel = this.getAndAssertChannel(channelId);
        channel.publishContentBody(body);
    }

    @Override
    public void heartbeatBodyReceived(int channelId, HeartbeatBody body) {
    }

    @Override
    public void writeFrame(AMQDataBlock frame) {
        this._lastSent = frame;
        final ByteBuffer buf = frame.toNioByteBuffer();
        this._lastIoTime = System.currentTimeMillis();
        this._writtenBytes += (long)buf.remaining();
        Job.fireAsynchEvent(this._poolReference.getPool(), this._writeJob, new Runnable(){

            public void run() {
                AMQProtocolEngine.this._networkDriver.send(buf);
            }
        });
    }

    @Override
    public AMQShortString getContextKey() {
        return this._contextKey;
    }

    @Override
    public void setContextKey(AMQShortString contextKey) {
        this._contextKey = contextKey;
    }

    @Override
    public List<AMQChannel> getChannels() {
        return new ArrayList<AMQChannel>(this._channelMap.values());
    }

    public AMQChannel getAndAssertChannel(int channelId) throws AMQException {
        AMQChannel channel = this.getChannel(channelId);
        if (channel == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "Channel not found with id:" + channelId);
        }
        return channel;
    }

    @Override
    public AMQChannel getChannel(int channelId) {
        AMQChannel channel;
        AMQChannel aMQChannel = channel = (channelId & 0xFF) == channelId ? this._cachedChannels[channelId] : this._channelMap.get(channelId);
        if (channel == null || channel.isClosing()) {
            return null;
        }
        return channel;
    }

    @Override
    public boolean channelAwaitingClosure(int channelId) {
        return !this._closingChannelsList.isEmpty() && this._closingChannelsList.containsKey(channelId);
    }

    @Override
    public void addChannel(AMQChannel channel) throws AMQException {
        if (this._closed) {
            throw new AMQException("Session is closed");
        }
        int channelId = channel.getChannelId();
        if (this._closingChannelsList.containsKey(channelId)) {
            throw new AMQException("Session is marked awaiting channel close");
        }
        if ((long)this._channelMap.size() == this._maxNoOfChannels) {
            String errorMessage = this.toString() + ": maximum number of channels has been reached (" + this._maxNoOfChannels + "); can't create channel";
            _logger.error((Object)errorMessage);
            throw new AMQException(AMQConstant.NOT_ALLOWED, errorMessage);
        }
        this._channelMap.put(channel.getChannelId(), channel);
        if ((channelId & 0xFF) == channelId) {
            this._cachedChannels[channelId] = channel;
        }
        this.checkForNotification();
    }

    private void checkForNotification() {
        int channelsCount = this._channelMap.size();
        if (this._managedObject != null && (long)channelsCount >= this._maxNoOfChannels) {
            this._managedObject.notifyClients("Channel count (" + channelsCount + ") has reached the threshold value");
        }
    }

    @Override
    public Long getMaximumNumberOfChannels() {
        return this._maxNoOfChannels;
    }

    @Override
    public void setMaximumNumberOfChannels(Long value) {
        this._maxNoOfChannels = value;
    }

    @Override
    public void commitTransactions(AMQChannel channel) throws AMQException {
        if (channel != null && channel.isTransactional()) {
            channel.commit();
        }
    }

    @Override
    public void rollbackTransactions(AMQChannel channel) throws AMQException {
        if (channel != null && channel.isTransactional()) {
            channel.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeChannel(int channelId) throws AMQException {
        AMQChannel channel = this.getChannel(channelId);
        if (channel == null) {
            throw new IllegalArgumentException("Unknown channel id");
        }
        try {
            channel.close();
            this.markChannelAwaitingCloseOk(channelId);
        }
        finally {
            this.removeChannel(channelId);
        }
    }

    @Override
    public void closeChannelOk(int channelId) {
        this._closingChannelsList.remove(channelId);
    }

    private void markChannelAwaitingCloseOk(int channelId) {
        this._closingChannelsList.put(channelId, System.currentTimeMillis());
    }

    @Override
    public void removeChannel(int channelId) {
        this._channelMap.remove(channelId);
        if ((channelId & 0xFF) == channelId) {
            this._cachedChannels[channelId] = null;
        }
    }

    @Override
    public void initHeartbeats(int delay) {
        if (delay > 0) {
            this._networkDriver.setMaxWriteIdle(delay);
            this._networkDriver.setMaxReadIdle((int)(ApplicationRegistry.getInstance().getConfiguration().getHeartBeatTimeout() * (double)delay));
        }
    }

    private void closeAllChannels() throws AMQException {
        for (AMQChannel channel : this._channelMap.values()) {
            channel.close();
        }
        this._channelMap.clear();
        for (int i = 0; i <= 255; ++i) {
            this._cachedChannels[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSession() throws AMQException {
        if (this._closing.compareAndSet(false, true)) {
            if (CurrentActor.get() == null) {
                CurrentActor.set(this._actor);
            }
            if (!this._closed) {
                if (this._virtualHost != null) {
                    this._virtualHost.getConnectionRegistry().deregisterConnection(this);
                }
                this.closeAllChannels();
                this.getConfigStore().removeConfiguredObject(this);
                if (this._managedObject != null) {
                    this._managedObject.unregister();
                    this._managedObject = null;
                }
                for (AMQProtocolSession.Task task : this._taskList) {
                    task.doTask(this);
                }
                AMQProtocolEngine aMQProtocolEngine = this;
                synchronized (aMQProtocolEngine) {
                    this._closed = true;
                    this.notifyAll();
                }
                this._poolReference.releaseExecutorService();
                CurrentActor.get().message(this._logSubject, ConnectionMessages.CLOSE());
            }
        } else {
            AMQProtocolEngine aMQProtocolEngine = this;
            synchronized (aMQProtocolEngine) {
                while (!this._closed) {
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @Override
    public void closeConnection(int channelId, AMQConnectionException e, boolean closeProtocolSession) throws AMQException {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Closing connection due to: " + e));
        }
        this.markChannelAwaitingCloseOk(channelId);
        this.closeSession();
        this._stateManager.changeState(AMQState.CONNECTION_CLOSING);
        this.writeFrame(e.getCloseFrame(channelId));
        if (closeProtocolSession) {
            this.closeProtocolSession();
        }
    }

    public void closeProtocolSession() {
        this._networkDriver.close();
        try {
            this._stateManager.changeState(AMQState.CONNECTION_CLOSED);
        }
        catch (AMQException e) {
            _logger.info((Object)e.getMessage());
        }
    }

    public String toString() {
        return this.getRemoteAddress() + "(" + (this.getAuthorizedID() == null ? "?" : this.getAuthorizedID().getName() + ")");
    }

    public String dump() {
        return this + " last_sent=" + this._lastSent + " last_received=" + this._lastReceived;
    }

    @Override
    public Object getKey() {
        return this.getRemoteAddress();
    }

    @Override
    public String getLocalFQDN() {
        SocketAddress address = this._networkDriver.getLocalAddress();
        if (address instanceof InetSocketAddress) {
            return ((InetSocketAddress)address).getHostName();
        }
        if (address instanceof VmPipeAddress) {
            return "vmpipe:" + ((VmPipeAddress)address).getPort();
        }
        throw new IllegalArgumentException("Unsupported socket address class: " + address);
    }

    @Override
    public SaslServer getSaslServer() {
        return this._saslServer;
    }

    @Override
    public void setSaslServer(SaslServer saslServer) {
        this._saslServer = saslServer;
    }

    @Override
    public FieldTable getClientProperties() {
        return this._clientProperties;
    }

    @Override
    public void setClientProperties(FieldTable clientProperties) {
        this._clientProperties = clientProperties;
        if (this._clientProperties != null) {
            if (this._clientProperties.getString(CLIENT_PROPERTIES_INSTANCE) != null) {
                String clientID = this._clientProperties.getString(CLIENT_PROPERTIES_INSTANCE);
                this.setContextKey(new AMQShortString(clientID));
                this._actor.message(ConnectionMessages.OPEN(clientID, this._protocolVersion.toString(), true, true));
            }
            if (this._clientProperties.getString(ClientProperties.version.toString()) != null) {
                this._clientVersion = new AMQShortString(this._clientProperties.getString(ClientProperties.version.toString()));
            }
        }
        this._sessionIdentifier = new AMQProtocolSession.ProtocolSessionIdentifier(this);
    }

    private void setProtocolVersion(ProtocolVersion pv) {
        this._protocolVersion = pv;
        this._protocolOutputConverter = ProtocolOutputConverterRegistry.getConverter(this);
        this._dispatcher = ServerMethodDispatcherImpl.createMethodDispatcher(this._stateManager, this._protocolVersion);
    }

    @Override
    public byte getProtocolMajorVersion() {
        return this._protocolVersion.getMajorVersion();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this._protocolVersion;
    }

    @Override
    public byte getProtocolMinorVersion() {
        return this._protocolVersion.getMinorVersion();
    }

    public boolean isProtocolVersion(byte major, byte minor) {
        return this.getProtocolMajorVersion() == major && this.getProtocolMinorVersion() == minor;
    }

    public MethodRegistry getRegistry() {
        return this.getMethodRegistry();
    }

    @Override
    public Object getClientIdentifier() {
        return this._networkDriver != null ? this._networkDriver.getRemoteAddress() : null;
    }

    @Override
    public VirtualHost getVirtualHost() {
        return this._virtualHost;
    }

    @Override
    public void setVirtualHost(VirtualHost virtualHost) throws AMQException {
        this._virtualHost = virtualHost;
        this._virtualHost.getConnectionRegistry().registerConnection(this);
        this._configStore.addConfiguredObject(this);
        try {
            this._managedObject = this.createMBean();
            this._managedObject.register();
        }
        catch (JMException e) {
            _logger.error((Object)e);
        }
    }

    @Override
    public void addSessionCloseTask(AMQProtocolSession.Task task) {
        this._taskList.add(task);
    }

    @Override
    public void removeSessionCloseTask(AMQProtocolSession.Task task) {
        this._taskList.remove(task);
    }

    @Override
    public ProtocolOutputConverter getProtocolOutputConverter() {
        return this._protocolOutputConverter;
    }

    @Override
    public void setAuthorizedID(Principal authorizedID) {
        this._authorizedID = authorizedID;
    }

    public Principal getAuthorizedID() {
        return this._authorizedID;
    }

    @Override
    public Principal getPrincipal() {
        return this._authorizedID;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._networkDriver.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._networkDriver.getLocalAddress();
    }

    @Override
    public MethodRegistry getMethodRegistry() {
        return MethodRegistry.getMethodRegistry(this.getProtocolVersion());
    }

    @Override
    public MethodDispatcher getMethodDispatcher() {
        return this._dispatcher;
    }

    @Override
    public void closed() {
        try {
            this.closeSession();
        }
        catch (AMQException e) {
            _logger.error((Object)"Could not close protocol engine", (Throwable)e);
        }
    }

    @Override
    public void readerIdle() {
    }

    @Override
    public void setNetworkDriver(NetworkDriver driver) {
        this._networkDriver = driver;
    }

    @Override
    public void writerIdle() {
        this._networkDriver.send(HeartbeatBody.FRAME.toNioByteBuffer());
    }

    @Override
    public void exception(Throwable throwable) {
        if (throwable instanceof AMQProtocolHeaderException) {
            this.writeFrame(new ProtocolInitiation(ProtocolVersion.getLatestSupportedVersion()));
            this._networkDriver.close();
            _logger.error((Object)("Error in protocol initiation " + this + ":" + this.getRemoteAddress() + " :" + throwable.getMessage()), throwable);
        } else if (throwable instanceof IOException) {
            _logger.error((Object)("IOException caught in" + this + ", session closed implictly: " + throwable));
        } else {
            _logger.error((Object)("Exception caught in" + this + ", closing session explictly: " + throwable), throwable);
            MethodRegistry methodRegistry = MethodRegistry.getMethodRegistry(this.getProtocolVersion());
            ConnectionCloseBody closeBody = methodRegistry.createConnectionCloseBody(200, new AMQShortString(throwable.getMessage()), 0, 0);
            this.writeFrame(closeBody.generateFrame(0));
            this._networkDriver.close();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void setSender(Sender<ByteBuffer> sender) {
    }

    @Override
    public long getReadBytes() {
        return this._readBytes;
    }

    @Override
    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    @Override
    public long getLastIoTime() {
        return this._lastIoTime;
    }

    @Override
    public AMQProtocolSession.ProtocolSessionIdentifier getSessionIdentifier() {
        return this._sessionIdentifier;
    }

    @Override
    public String getClientVersion() {
        return this._clientVersion == null ? null : this._clientVersion.toString();
    }

    @Override
    public Boolean isIncoming() {
        return true;
    }

    @Override
    public Boolean isSystemConnection() {
        return false;
    }

    @Override
    public Boolean isFederationLink() {
        return false;
    }

    @Override
    public String getAuthId() {
        return this.getAuthorizedID().getName();
    }

    @Override
    public Integer getRemotePID() {
        return null;
    }

    @Override
    public String getRemoteProcessName() {
        return null;
    }

    @Override
    public Integer getRemoteParentPID() {
        return null;
    }

    @Override
    public ConfigStore getConfigStore() {
        return this._configStore;
    }

    @Override
    public ConnectionConfigType getConfigType() {
        return ConnectionConfigType.getInstance();
    }

    @Override
    public ConfiguredObject getParent() {
        return this.getVirtualHost();
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    @Override
    public long getConnectionId() {
        return this.getSessionID();
    }

    @Override
    public String getAddress() {
        return String.valueOf(this.getRemoteAddress());
    }

    @Override
    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public Boolean isShadow() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mgmtClose() {
        MethodRegistry methodRegistry = this.getMethodRegistry();
        ConnectionCloseBody responseBody = methodRegistry.createConnectionCloseBody(AMQConstant.REPLY_SUCCESS.getCode(), new AMQShortString("The connection was closed using the broker's management interface."), 0, 0);
        boolean removeActor = false;
        if (CurrentActor.get() == null) {
            removeActor = true;
            CurrentActor.set(new ManagementActor(this._actor.getRootMessageLogger()));
        }
        try {
            this.writeFrame(responseBody.generateFrame(0));
            try {
                this.closeSession();
            }
            catch (AMQException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (removeActor) {
                CurrentActor.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mgmtCloseChannel(int channelId) {
        MethodRegistry methodRegistry = this.getMethodRegistry();
        ChannelCloseBody responseBody = methodRegistry.createChannelCloseBody(AMQConstant.REPLY_SUCCESS.getCode(), new AMQShortString("The channel was closed using the broker's management interface."), 0, 0);
        boolean removeActor = false;
        if (CurrentActor.get() == null) {
            removeActor = true;
            CurrentActor.set(new ManagementActor(this._actor.getRootMessageLogger()));
        }
        try {
            this.writeFrame(responseBody.generateFrame(channelId));
            try {
                this.closeChannel(channelId);
            }
            catch (AMQException ex) {
                throw new RuntimeException(ex);
            }
        }
        finally {
            if (removeActor) {
                CurrentActor.remove();
            }
        }
    }

    public String getClientID() {
        return this.getContextKey().toString();
    }

    @Override
    public void closeSession(AMQSessionModel session, AMQConstant cause, String message) throws AMQException {
        this.closeChannel((Integer)session.getID());
        MethodRegistry methodRegistry = this.getMethodRegistry();
        ChannelCloseBody responseBody = methodRegistry.createChannelCloseBody(cause.getCode(), new AMQShortString(message), 0, 0);
        this.writeFrame(responseBody.generateFrame((Integer)session.getID()));
    }

    @Override
    public void close(AMQConstant cause, String message) throws AMQException {
        this.closeConnection(0, new AMQConnectionException(cause, message, 0, 0, this.getProtocolOutputConverter().getProtocolMajorVersion(), this.getProtocolOutputConverter().getProtocolMinorVersion(), null), true);
    }

    @Override
    public List<AMQSessionModel> getSessionModels() {
        ArrayList<AMQSessionModel> sessions = new ArrayList<AMQSessionModel>();
        for (AMQChannel channel : this.getChannels()) {
            sessions.add(channel);
        }
        return sessions;
    }

    @Override
    public LogSubject getLogSubject() {
        return this._logSubject;
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        if (this.isStatisticsEnabled()) {
            this._messagesDelivered.registerEvent(1L);
            this._dataDelivered.registerEvent(messageSize);
        }
        this._virtualHost.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        if (this.isStatisticsEnabled()) {
            this._messagesReceived.registerEvent(1L, timestamp);
            this._dataReceived.registerEvent(messageSize, timestamp);
        }
        this._virtualHost.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
    }

    @Override
    public void initialiseStatistics() {
        this.setStatisticsEnabled(!StatisticsCounter.DISABLE_STATISTICS && this._registry.getConfiguration().isStatisticsGenerationConnectionsEnabled());
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getSessionID());
        this._dataDelivered = new StatisticsCounter("data-delivered-" + this.getSessionID());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getSessionID());
        this._dataReceived = new StatisticsCounter("data-received-" + this.getSessionID());
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this._statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this._statisticsEnabled = enabled;
    }
}

