/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.framing.QueueDeleteBody;
import org.apache.qpid.framing.QueueDeleteOkBody;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.store.DurableConfigurationStore;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueDeleteHandler
implements StateAwareMethodListener<QueueDeleteBody> {
    private static final QueueDeleteHandler _instance = new QueueDeleteHandler();
    private final boolean _failIfNotFound;

    public static QueueDeleteHandler getInstance() {
        return _instance;
    }

    public QueueDeleteHandler() {
        this(true);
    }

    public QueueDeleteHandler(boolean failIfNotFound) {
        this._failIfNotFound = failIfNotFound;
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, QueueDeleteBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost virtualHost = protocolConnection.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        DurableConfigurationStore store = virtualHost.getDurableConfigurationStore();
        if (body.getQueue() == null) {
            AMQChannel channel = protocolConnection.getChannel(channelId);
            if (channel == null) {
                throw body.getChannelNotFoundException(channelId);
            }
            queue = channel.getDefaultQueue();
        } else {
            queue = queueRegistry.getQueue(body.getQueue());
        }
        if (queue == null) {
            if (this._failIfNotFound) {
                throw body.getChannelException(AMQConstant.NOT_FOUND, "Queue " + body.getQueue() + " does not exist.");
            }
        } else {
            if (body.getIfEmpty() && !queue.isEmpty()) {
                throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is not empty.");
            }
            if (body.getIfUnused() && !queue.isUnused()) {
                throw body.getChannelException(AMQConstant.IN_USE, "Queue: " + body.getQueue() + " is still used.");
            }
            AMQSessionModel session = queue.getExclusiveOwningSession();
            if (queue.isExclusive() && !queue.isDurable() && (session == null || session.getConnectionModel() != protocolConnection)) {
                throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue " + queue.getNameShortString() + " is exclusive, but not created on this Connection.");
            }
            int purged = queue.delete();
            if (queue.isDurable()) {
                store.removeQueue(queue);
            }
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            QueueDeleteOkBody responseBody = methodRegistry.createQueueDeleteOkBody(purged);
            protocolConnection.writeFrame(responseBody.generateFrame(channelId));
        }
    }
}

