/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MessageConsumeBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageConsumeBodyImpl
extends AMQMethodBody_0_9
implements MessageConsumeBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new MessageConsumeBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 20;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _destination;
    private final byte _bitfield0;
    private final FieldTable _filter;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageConsumeBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._destination = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._filter = this.readFieldTable(buffer);
    }

    public MessageConsumeBodyImpl(int ticket, AMQShortString queue, AMQShortString destination, boolean noLocal, boolean noAck, boolean exclusive, FieldTable filter) {
        this._ticket = ticket;
        this._queue = queue;
        this._destination = destination;
        byte bitfield0 = 0;
        if (noLocal) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (noAck) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        if (exclusive) {
            bitfield0 = (byte)(bitfield0 | 4);
        }
        this._bitfield0 = bitfield0;
        this._filter = filter;
    }

    public int getClazz() {
        return 120;
    }

    public int getMethod() {
        return 20;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final AMQShortString getDestination() {
        return this._destination;
    }

    public final boolean getNoLocal() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getNoAck() {
        return (this._bitfield0 & 2) != 0;
    }

    public final boolean getExclusive() {
        return (this._bitfield0 & 4) != 0;
    }

    public final FieldTable getFilter() {
        return this._filter;
    }

    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._queue);
        size += this.getSizeOf(this._destination);
        return size += this.getSizeOf(this._filter);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._destination);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeFieldTable(buffer, this._filter);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageConsume(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageConsumeBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("destination=");
        buf.append(this.getDestination());
        buf.append(", ");
        buf.append("noLocal=");
        buf.append(this.getNoLocal());
        buf.append(", ");
        buf.append("noAck=");
        buf.append(this.getNoAck());
        buf.append(", ");
        buf.append("exclusive=");
        buf.append(this.getExclusive());
        buf.append(", ");
        buf.append("filter=");
        buf.append(this.getFilter());
        buf.append("]");
        return buf.toString();
    }
}

