/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.UUID;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionURL;
import org.apache.qpid.client.AMQQueue;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.SSLConfiguration;
import org.apache.qpid.client.XAConnectionImpl;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.url.AMQBindingURL;
import org.apache.qpid.url.URLSyntaxException;

public class AMQConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
ObjectFactory,
Referenceable,
XATopicConnectionFactory,
XAQueueConnectionFactory,
XAConnectionFactory {
    private String _host;
    private int _port;
    private String _defaultUsername;
    private String _defaultPassword;
    private String _virtualPath;
    private ConnectionURL _connectionDetails;
    private SSLConfiguration _sslConfig;

    public AMQConnectionFactory() {
    }

    public AMQConnectionFactory(String url) throws URLSyntaxException {
        this._connectionDetails = new AMQConnectionURL(url);
    }

    public AMQConnectionFactory(ConnectionURL url) {
        this._connectionDetails = url;
    }

    public AMQConnectionFactory(String broker, String username, String password, String clientName, String virtualHost) throws URLSyntaxException {
        this(new AMQConnectionURL("amqp://" + username + ":" + password + "@" + clientName + "/" + virtualHost + "?brokerlist='" + broker + "'"));
    }

    public AMQConnectionFactory(String host, int port, String virtualPath) {
        this(host, port, "guest", "guest", virtualPath);
    }

    public AMQConnectionFactory(String host, int port, String defaultUsername, String defaultPassword, String virtualPath) {
        this._host = host;
        this._port = port;
        this._defaultUsername = defaultUsername;
        this._defaultPassword = defaultPassword;
        this._virtualPath = virtualPath;
    }

    public final String getDefaultPassword(String password) {
        if (this._connectionDetails != null) {
            return this._connectionDetails.getPassword();
        }
        return this._defaultPassword;
    }

    public final void setDefaultPassword(String password) {
        if (this._connectionDetails != null) {
            this._connectionDetails.setPassword(password);
        }
        this._defaultPassword = password;
    }

    public final SSLConfiguration getSSLConfiguration() {
        return this._sslConfig;
    }

    public final void setSSLConfiguration(SSLConfiguration sslConfig) {
        this._sslConfig = sslConfig;
    }

    public final String getDefaultUsername(String password) {
        if (this._connectionDetails != null) {
            return this._connectionDetails.getUsername();
        }
        return this._defaultUsername;
    }

    public final void setDefaultUsername(String username) {
        if (this._connectionDetails != null) {
            this._connectionDetails.setUsername(username);
        }
        this._defaultUsername = username;
    }

    public final String getHost() {
        return this._host;
    }

    public final void setHost(String host) {
        this._host = host;
    }

    public final int getPort() {
        return this._port;
    }

    public final void setPort(int port) {
        this._port = port;
    }

    public final String getVirtualPath() {
        if (this._connectionDetails != null) {
            return this._connectionDetails.getVirtualHost();
        }
        return this._virtualPath;
    }

    public final void setVirtualPath(String path) {
        if (this._connectionDetails != null) {
            this._connectionDetails.setVirtualHost(path);
        }
        this._virtualPath = path;
    }

    public static String getUniqueClientID() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName() + System.currentTimeMillis();
        }
        catch (UnknownHostException e) {
            return "UnknownHost" + UUID.randomUUID();
        }
    }

    public Connection createConnection() throws JMSException {
        try {
            if (this._connectionDetails != null) {
                if (this._connectionDetails.getClientName() == null || this._connectionDetails.getClientName().equals("")) {
                    this._connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
                }
                return new AMQConnection(this._connectionDetails, this._sslConfig);
            }
            return new AMQConnection(this._host, this._port, this._defaultUsername, this._defaultPassword, AMQConnectionFactory.getUniqueClientID(), this._virtualPath);
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password, null);
    }

    public Connection createConnection(String userName, String password, String id) throws JMSException {
        try {
            if (this._connectionDetails != null) {
                this._connectionDetails.setUsername(userName);
                this._connectionDetails.setPassword(password);
                if (id != null && !id.equals("")) {
                    this._connectionDetails.setClientName(id);
                } else if (this._connectionDetails.getClientName() == null || this._connectionDetails.getClientName().equals("")) {
                    this._connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
                }
                return new AMQConnection(this._connectionDetails, this._sslConfig);
            }
            return new AMQConnection(this._host, this._port, userName, password, id != null ? id : AMQConnectionFactory.getUniqueClientID(), this._virtualPath);
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return (QueueConnection)this.createConnection();
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return (QueueConnection)this.createConnection(username, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return (TopicConnection)this.createConnection();
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return (TopicConnection)this.createConnection(username, password);
    }

    public ConnectionURL getConnectionURL() {
        return this._connectionDetails;
    }

    public String getConnectionURLString() {
        return this._connectionDetails.toString();
    }

    public final void setConnectionURLString(String url) throws URLSyntaxException {
        this._connectionDetails = new AMQConnectionURL(url);
    }

    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        if (obj instanceof Reference) {
            RefAddr addr;
            Reference ref = (Reference)obj;
            if (ref.getClassName().equals(AMQConnection.class.getName()) && (addr = ref.get(AMQConnection.class.getName())) != null) {
                return new AMQConnection((String)addr.getContent());
            }
            if (ref.getClassName().equals(AMQQueue.class.getName()) && (addr = ref.get(AMQQueue.class.getName())) != null) {
                return new AMQQueue(new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQTopic.class.getName()) && (addr = ref.get(AMQTopic.class.getName())) != null) {
                return new AMQTopic(new AMQBindingURL((String)addr.getContent()));
            }
            if (ref.getClassName().equals(AMQConnectionFactory.class.getName()) && (addr = ref.get(AMQConnectionFactory.class.getName())) != null) {
                return new AMQConnectionFactory((String)addr.getContent());
            }
        }
        return null;
    }

    public Reference getReference() throws NamingException {
        return new Reference(AMQConnectionFactory.class.getName(), new StringRefAddr(AMQConnectionFactory.class.getName(), this._connectionDetails.getURL()), AMQConnectionFactory.class.getName(), null);
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            return new XAConnectionImpl(this._connectionDetails, this._sslConfig);
        }
        catch (Exception e) {
            JMSException jmse = new JMSException("Error creating connection: " + e.getMessage());
            jmse.setLinkedException(e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        if (this._connectionDetails != null) {
            this._connectionDetails.setUsername(username);
            this._connectionDetails.setPassword(password);
            if (this._connectionDetails.getClientName() == null || this._connectionDetails.getClientName().equals("")) {
                this._connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
            }
        } else {
            throw new JMSException("A URL must be specified to access XA connections");
        }
        return this.createXAConnection();
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createXAConnection();
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return (XATopicConnection)this.createXAConnection(username, password);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createXAConnection();
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return (XAQueueConnection)this.createXAConnection(username, password);
    }
}

