/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.qpid.authorization.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.qpid.server.configuration.plugins.ConfigurationPluginFactory;
import org.apache.qpid.server.security.SecurityPluginFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.qpid.authorization.internal.AuthorizationServiceDataHolder;
import org.wso2.carbon.qpid.authorization.service.qpid.QpidAuthorizationPlugin;
import org.wso2.carbon.qpid.authorization.service.qpid.QpidAuthorizationPluginConfiguration;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

public class AuthorizationServiceComponent {
    private static final Log log = LogFactory.getLog(AuthorizationServiceComponent.class);
    private ServiceRegistration securityPluginFactory = null;
    private ServiceRegistration configurationPluginFactory = null;

    protected void activate(ComponentContext ctx) {
        try {
            this.securityPluginFactory = ctx.getBundleContext().registerService(SecurityPluginFactory.class.getName(), QpidAuthorizationPlugin.FACTORY, null);
            this.configurationPluginFactory = ctx.getBundleContext().registerService(ConfigurationPluginFactory.class.getName(), (Object)QpidAuthorizationPluginConfiguration.FACTORY, null);
        }
        catch (Throwable e) {
            log.error((Object)("Failed to activate org.wso2.carbon.qpid.authorization.internal.AuthorizationServiceComponent : " + e));
        }
    }

    protected void deactivate(ComponentContext ctx) {
        if (null != this.securityPluginFactory) {
            this.securityPluginFactory.unregister();
        }
        if (null != this.configurationPluginFactory) {
            this.configurationPluginFactory.unregister();
        }
    }

    protected void setRegistryService(RegistryService registryService) {
        AuthorizationServiceDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        AuthorizationServiceDataHolder.getInstance().setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        AuthorizationServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        AuthorizationServiceDataHolder.getInstance().setRealmService(null);
    }
}

