/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin;

import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.utils.multitenancy.CarbonContextHolder;

public class ProxyServiceDeployer
extends org.apache.synapse.deployers.ProxyServiceDeployer {
    MediationPersistenceManager mpm;

    public void init(ConfigurationContext configCtx) {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
        super.init(configCtx);
        this.mpm = ServiceBusUtils.getMediationPersistenceManager((AxisConfiguration)configCtx.getAxisConfiguration());
    }

    public String deploySynapseArtifact(OMElement artifactConfig, String fileName, Properties properties) {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
        String proxyName = super.deploySynapseArtifact(artifactConfig, fileName, properties);
        this.mpm.saveItemToRegistry(proxyName, 0);
        return proxyName;
    }

    public String updateSynapseArtifact(OMElement artifactConfig, String fileName, String existingArtifactName, Properties properties) {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
        String proxyName = super.updateSynapseArtifact(artifactConfig, fileName, existingArtifactName, properties);
        this.mpm.saveItemToRegistry(proxyName, 0);
        return proxyName;
    }

    public void undeploySynapseArtifact(String artifactName) {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
        super.undeploySynapseArtifact(artifactName);
        this.mpm.deleteItemFromRegistry(artifactName, 0);
    }

    public void restoreSynapseArtifact(String artifactName) {
        int tenantId = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        CarbonContextHolder.getThreadLocalCarbonContextHolder().setTenantId(tenantId);
        super.restoreSynapseArtifact(artifactName);
        this.mpm.saveItemToRegistry(artifactName, 0);
    }
}

