/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin.observer;

import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.axis2.ProxyService;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.proxyadmin.util.ConfigHolder;

public class ProxyServiceParameterObserver
implements ParameterObserver {
    private AxisService service;
    private int tanentId;
    private static final Log log = LogFactory.getLog(ProxyServiceParameterObserver.class);

    public ProxyServiceParameterObserver(AxisService service) {
        this.service = service;
        this.tanentId = SuperTenantCarbonContext.getCurrentContext((AxisService)service).getTenantId();
    }

    public void parameterChanged(String name, Object value) {
        SynapseConfiguration config = ConfigHolder.getInstance().getSynapseEnvironmentService(this.tanentId).getSynapseEnvironment().getSynapseConfiguration();
        ProxyService proxy = config.getProxyService(this.service.getName());
        if (proxy != null) {
            if (this.service.getParameter(name) != null) {
                proxy.addParameter(name, value);
            } else {
                proxy.getParameterMap().remove(name);
            }
        } else {
            log.error((Object)("Proxy Service " + name + " does not exist "));
        }
    }
}

