/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseConstants;
import org.wso2.carbon.proxyadmin.Entry;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.proxyadmin.ProxyServicePolicyInfo;

public class ProxyData {
    private static Log log = LogFactory.getLog(ProxyData.class);
    private String name;
    private boolean running;
    private boolean enableStatistics;
    private boolean enableTracing;
    private boolean wsdlAvailable;
    private String[] transports;
    private String[] pinnedServers;
    private String endpointKey;
    private String endpointXML;
    private String inSeqKey;
    private String inSeqXML;
    private String outSeqKey;
    private String outSeqXML;
    private String faultSeqKey;
    private String faultSeqXML;
    private String wsdlKey;
    private String wsdlURI;
    private String wsdlDef;
    private Entry[] wsdlResources;
    private boolean publishWSDL;
    private boolean startOnLoad = true;
    Entry[] serviceParams;
    private boolean enableSecurity;
    private ProxyServicePolicyInfo[] policies;
    private String serviceGroup;
    private String description;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isWsdlAvailable() {
        return this.wsdlAvailable;
    }

    public void setWsdlAvailable(boolean wsdlAvailable) {
        this.wsdlAvailable = wsdlAvailable;
    }

    public boolean isEnableTracing() {
        return this.enableTracing;
    }

    public void setEnableTracing(boolean enableTracing) {
        this.enableTracing = enableTracing;
    }

    public boolean isEnableStatistics() {
        return this.enableStatistics;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this.enableStatistics = enableStatistics;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTransports(String[] transports) {
        this.transports = transports;
    }

    public String[] getTransports() {
        return this.transports;
    }

    public String[] getPinnedServers() {
        return this.pinnedServers;
    }

    public void setPinnedServers(String[] pinnedServers) {
        this.pinnedServers = pinnedServers;
    }

    public String getEndpointKey() {
        return this.endpointKey;
    }

    public void setEndpointKey(String endpointKey) {
        this.endpointKey = endpointKey;
    }

    public String getEndpointXML() {
        return this.endpointXML;
    }

    public void setEndpointXML(String endpointXML) {
        this.endpointXML = endpointXML;
    }

    public String getInSeqKey() {
        return this.inSeqKey;
    }

    public void setInSeqKey(String inSeqKey) {
        this.inSeqKey = inSeqKey;
    }

    public String getInSeqXML() {
        return this.inSeqXML;
    }

    public void setInSeqXML(String inSeqXML) {
        this.inSeqXML = inSeqXML;
    }

    public String getOutSeqKey() {
        return this.outSeqKey;
    }

    public void setOutSeqKey(String outSeqtKey) {
        this.outSeqKey = outSeqtKey;
    }

    public String getOutSeqXML() {
        return this.outSeqXML;
    }

    public void setOutSeqXML(String outSeqXML) {
        this.outSeqXML = outSeqXML;
    }

    public String getFaultSeqKey() {
        return this.faultSeqKey;
    }

    public void setFaultSeqKey(String faultSeqKey) {
        this.faultSeqKey = faultSeqKey;
    }

    public String getFaultSeqXML() {
        return this.faultSeqXML;
    }

    public void setFaultSeqXML(String faultSeqXML) {
        this.faultSeqXML = faultSeqXML;
    }

    public String getWsdlKey() {
        return this.wsdlKey;
    }

    public void setWsdlKey(String wsdlKey) {
        this.wsdlKey = wsdlKey;
    }

    public String getWsdlURI() {
        return this.wsdlURI;
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public Entry[] getWsdlResources() {
        return this.wsdlResources;
    }

    public void setWsdlResources(Entry[] wsdlResources) {
        this.wsdlResources = wsdlResources;
    }

    public Entry[] getServiceParams() {
        return this.serviceParams;
    }

    public void setServiceParams(Entry[] serviceParams) {
        this.serviceParams = serviceParams;
    }

    public String getWsdlDef() {
        return this.wsdlDef;
    }

    public void setWsdlDef(String wsdlDef) {
        this.wsdlDef = wsdlDef;
    }

    public boolean isStartOnLoad() {
        return this.startOnLoad;
    }

    public void setStartOnLoad(boolean startOnLoad) {
        this.startOnLoad = startOnLoad;
    }

    public ProxyServicePolicyInfo[] getPolicies() {
        return this.policies;
    }

    public void setPolicies(ProxyServicePolicyInfo[] policies) {
        this.policies = policies;
    }

    public boolean isEnableSecurity() {
        return this.enableSecurity;
    }

    public void setEnableSecurity(boolean enableSecurity) {
        this.enableSecurity = enableSecurity;
    }

    public String getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
    }

    public OMElement retrieveOM() throws ProxyAdminException {
        int i;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace syn = SynapseConstants.SYNAPSE_OMNAMESPACE;
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement proxy = fac.createOMElement("proxy", syn);
        proxy.addAttribute("name", this.name, nullNS);
        if (this.transports != null) {
            proxy.addAttribute("transports", this.createCSString(this.transports), nullNS);
        }
        if (this.pinnedServers != null) {
            proxy.addAttribute("pinnedServers", this.createCSString(this.pinnedServers), nullNS);
        }
        if (this.serviceGroup != null) {
            proxy.addAttribute("serviceGroup", this.serviceGroup, nullNS);
        }
        if (this.enableStatistics) {
            proxy.addAttribute("statistics", "enable", nullNS);
        } else {
            proxy.addAttribute("statistics", "disable", nullNS);
        }
        if (this.enableTracing) {
            proxy.addAttribute("trace", "enable", nullNS);
        } else {
            proxy.addAttribute("trace", "disable", nullNS);
        }
        if (this.startOnLoad) {
            proxy.addAttribute("startOnLoad", "true", nullNS);
        } else {
            proxy.addAttribute("startOnLoad", "false", nullNS);
        }
        OMElement element = fac.createOMElement("target", syn);
        if (this.inSeqKey != null) {
            element.addAttribute("inSequence", this.inSeqKey, nullNS);
        } else if (this.inSeqXML != null) {
            try {
                element.addChild((OMNode)this.createElement(this.inSeqXML));
            }
            catch (XMLStreamException e) {
                String msg = "Unable to build the \"inSequence\" element";
                log.error((Object)(msg + e.getMessage()));
                throw new ProxyAdminException(msg, e);
            }
        }
        if (this.outSeqKey != null) {
            element.addAttribute("outSequence", this.outSeqKey, nullNS);
        } else if (this.outSeqXML != null) {
            try {
                element.addChild((OMNode)this.createElement(this.outSeqXML));
            }
            catch (XMLStreamException e) {
                String msg = "Unable to build the \"outSequence\" element";
                log.error((Object)(msg + e.getMessage()));
                throw new ProxyAdminException(msg, e);
            }
        }
        if (this.faultSeqKey != null) {
            element.addAttribute("faultSequence", this.faultSeqKey, nullNS);
        } else if (this.faultSeqXML != null) {
            try {
                element.addChild((OMNode)this.createElement(this.faultSeqXML));
            }
            catch (XMLStreamException e) {
                String msg = "Unable to build the \"faultSequence\" element";
                log.error((Object)(msg + e.getMessage()));
                throw new ProxyAdminException(msg, e);
            }
        }
        if (this.endpointKey != null) {
            element.addAttribute("endpoint", this.endpointKey, nullNS);
        } else if (this.endpointXML != null && !"".equals(this.endpointXML)) {
            try {
                element.addChild((OMNode)this.createElement(this.endpointXML));
            }
            catch (XMLStreamException e) {
                String msg = "Unable to build the \"endpoint\" element";
                log.error((Object)(msg + e.getMessage()));
                throw new ProxyAdminException(msg, e);
            }
        }
        proxy.addChild((OMNode)element);
        element = fac.createOMElement("publishWSDL", syn);
        if (this.wsdlKey != null) {
            this.publishWSDL = true;
            element.addAttribute("key", this.wsdlKey, nullNS);
        } else if (this.wsdlURI != null) {
            this.publishWSDL = true;
            element.addAttribute("uri", this.wsdlURI, nullNS);
        } else if (this.wsdlDef != null) {
            this.publishWSDL = true;
            try {
                element.addChild((OMNode)this.createElement(this.wsdlDef));
            }
            catch (XMLStreamException e) {
                String msg = "Unable to build the in line WSDL definition";
                log.error((Object)(msg + e.getMessage()));
                throw new ProxyAdminException(msg, e);
            }
        }
        if (this.publishWSDL) {
            if (this.wsdlResources != null && this.wsdlResources.length != 0) {
                for (i = 0; i < this.wsdlResources.length; ++i) {
                    Entry wsdlResource = this.wsdlResources[i];
                    OMElement resource = fac.createOMElement("resource", syn);
                    resource.addAttribute("location", wsdlResource.getKey(), nullNS);
                    resource.addAttribute("key", wsdlResource.getValue(), nullNS);
                    element.addChild((OMNode)resource);
                }
            }
            proxy.addChild((OMNode)element);
        }
        if (this.serviceParams != null && this.serviceParams.length != 0) {
            for (i = 0; i < this.serviceParams.length; ++i) {
                Entry serviceParam = this.serviceParams[i];
                element = fac.createOMElement("parameter", syn);
                element.addAttribute("name", serviceParam.getKey(), nullNS);
                String value = serviceParam.getValue();
                if (value.startsWith("<")) {
                    try {
                        byte[] bytes = null;
                        try {
                            bytes = value.getBytes("UTF8");
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error((Object)("Unable to extract bytes in UTF-8 encoding. Extracting bytes in the system default encoding" + e.getMessage()));
                            bytes = value.getBytes();
                        }
                        element.addChild((OMNode)new StAXOMBuilder((InputStream)new ByteArrayInputStream(bytes)).getDocumentElement());
                    }
                    catch (XMLStreamException e) {
                        String msg = "Service parameter: " + serviceParam.getKey() + " has an invalid XML as its value";
                        log.error((Object)msg);
                        throw new ProxyAdminException(msg, e);
                    }
                }
                element.setText(value);
                proxy.addChild((OMNode)element);
            }
        }
        if (this.enableSecurity) {
            element = fac.createOMElement("enableSec", syn);
            proxy.addChild((OMNode)element);
        }
        if (this.policies != null) {
            for (ProxyServicePolicyInfo policy : this.policies) {
                proxy.addChild((OMNode)policy.toOM(fac, syn, nullNS));
            }
        }
        if (this.description != null) {
            element = fac.createOMElement("description", syn);
            element.setText(this.description);
            proxy.addChild((OMNode)element);
        }
        return proxy;
    }

    private String createCSString(String[] lst) {
        String str = "";
        for (String item : lst) {
            str = str + item + ",";
        }
        return str.substring(0, str.length() - 1);
    }

    private OMElement createElement(String str) throws XMLStreamException {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Unable to extract bytes in UTF-8 encoding. Extracting bytes in the system default encoding" + e.getMessage()));
            bytes = str.getBytes();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }
}

