/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.proxyadmin;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.proxyadmin.ProxyAdminException;
import org.wso2.carbon.proxyadmin.ProxyServiceDeployer;
import org.wso2.carbon.proxyadmin.observer.ProxyObserver;
import org.wso2.carbon.proxyadmin.util.ConfigHolder;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.service.mgt.ServiceAdmin;

public class ProxyAdminServiceComponent {
    private static final Log log = LogFactory.getLog(ProxyAdminServiceComponent.class);
    private boolean initialized = false;

    protected void activate(ComponentContext context) {
        try {
            this.initialized = true;
            SynapseEnvironmentService synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(-1234);
            if (synEnvService != null) {
                AxisConfiguration axisConf = synEnvService.getConfigurationContext().getAxisConfiguration();
                try {
                    ProxyObserver proxyObserver = new ProxyObserver(synEnvService, (Registry)ConfigHolder.getInstance().getRegistryService().getConfigSystemRegistry());
                    ConfigHolder.getInstance().addProxyObserver(-1234, proxyObserver);
                    axisConf.addObservers((AxisObserver)proxyObserver);
                    this.registerDeployer(synEnvService.getConfigurationContext().getAxisConfiguration(), synEnvService.getSynapseEnvironment());
                    proxyObserver.setSynapseEnvironmentService(synEnvService);
                }
                catch (ProxyAdminException e) {
                    log.error((Object)"Error while initializing the proxy service observer. Proxy admin component may be unstable.", (Throwable)e);
                }
            } else {
                log.warn((Object)"Cannot register the proxy service observer. The axis service representing the proxy service might not be in sync with the proxy");
            }
        }
        catch (Throwable t) {
            log.fatal((Object)"Error occurred while activating the Proxy Admin", t);
        }
    }

    private void registerDeployer(AxisConfiguration axisConfig, SynapseEnvironment synEnv) throws ProxyAdminException {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synEnv.getSynapseConfiguration().getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synEnv.getServerContextInformation());
        String proxyDirPath = synapseConfigPath + File.separator + "proxy-services";
        for (ProxyService proxyService : synEnv.getSynapseConfiguration().getProxyServices()) {
            if (proxyService.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(proxyDirPath + File.separator + proxyService.getFileName());
        }
        deploymentEngine.addDeployer((Deployer)new ProxyServiceDeployer(), proxyDirPath, "xml");
    }

    protected void deactivate(ComponentContext context) {
        Set<Map.Entry<Integer, SynapseEnvironmentService>> entrySet = ConfigHolder.getInstance().getSynapseEnvironmentServices().entrySet();
        for (Map.Entry<Integer, SynapseEnvironmentService> entry : entrySet) {
            this.unregistryDeployer(entry.getValue().getConfigurationContext().getAxisConfiguration(), entry.getValue().getSynapseEnvironment());
        }
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        boolean alreadyCreated = ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(synapseEnvironmentService.getTenantId());
        ConfigHolder.getInstance().addSynapseEnvironmentService(synapseEnvironmentService.getTenantId(), synapseEnvironmentService);
        if (this.initialized) {
            int tenantId = synapseEnvironmentService.getTenantId();
            AxisConfiguration axisConfiguration = synapseEnvironmentService.getConfigurationContext().getAxisConfiguration();
            if (!alreadyCreated) {
                try {
                    this.registerDeployer(synapseEnvironmentService.getConfigurationContext().getAxisConfiguration(), synapseEnvironmentService.getSynapseEnvironment());
                    ProxyObserver observer = new ProxyObserver(synapseEnvironmentService, (Registry)ConfigHolder.getInstance().getRegistryService().getConfigSystemRegistry(tenantId));
                    axisConfiguration.addObservers((AxisObserver)observer);
                    ConfigHolder.getInstance().addProxyObserver(tenantId, observer);
                }
                catch (ProxyAdminException e) {
                    log.error((Object)"Error while initializing the proxy admin.", (Throwable)e);
                }
                catch (RegistryException e) {
                    log.error((Object)"Error while initializing the proxy admin.", (Throwable)e);
                }
            } else {
                ProxyObserver observer = ConfigHolder.getInstance().getProxyObsever(tenantId);
                if (observer != null) {
                    observer.setSynapseEnvironmentService(synapseEnvironmentService);
                }
            }
        }
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseEnvironmentService.getTenantId());
    }

    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        int tenantId = synapseRegistrationsService.getTenantId();
        if (ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(tenantId)) {
            SynapseEnvironment env = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId).getSynapseEnvironment();
            ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseRegistrationsService.getTenantId());
            AxisConfiguration axisConfig = synapseRegistrationsService.getConfigurationContext().getAxisConfiguration();
            if (axisConfig != null) {
                this.unregistryDeployer(axisConfig, env);
            }
        }
    }

    private void unregistryDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
        String proxyDirPath = synapseConfigPath + File.separator + "proxy-services";
        deploymentEngine.removeDeployer(proxyDirPath, "xml");
    }

    protected void setServiceadminService(ServiceAdmin serviceAdmin) {
    }

    protected void unsetServiceAdminService(ServiceAdmin serviceAdmin) {
    }

    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        ConfigHolder.getInstance().setRegistryService(regService);
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setRegistryService(null);
    }
}

