/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.profiles.mgt.ui.client;

import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.profiles.mgt.stub.ProfileAdminServiceStub;
import org.wso2.carbon.profiles.mgt.stub.dto.AvailableProfileConfigurationDTO;
import org.wso2.carbon.profiles.mgt.stub.dto.ClaimConfigurationDTO;
import org.wso2.carbon.profiles.mgt.stub.dto.DetailedProfileConfigurationDTO;

public class ProfileMgtClient {
    private ProfileAdminServiceStub stub = null;
    private String serviceEndPoint = null;
    private static Log log = LogFactory.getLog(ProfileMgtClient.class);

    public ProfileMgtClient(String cookie, String url, ConfigurationContext configContext) throws Exception {
        try {
            this.serviceEndPoint = url + "ProfileAdminService";
            this.stub = new ProfileAdminServiceStub(configContext, this.serviceEndPoint);
            ServiceClient client = this.stub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public AvailableProfileConfigurationDTO getAllAvailableProfileConfiguraions() throws Exception {
        try {
            return this.stub.getAllAvailableProfileConfiguraions();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public DetailedProfileConfigurationDTO getAllAvailableProfileConfiguraionsForDialect(String dialect) throws Exception {
        try {
            return this.stub.getAllAvailableProfileConfiguraionsForDialect(dialect);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public void updateClaimMappingBehavior(String profileName, ClaimConfigurationDTO[] claimConfiguration) throws Exception {
        try {
            this.stub.updateClaimMappingBehavior(profileName, claimConfiguration);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public ClaimConfigurationDTO[] getProfileConfiguration(String dialect, String profile) throws Exception {
        try {
            return this.stub.getProfileConfiguration(dialect, profile);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public ClaimConfigurationDTO[] getClaimMappings(String dialect) throws Exception {
        try {
            return this.stub.getClaimConfigurations(dialect);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public void addProfile(String profileName, String dialect, ClaimConfigurationDTO[] claimConfiguration) throws Exception {
        try {
            this.stub.addProfile(profileName, dialect, claimConfiguration);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public void deleteProfileConfiguraiton(String dialect, String profileName) throws Exception {
        try {
            this.stub.deleteProfileConfiguraiton(dialect, profileName);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }

    public boolean isAddProfileEnabled() throws Exception {
        try {
            return this.stub.isAddProfileEnabled();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw e;
        }
    }
}

