/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.profiles.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.profiles.mgt.ProfileManagementException;
import org.wso2.carbon.profiles.mgt.dto.AvailableProfileConfigurationDTO;
import org.wso2.carbon.profiles.mgt.dto.ClaimConfigurationDTO;
import org.wso2.carbon.profiles.mgt.dto.DetailedProfileConfigurationDTO;
import org.wso2.carbon.profiles.mgt.dto.DialectDTO;
import org.wso2.carbon.profiles.mgt.dto.ProfileConfigurationDTO;
import org.wso2.carbon.user.api.ProfileConfiguration;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.profile.ProfileConfigurationManager;

public class ProfileMgtAdmin {
    private static final Log log = LogFactory.getLog(ProfileMgtAdmin.class);

    public AvailableProfileConfigurationDTO getAllAvailableProfileConfiguraionsForUserStore(String userStore) throws ProfileManagementException {
        AvailableProfileConfigurationDTO availableConfiguration = null;
        this.validateInputParameters(new String[]{userStore});
        try {
            availableConfiguration = new AvailableProfileConfigurationDTO();
            availableConfiguration.setDialects(this.getDialectsForUserStore());
            return availableConfiguration;
        }
        catch (Exception e) {
            log.error((Object)("Error while loading available profile configurations for user store " + userStore), (Throwable)e);
            throw new ProfileManagementException("Error while loading available profile configurations for user store " + userStore, e);
        }
    }

    public AvailableProfileConfigurationDTO getAllAvailableProfileConfiguraions() throws ProfileManagementException {
        AvailableProfileConfigurationDTO availableConfiguration = null;
        try {
            availableConfiguration = new AvailableProfileConfigurationDTO();
            availableConfiguration.setDialects(this.getDialects());
            return availableConfiguration;
        }
        catch (Exception e) {
            log.error((Object)"Error while loading available profile configurations", (Throwable)e);
            throw new ProfileManagementException("Error while loading available profile configurations", e);
        }
    }

    public DetailedProfileConfigurationDTO getAllAvailableProfileConfiguraionsForDialect(String dialect) throws ProfileManagementException {
        UserRealm realm = null;
        ProfileConfigurationManager profileManager = null;
        org.wso2.carbon.user.core.profile.ProfileConfiguration[] profileConfigs = null;
        Object iterator = null;
        DetailedProfileConfigurationDTO detailedConfiguration = null;
        ArrayList<ProfileConfigurationDTO> configurations = null;
        this.validateInputParameters(new String[]{dialect});
        try {
            realm = this.getRealm();
            profileManager = realm.getProfileConfigurationManager();
            if (profileManager == null) {
                String message = "No profile configurations defined ";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                return null;
            }
            detailedConfiguration = new DetailedProfileConfigurationDTO();
            profileConfigs = (org.wso2.carbon.user.core.profile.ProfileConfiguration[])profileManager.getAllProfiles();
            detailedConfiguration.setDialect(dialect);
            configurations = new ArrayList<ProfileConfigurationDTO>();
            for (org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig : profileConfigs) {
                if (!profileConfig.getDialectName().equals(dialect)) continue;
                ProfileConfigurationDTO profile = null;
                ClaimConfigurationDTO claim = null;
                ArrayList<ClaimConfigurationDTO> claimList = null;
                List hiddenClaims = null;
                List overriddenClaims = null;
                List inheritedClaims = null;
                claimList = new ArrayList<ClaimConfigurationDTO>();
                hiddenClaims = profileConfig.getHiddenClaims();
                if (hiddenClaims != null) {
                    for (String string : hiddenClaims) {
                        claim = new ClaimConfigurationDTO();
                        claim.setClaimUri(string);
                        claim.setBehavior("Hidden");
                        claimList.add(claim);
                    }
                }
                if ((overriddenClaims = profileConfig.getOverriddenClaims()) != null) {
                    for (String string : overriddenClaims) {
                        claim = new ClaimConfigurationDTO();
                        claim.setClaimUri(string);
                        claim.setBehavior("Overridden");
                        claimList.add(claim);
                    }
                }
                if ((inheritedClaims = profileConfig.getInheritedClaims()) != null) {
                    for (String string : inheritedClaims) {
                        claim = new ClaimConfigurationDTO();
                        claim.setClaimUri(string);
                        claim.setBehavior("Inherited");
                        claimList.add(claim);
                    }
                }
                profile = new ProfileConfigurationDTO();
                profile.setConfigurationName(profileConfig.getProfileName());
                profile.setClaimConfiguration(claimList.toArray(new ClaimConfigurationDTO[claimList.size()]));
                configurations.add(profile);
            }
            detailedConfiguration.setProfileConfiguartions(configurations.toArray(new ProfileConfigurationDTO[configurations.size()]));
            return detailedConfiguration;
        }
        catch (Exception e) {
            String message = "Error while loading available profile configurations for dialect " + dialect;
            log.error((Object)message, (Throwable)e);
            throw new ProfileManagementException(message, e);
        }
    }

    public ClaimConfigurationDTO[] getProfileConfiguration(String dialect, String profileConfig) throws ProfileManagementException {
        UserRealm realm = null;
        ProfileConfigurationManager profileManager = null;
        ClaimManager claimManager = null;
        org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfiguration = null;
        ClaimConfigurationDTO claim = null;
        ArrayList<ClaimConfigurationDTO> claimList = null;
        List hiddenClaims = null;
        List overriddenClaims = null;
        List inheritedClaims = null;
        Claim[] definedClaims = null;
        ArrayList<String> definedClaimsList = null;
        this.validateInputParameters(new String[]{dialect, profileConfig});
        try {
            realm = this.getRealm();
            profileManager = realm.getProfileConfigurationManager();
            if (profileManager == null) {
                String message = "No profile configurations defined";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                return null;
            }
            claimManager = realm.getClaimManager();
            if (claimManager == null) {
                String message = "No claim configurations defined";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new ProfileManagementException(message);
            }
            definedClaimsList = new ArrayList<String>();
            definedClaims = (Claim[])claimManager.getAllClaims(dialect);
            for (int i = 0; i < definedClaims.length; ++i) {
                definedClaimsList.add(definedClaims[i].getClaimUri());
            }
            profileConfiguration = (org.wso2.carbon.user.core.profile.ProfileConfiguration)profileManager.getProfileConfig(profileConfig);
            claimList = new ArrayList<ClaimConfigurationDTO>();
            hiddenClaims = profileConfiguration.getHiddenClaims();
            if (hiddenClaims != null) {
                for (String string : hiddenClaims) {
                    claim = new ClaimConfigurationDTO();
                    claim.setClaimUri(string);
                    claim.setBehavior("Hidden");
                    if (!definedClaimsList.contains(string)) continue;
                    claimList.add(claim);
                    definedClaimsList.remove(string);
                }
            }
            if ((overriddenClaims = profileConfiguration.getOverriddenClaims()) != null) {
                for (String string : overriddenClaims) {
                    claim = new ClaimConfigurationDTO();
                    claim.setClaimUri(string);
                    claim.setBehavior("Overridden");
                    if (!definedClaimsList.contains(string)) continue;
                    claimList.add(claim);
                    definedClaimsList.remove(string);
                }
            }
            if ((inheritedClaims = profileConfiguration.getInheritedClaims()) != null) {
                for (String string : inheritedClaims) {
                    claim = new ClaimConfigurationDTO();
                    claim.setClaimUri(string);
                    claim.setBehavior("Inherited");
                    if (!definedClaimsList.contains(string)) continue;
                    claimList.add(claim);
                    definedClaimsList.remove(string);
                }
            }
            for (String definedClaim : definedClaimsList) {
                ClaimConfigurationDTO dto = null;
                dto = new ClaimConfigurationDTO();
                dto.setClaimUri(definedClaim);
                dto.setBehavior("Inherited");
                claimList.add(dto);
            }
        }
        catch (Exception e) {
            String message = "Error while loading available profile configurations for dialect " + dialect + "Profile configuration " + profileConfig;
            log.error((Object)message, (Throwable)e);
            throw new ProfileManagementException(message, e);
        }
        return claimList.toArray(new ClaimConfigurationDTO[claimList.size()]);
    }

    public DialectDTO[] getDialects() throws ProfileManagementException {
        UserRealm realm = null;
        ProfileConfigurationManager profileManager = null;
        org.wso2.carbon.user.core.profile.ProfileConfiguration[] profileConfigs = null;
        Object iterator = null;
        HashMap<String, DialectDTO> basicConfigurations = null;
        String[] dialects = null;
        try {
            realm = this.getRealm();
            profileManager = realm.getProfileConfigurationManager();
            if (profileManager == null) {
                String message = "No profile configurations defined ";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                return null;
            }
            profileConfigs = (org.wso2.carbon.user.core.profile.ProfileConfiguration[])profileManager.getAllProfiles();
            basicConfigurations = new HashMap<String, DialectDTO>();
            for (org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig : profileConfigs) {
                ArrayList<String> names = null;
                DialectDTO dialectdto = null;
                String dialect = null;
                dialect = profileConfig.getDialectName();
                if (basicConfigurations.containsKey(dialect)) {
                    dialectdto = (DialectDTO)basicConfigurations.get(dialect);
                } else {
                    dialectdto = new DialectDTO();
                    dialectdto.setDialectUri(dialect);
                    dialectdto.setProfileConfigurations(new String[0]);
                    basicConfigurations.put(dialect, dialectdto);
                }
                names = new ArrayList<String>(Arrays.asList(dialectdto.getProfileConfigurations()));
                names.add(profileConfig.getProfileName());
                dialectdto.setProfileConfigurations(names.toArray(new String[names.size()]));
            }
            dialects = this.getAllClaimDailects();
            for (int i = 0; i < dialects.length; ++i) {
                if (basicConfigurations.containsKey(dialects[i])) continue;
                DialectDTO dialectdto = null;
                dialectdto = new DialectDTO();
                dialectdto.setDialectUri(dialects[i]);
                dialectdto.setProfileConfigurations(new String[0]);
                if (!"http://wso2.org/claims".equals(dialects[i])) continue;
                basicConfigurations.put(dialects[i], dialectdto);
            }
            return basicConfigurations.values().toArray(new DialectDTO[basicConfigurations.values().size()]);
        }
        catch (Exception e) {
            String message = "Error while loading available dialects ";
            log.error((Object)message, (Throwable)e);
            throw new ProfileManagementException(message, e);
        }
    }

    public void deleteProfileConfiguraiton(String dialect, String profileName) throws ProfileManagementException {
        UserRealm realm = this.getRealm();
        try {
            if ("default".equals(profileName)) {
                throw new ProfileManagementException("Cannot delete default profile");
            }
            ProfileConfigurationManager admin = realm.getProfileConfigurationManager();
            org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig = new org.wso2.carbon.user.core.profile.ProfileConfiguration(profileName, dialect, new ArrayList(), new ArrayList(), new ArrayList());
            admin.deleteProfileConfig((ProfileConfiguration)profileConfig);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            throw new ProfileManagementException("Could not delete profil configuration.", e);
        }
    }

    private String[] getAllClaimDailects() throws Exception {
        UserRealm realm = this.getRealm();
        ClaimManager claimsManager = realm.getClaimManager();
        if (claimsManager == null) {
            String message = "No claim configurations defined";
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            return null;
        }
        Claim[] claims = (Claim[])claimsManager.getAllClaims();
        ArrayList<String> dialects = new ArrayList<String>();
        for (int i = 0; i < claims.length; ++i) {
            if (dialects.contains(claims[i].getDialectURI())) continue;
            dialects.add(claims[i].getDialectURI());
        }
        return dialects.toArray(new String[dialects.size()]);
    }

    public void addProfile(String profileName, String dialectName, ClaimConfigurationDTO[] claimsConfiguration) throws ProfileManagementException {
        this.validateInputParameters(new String[]{profileName, dialectName});
        try {
            UserRealm realm = null;
            ProfileConfigurationManager profileManager = null;
            realm = this.getRealm();
            profileManager = realm.getProfileConfigurationManager();
            if (profileManager == null) {
                String message = "No profile configurations defined";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new ProfileManagementException(message);
            }
            org.wso2.carbon.user.core.profile.ProfileConfiguration profConfig = (org.wso2.carbon.user.core.profile.ProfileConfiguration)profileManager.getProfileConfig(profileName);
            if (profConfig != null) {
                String message = "Profile configuration already exist for the user store. Please select a different name.";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new ProfileManagementException(message);
            }
            ArrayList<String> hidden = new ArrayList<String>();
            ArrayList<String> overridden = new ArrayList<String>();
            ArrayList<String> inherited = new ArrayList<String>();
            for (ClaimConfigurationDTO claim : claimsConfiguration) {
                String claimURI = claim.getClaimUri();
                String behavior = claim.getBehavior();
                if ("Hidden".equals(behavior)) {
                    hidden.add(claimURI);
                    continue;
                }
                if ("Overridden".equals(behavior)) {
                    overridden.add(claimURI);
                    continue;
                }
                inherited.add(claimURI);
            }
            org.wso2.carbon.user.core.profile.ProfileConfiguration config = new org.wso2.carbon.user.core.profile.ProfileConfiguration(profileName, hidden, overridden, inherited);
            config.setDialectName(dialectName);
            profileManager.addProfileConfig((ProfileConfiguration)config);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String message = "Error while adding profile configurations for dialect " + dialectName;
            log.error((Object)message, (Throwable)e);
            throw new ProfileManagementException(message, e);
        }
    }

    public DialectDTO[] getDialectsForUserStore() throws ProfileManagementException {
        UserRealm realm = null;
        ProfileConfigurationManager profileAdmin = null;
        org.wso2.carbon.user.core.profile.ProfileConfiguration[] profileConfigs = null;
        Object iterator = null;
        HashMap<String, DialectDTO> basicConfigurations = null;
        String[] dialects = null;
        try {
            realm = this.getRealm();
            profileAdmin = realm.getProfileConfigurationManager();
            if (profileAdmin == null) {
                String message = "No profile configurations defined";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                return null;
            }
            profileConfigs = (org.wso2.carbon.user.core.profile.ProfileConfiguration[])profileAdmin.getAllProfiles();
            basicConfigurations = new HashMap<String, DialectDTO>();
            for (org.wso2.carbon.user.core.profile.ProfileConfiguration profileConfig : profileConfigs) {
                ArrayList<String> names = null;
                DialectDTO dialectdto = null;
                String dialect = null;
                dialect = profileConfig.getDialectName();
                if (basicConfigurations.containsKey(dialect)) {
                    dialectdto = (DialectDTO)basicConfigurations.get(dialect);
                } else {
                    dialectdto = new DialectDTO();
                    dialectdto.setDialectUri(dialect);
                    dialectdto.setProfileConfigurations(new String[0]);
                    basicConfigurations.put(dialect, dialectdto);
                }
                names = new ArrayList<String>(Arrays.asList(dialectdto.getProfileConfigurations()));
                names.add(profileConfig.getProfileName());
                dialectdto.setProfileConfigurations(names.toArray(new String[names.size()]));
            }
            dialects = this.getAllClaimDailects();
            for (int i = 0; i < dialects.length; ++i) {
                if (basicConfigurations.containsKey(dialects[i])) continue;
                DialectDTO dialectdto = null;
                dialectdto = new DialectDTO();
                dialectdto.setDialectUri(dialects[i]);
                dialectdto.setProfileConfigurations(new String[0]);
                if (!"http://wso2.org/claims".equals(dialects[i])) continue;
                basicConfigurations.put(dialects[i], dialectdto);
            }
            return basicConfigurations.values().toArray(new DialectDTO[basicConfigurations.values().size()]);
        }
        catch (Exception e) {
            String message = "Error while loading available dialects";
            log.error((Object)message, (Throwable)e);
            throw new ProfileManagementException(message, e);
        }
    }

    public void updateClaimMappingBehavior(String profileName, ClaimConfigurationDTO[] claimsConfiguration) throws ProfileManagementException {
        UserRealm realm = null;
        ProfileConfigurationManager profileManager = null;
        this.validateInputParameters(new String[]{profileName});
        try {
            realm = this.getRealm();
            profileManager = realm.getProfileConfigurationManager();
            if (profileManager == null) {
                String message = "No profile configurations defined";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw new ProfileManagementException(message);
            }
            org.wso2.carbon.user.core.profile.ProfileConfiguration config = (org.wso2.carbon.user.core.profile.ProfileConfiguration)profileManager.getProfileConfig(profileName);
            ArrayList<String> hidden = new ArrayList<String>();
            ArrayList<String> overridden = new ArrayList<String>();
            ArrayList<String> inherited = new ArrayList<String>();
            for (ClaimConfigurationDTO claim : claimsConfiguration) {
                String claimURI = claim.getClaimUri();
                String behavior = claim.getBehavior();
                if ("Hidden".equals(behavior)) {
                    hidden.add(claimURI);
                    continue;
                }
                if ("Overridden".equals(behavior)) {
                    overridden.add(claimURI);
                    continue;
                }
                inherited.add(claimURI);
            }
            config.setHiddenClaims(hidden);
            config.setInheritedClaims(inherited);
            config.setOverriddenClaims(overridden);
            profileManager.updateProfileConfig((ProfileConfiguration)config);
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            String message = "Error occurred while upating profile configurations" + profileName;
            log.error((Object)message, (Throwable)e);
            throw new ProfileManagementException(message, e);
        }
    }

    public ClaimConfigurationDTO[] getClaimConfigurations(String dialect) throws ProfileManagementException {
        UserRealm realm = null;
        ClaimManager claimsManager = null;
        Claim[] claims = null;
        ArrayList<ClaimConfigurationDTO> claimList = null;
        this.validateInputParameters(new String[]{dialect});
        try {
            realm = this.getRealm();
            claimsManager = realm.getClaimManager();
            if (claimsManager == null) {
                String message = "No claim configurations defined";
                if (log.isDebugEnabled()) {
                    log.debug((Object)message);
                }
                throw null;
            }
            claims = (Claim[])claimsManager.getAllClaims(dialect);
            claimList = new ArrayList<ClaimConfigurationDTO>();
            for (int i = 0; i < claims.length; ++i) {
                ClaimConfigurationDTO claim = new ClaimConfigurationDTO();
                claim.setClaimUri(claims[i].getClaimUri());
                claim.setBehavior("Hidden");
                claimList.add(claim);
            }
        }
        catch (org.wso2.carbon.user.api.UserStoreException e) {
            log.error((Object)"Error occured while loading claim configurations", (Throwable)e);
            throw new ProfileManagementException("Error occured while loading claim configurations", e);
        }
        return claimList.toArray(new ClaimConfigurationDTO[claimList.size()]);
    }

    public boolean isAddProfileEnabled() throws ProfileManagementException {
        UserStoreManager userStoreManager = null;
        try {
            UserRealm realm = this.getRealm();
            userStoreManager = realm.getUserStoreManager();
        }
        catch (ProfileManagementException e) {
            String errorMessage = "Error obtaining user realm.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new ProfileManagementException(errorMessage, e);
        }
        catch (UserStoreException e) {
            String errorMessage = "Error obtaining UserStoreManager.";
            log.error((Object)errorMessage, (Throwable)e);
            throw new ProfileManagementException(errorMessage, e);
        }
        return userStoreManager.isMultipleProfilesAllowed();
    }

    private UserRealm getRealm() throws ProfileManagementException {
        try {
            return AdminServicesUtil.getUserRealm();
        }
        catch (CarbonException e) {
            throw new ProfileManagementException(e.getMessage(), e);
        }
    }

    private void validateInputParameters(String[] params) throws ProfileManagementException {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid input parameters");
            }
            throw new ProfileManagementException("Invalid input parameters");
        }
    }
}

