/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.priority.executors.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.priority.executors.stub.PriorityMediationAdminStub;
import org.wso2.carbon.priority.executors.ui.Executor;
import org.wso2.carbon.ui.CarbonUIUtil;

public class PriorityAdminClient {
    private static final Log log = LogFactory.getLog(PriorityAdminClient.class);
    private PriorityMediationAdminStub stub;

    public PriorityAdminClient(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serviceURL = backendServerURL + "PriorityMediationAdmin";
        this.stub = new PriorityMediationAdminStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void add(String name, Executor executor) throws RemoteException {
        OMElement e = executor.serialize();
        if (e != null) {
            this.stub.add(name, e);
        }
    }

    public Executor getExecutor(String name) throws RemoteException {
        OMElement e = this.stub.getExecutor(name);
        if (e != null) {
            OMElement execElement = e.getFirstElement();
            Executor ex = new Executor();
            ex.build(execElement);
            return ex;
        }
        return null;
    }

    public List<String> getExecutors() throws RemoteException {
        String[] list = this.stub.getExecutorList();
        ArrayList<String> l = new ArrayList<String>();
        if (list != null && (list.length != 1 || list[0] != null)) {
            l.addAll(Arrays.asList(list));
        }
        return l;
    }

    public void update(String name, Executor executor) throws RemoteException {
        OMElement e = executor.serialize();
        this.stub.update(name, e);
    }

    public void remove(String name) throws RemoteException {
        this.stub.remove(name);
    }
}

