/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.priority.executors.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.priority.executors.ui.Queue;

public class Executor {
    private Log log = LogFactory.getLog(Executor.class);
    public static final QName NAME_ATT = new QName("name");
    public static final QName CLASS_ATT = new QName("class");
    public static final QName ATT_NAME = new QName("name");
    public static final QName ATT_VALUE = new QName("value");
    public static final QName SIZE_ATT = new QName("size");
    public static final QName PRIORITY_ATT = new QName("priority");
    public static final QName IS_FIXED_ATT = new QName("isFixedSize");
    public static final QName BEFORE_EXECUTE_HANDLER = new QName("beforeExecuteHandler");
    public static final QName NEXT_QUEUE_ATT = new QName("nextQueue");
    public static final QName MAX_ATT = new QName("max");
    public static final QName CORE_ATT = new QName("core");
    public static final QName KEEP_ALIVE_ATT = new QName("keep-alive");
    private int core = 20;
    private int max = 100;
    private int keepAlive = 5;
    private List<Queue> queues = new ArrayList<Queue>();
    private String algorithm = null;
    private String beforeExecuteHandler = null;
    private String name = "";
    private boolean isFixedSize = true;
    public static final String NAMESPACE = "http://ws.apache.org/ns/synapse";

    public void build(OMElement e) throws AxisFault {
        OMElement queuesEle;
        OMAttribute handlerAtt;
        QName queuesQName = Executor.createQname(NAMESPACE, "queues");
        QName queueQName = Executor.createQname(NAMESPACE, "queue");
        QName threadsQName = Executor.createQname(NAMESPACE, "threads");
        OMAttribute nameAtt = e.getAttribute(NAME_ATT);
        if (nameAtt != null && !"".equals(nameAtt.getAttributeValue())) {
            this.setName(nameAtt.getAttributeValue());
        }
        if ((handlerAtt = e.getAttribute(BEFORE_EXECUTE_HANDLER)) != null) {
            this.beforeExecuteHandler = handlerAtt.getAttributeValue();
        }
        if ((queuesEle = e.getFirstChildWithName(queuesQName)) != null) {
            OMAttribute fixedSizeAtt;
            OMAttribute nextQueueAtt = queuesEle.getAttribute(NEXT_QUEUE_ATT);
            if (nextQueueAtt != null) {
                this.algorithm = nextQueueAtt.getAttributeValue();
            }
            if ((fixedSizeAtt = queuesEle.getAttribute(IS_FIXED_ATT)) != null) {
                this.isFixedSize = Boolean.parseBoolean(fixedSizeAtt.getAttributeValue());
            }
            this.queues = this.createQueues(queueQName, queuesEle, this.isFixedSize);
        } else {
            this.handlerException("Queues configuration is mandatory");
        }
        OMElement threadsEle = e.getFirstChildWithName(threadsQName);
        if (threadsEle != null) {
            OMAttribute keepAliveAttr;
            OMAttribute coreAttr;
            OMAttribute maxAttr = threadsEle.getAttribute(MAX_ATT);
            if (maxAttr != null) {
                this.setMax(Integer.parseInt(maxAttr.getAttributeValue()));
            }
            if ((coreAttr = threadsEle.getAttribute(CORE_ATT)) != null) {
                this.setCore(Integer.parseInt(coreAttr.getAttributeValue()));
            }
            if ((keepAliveAttr = threadsEle.getAttribute(KEEP_ALIVE_ATT)) != null) {
                this.setKeepAlive(Integer.parseInt(keepAliveAttr.getAttributeValue()));
            }
        }
    }

    public OMElement serialize() {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace nullNS = fac.createOMNamespace("", "");
        OMElement executorElement = Executor.createElement("priority-executor", NAMESPACE);
        if (this.name != null) {
            executorElement.addAttribute(fac.createOMAttribute("name", nullNS, this.name));
        }
        if (this.beforeExecuteHandler != null) {
            executorElement.addAttribute(fac.createOMAttribute("beforeExecuteHandler", nullNS, this.beforeExecuteHandler));
        }
        OMElement queuesEle = Executor.createElement("queues", NAMESPACE);
        if (this.algorithm != null) {
            queuesEle.addAttribute(fac.createOMAttribute("nextQueue", nullNS, this.algorithm));
        }
        if (!this.isFixedSize) {
            queuesEle.addAttribute(fac.createOMAttribute("isFixedSize", nullNS, Boolean.toString(false)));
        }
        for (Queue intQueue : this.queues) {
            OMElement queueEle = Executor.createElement("queue", NAMESPACE);
            if (this.isFixedSize) {
                queueEle.addAttribute(fac.createOMAttribute("size", nullNS, Integer.toString(intQueue.getCapacity())));
            }
            queueEle.addAttribute(fac.createOMAttribute("priority", nullNS, Integer.toString(intQueue.getPriority())));
            queuesEle.addChild((OMNode)queueEle);
        }
        executorElement.addChild((OMNode)queuesEle);
        OMElement threadsEle = Executor.createElement("threads", NAMESPACE);
        threadsEle.addAttribute(fac.createOMAttribute("max", nullNS, Integer.toString(this.max)));
        threadsEle.addAttribute(fac.createOMAttribute("core", nullNS, Integer.toString(this.core)));
        threadsEle.addAttribute(fac.createOMAttribute("keep-alive", nullNS, Integer.toString(this.keepAlive)));
        executorElement.addChild((OMNode)threadsEle);
        return executorElement;
    }

    private List<Queue> createQueues(QName qQName, OMElement queuesEle, boolean isFixedSize) throws AxisFault {
        ArrayList<Queue> internalQueues = new ArrayList<Queue>();
        Iterator it = queuesEle.getChildrenWithName(qQName);
        while (it.hasNext()) {
            int s = 0;
            int p = 0;
            OMElement qElement = (OMElement)it.next();
            String size = qElement.getAttributeValue(SIZE_ATT);
            String priority = qElement.getAttributeValue(PRIORITY_ATT);
            if (priority != null) {
                p = Integer.parseInt(priority);
            } else {
                this.handlerException("Priority must be specified");
            }
            if (size != null) {
                s = Integer.parseInt(size);
            } else if (isFixedSize) {
                this.handlerException("Queues should have a size");
            }
            Queue queue = isFixedSize ? new Queue(p, s) : new Queue(p);
            internalQueues.add(queue);
        }
        return internalQueues;
    }

    private void handlerException(String s) throws AxisFault {
        this.log.error((Object)s);
        throw new AxisFault(s);
    }

    private static QName createQname(String namespace, String name) {
        if (namespace == null) {
            return new QName(name);
        }
        return new QName(namespace, name);
    }

    private static OMElement createElement(String name, String namespace) {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        if (namespace == null) {
            return fac.createOMElement(new QName(name));
        }
        OMNamespace omNamespace = fac.createOMNamespace(namespace, "");
        return fac.createOMElement(name, omNamespace);
    }

    public int getCore() {
        return this.core;
    }

    public int getMax() {
        return this.max;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getBeforeExecuteHandler() {
        return this.beforeExecuteHandler;
    }

    public void setCore(int core) {
        this.core = core;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setKeepAlive(int keep_alive) {
        this.keepAlive = keep_alive;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBeforeExecuteHandler(String beforeExecuteHandler) {
        this.beforeExecuteHandler = beforeExecuteHandler;
    }

    public List<Queue> getQueues() {
        return this.queues;
    }

    public void setQueues(List<Queue> queues) {
        this.queues = queues;
    }

    public boolean isFixedSize() {
        return this.isFixedSize;
    }

    public void setFixedSize(boolean fixedSize) {
        this.isFixedSize = fixedSize;
    }
}

