/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.payment.ui.client;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.payment.stub.StratosPaymentStub;
import org.wso2.carbon.payment.stub.dto.ECDetailResponse;
import org.wso2.carbon.payment.stub.dto.ECResponse;
import org.wso2.carbon.payment.stub.dto.TransactionResponse;

public class PaymentServiceClient {
    private StratosPaymentStub stub;
    private static final Log log = LogFactory.getLog(PaymentServiceClient.class);

    public PaymentServiceClient(ConfigurationContext configCtx, String backendServerURL, String cookie) throws AxisFault {
        String serviceURL = backendServerURL + "StratosPayment";
        this.stub = new StratosPaymentStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public ECResponse initExpressCheckout(String amount, String successUrl, String cancelUrl) {
        ECResponse response = null;
        try {
            response = this.stub.initExpressCheckout(amount, successUrl, cancelUrl);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while initiating express checkout transaction: " + e.getMessage()));
        }
        return response;
    }

    public ECDetailResponse getExpressCheckoutDetails(String token) throws Exception {
        ECDetailResponse detailResponse = null;
        try {
            detailResponse = this.stub.getExpressCheckoutDetails(token);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while getting express checkout details " + e.getMessage()));
            throw e;
        }
        return detailResponse;
    }

    public TransactionResponse doExpressCheckout(String token, String payerId, String amount, String tenantDomain) throws Exception {
        TransactionResponse tr = new TransactionResponse();
        try {
            tr = this.stub.doExpressCheckout(token, payerId, amount, tenantDomain);
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while DoExpressCheckout operation: " + e.getMessage()));
            throw e;
        }
        return tr;
    }
}

