/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.payment.paypal.internal;

import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.profiles.ProfileFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.business.messaging.paypal.integration.PaypalSOAPProxy;
import org.wso2.carbon.payment.paypal.services.PaypalService;
import org.wso2.carbon.stratos.common.util.CommonUtil;
import org.wso2.carbon.stratos.common.util.StratosConfiguration;

public class PaymentServiceComponent {
    private static Log log = LogFactory.getLog(PaymentServiceComponent.class);

    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"Activating PaymentService Bundle");
        try {
            if (CommonUtil.getStratosConfig() == null) {
                StratosConfiguration stratosConfig = CommonUtil.loadStratosConfiguration();
                CommonUtil.setStratosConfig((StratosConfiguration)stratosConfig);
            }
            APIProfile profile = ProfileFactory.createSignatureAPIProfile();
            profile.setAPIUsername(CommonUtil.getStratosConfig().getPaypalAPIUsername());
            profile.setAPIPassword(CommonUtil.getStratosConfig().getPaypalAPIPassword());
            profile.setSignature(CommonUtil.getStratosConfig().getPaypalAPISignature());
            profile.setEnvironment(CommonUtil.getStratosConfig().getPaypalEnvironment());
            PaypalService.proxy = PaypalSOAPProxy.createPaypalSOAPProxy((APIProfile)profile);
            log.info((Object)"PaymentService Bundle activated");
        }
        catch (Throwable e) {
            log.error((Object)("Error occurred while creating PayPalProxy: " + e.getMessage()), e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"PayPalService Bundle deactivated");
    }
}

