/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.payment.paypal.services;

import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.soap.api.AbstractRequestType;
import com.paypal.soap.api.BasicAmountType;
import com.paypal.soap.api.CurrencyCodeType;
import com.paypal.soap.api.DoExpressCheckoutPaymentRequestDetailsType;
import com.paypal.soap.api.DoExpressCheckoutPaymentRequestType;
import com.paypal.soap.api.DoExpressCheckoutPaymentResponseType;
import com.paypal.soap.api.GetExpressCheckoutDetailsRequestType;
import com.paypal.soap.api.GetExpressCheckoutDetailsResponseType;
import com.paypal.soap.api.PaymentActionCodeType;
import com.paypal.soap.api.PaymentDetailsType;
import com.paypal.soap.api.SetExpressCheckoutRequestDetailsType;
import com.paypal.soap.api.SetExpressCheckoutRequestType;
import com.paypal.soap.api.SetExpressCheckoutResponseType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.business.messaging.paypal.integration.PaypalSOAPProxy;
import org.wso2.carbon.payment.paypal.dto.ECDetailResponse;
import org.wso2.carbon.payment.paypal.dto.ECResponse;
import org.wso2.carbon.payment.paypal.dto.TransactionResponse;
import org.wso2.carbon.payment.paypal.util.PaymentConstants;
import org.wso2.carbon.payment.paypal.util.ResponsePopulator;

public class PaypalService {
    public static PaypalSOAPProxy proxy;
    private static Log log;
    private ResponsePopulator populator = new ResponsePopulator();

    public ECResponse initExpressCheckout(String amount, String successReturnUrl, String cancelReturnUrl) throws PayPalException {
        SetExpressCheckoutRequestType ecRequest = new SetExpressCheckoutRequestType();
        SetExpressCheckoutRequestDetailsType details = new SetExpressCheckoutRequestDetailsType();
        details.setReturnURL(successReturnUrl);
        details.setCancelURL(cancelReturnUrl);
        details.setNoShipping("1");
        BasicAmountType orderTotal = new BasicAmountType();
        orderTotal.set_value(amount);
        orderTotal.setCurrencyID(CurrencyCodeType.USD);
        details.setOrderTotal(orderTotal);
        details.setPaymentAction(PaymentActionCodeType.Sale);
        ecRequest.setSetExpressCheckoutRequestDetails(details);
        SetExpressCheckoutResponseType ecResponse = (SetExpressCheckoutResponseType)proxy.call(PaymentConstants.SET_EXPRESSCHECKOUT_OPERATION, (AbstractRequestType)ecRequest);
        return this.populator.populateSetECResponse(ecResponse);
    }

    public ECDetailResponse getExpressCheckoutDetails(String token) throws PayPalException {
        GetExpressCheckoutDetailsRequestType detailRequest = new GetExpressCheckoutDetailsRequestType();
        detailRequest.setToken(token);
        GetExpressCheckoutDetailsResponseType detailResponse = (GetExpressCheckoutDetailsResponseType)proxy.call(PaymentConstants.GET_EXPRESSCHECKOUT_OPERATION, (AbstractRequestType)detailRequest);
        return this.populator.populateECDetailResponse(detailResponse);
    }

    public TransactionResponse doExpressCheckout(String token, String payerId, String amount, String tenantDetails) throws PayPalException {
        DoExpressCheckoutPaymentRequestType doECRequest = new DoExpressCheckoutPaymentRequestType();
        DoExpressCheckoutPaymentRequestDetailsType paymentRequestDetails = new DoExpressCheckoutPaymentRequestDetailsType();
        paymentRequestDetails.setToken(token);
        paymentRequestDetails.setPayerID(payerId);
        log.debug((Object)("PayerId: " + payerId));
        paymentRequestDetails.setPaymentAction(PaymentActionCodeType.Sale);
        PaymentDetailsType paymentDetails = new PaymentDetailsType();
        BasicAmountType orderTotal = new BasicAmountType();
        orderTotal.set_value(amount);
        orderTotal.setCurrencyID(CurrencyCodeType.USD);
        paymentDetails.setOrderTotal(orderTotal);
        paymentDetails.setCustom(tenantDetails);
        paymentRequestDetails.setPaymentDetails(paymentDetails);
        doECRequest.setDoExpressCheckoutPaymentRequestDetails(paymentRequestDetails);
        DoExpressCheckoutPaymentResponseType doECResponse = (DoExpressCheckoutPaymentResponseType)proxy.call(PaymentConstants.DO_EXPRESSCHECKOUT_OPERATION, (AbstractRequestType)doECRequest);
        log.debug((Object)("DoEC Ack:" + doECResponse.getAck().toString()));
        if (PaymentConstants.RESPONSE_FAILURE.equals(doECResponse.getAck().toString()) && "10001".equals(doECResponse.getErrors(0).getErrorCode().toString())) {
            log.debug((Object)("Errors: " + doECResponse.getErrors().length));
            doECResponse = (DoExpressCheckoutPaymentResponseType)proxy.call(PaymentConstants.DO_EXPRESSCHECKOUT_OPERATION, (AbstractRequestType)doECRequest);
        }
        if (PaymentConstants.RESPONSE_SUCCESS.equals(doECResponse.getAck().toString()) && doECResponse.getDoExpressCheckoutPaymentResponseDetails() != null) {
            log.debug((Object)("DoEC Token: " + doECResponse.getDoExpressCheckoutPaymentResponseDetails().getToken().toString()));
        }
        TransactionResponse tr = this.populator.populateDoECResponse(doECResponse);
        return tr;
    }

    static {
        log = LogFactory.getLog(PaypalService.class);
    }
}

