/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.payment.paypal.util;

import com.paypal.soap.api.AddressType;
import com.paypal.soap.api.BasicAmountType;
import com.paypal.soap.api.DoExpressCheckoutPaymentResponseDetailsType;
import com.paypal.soap.api.DoExpressCheckoutPaymentResponseType;
import com.paypal.soap.api.ErrorType;
import com.paypal.soap.api.GetExpressCheckoutDetailsResponseDetailsType;
import com.paypal.soap.api.GetExpressCheckoutDetailsResponseType;
import com.paypal.soap.api.PayerInfoType;
import com.paypal.soap.api.PaymentDetailsType;
import com.paypal.soap.api.PaymentInfoType;
import com.paypal.soap.api.PersonNameType;
import com.paypal.soap.api.SetExpressCheckoutResponseType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.payment.paypal.dto.Address;
import org.wso2.carbon.payment.paypal.dto.ECDetailResponse;
import org.wso2.carbon.payment.paypal.dto.ECResponse;
import org.wso2.carbon.payment.paypal.dto.Payer;
import org.wso2.carbon.payment.paypal.dto.PaypalError;
import org.wso2.carbon.payment.paypal.dto.TransactionResponse;
import org.wso2.carbon.payment.paypal.util.PaymentConstants;

public class ResponsePopulator {
    private static Log log = LogFactory.getLog(ResponsePopulator.class);

    public ECResponse populateSetECResponse(SetExpressCheckoutResponseType response) {
        ECResponse ecr = new ECResponse();
        if (response == null) {
            return ecr;
        }
        ecr.setTimestamp(response.getTimestamp().toString());
        ecr.setAck(response.getAck().toString());
        if (PaymentConstants.RESPONSE_SUCCESS.equals(ecr.getAck())) {
            ecr.setToken(response.getToken());
        }
        if (PaymentConstants.RESPONSE_FAILURE.equals(ecr.getAck())) {
            PaypalError error = new PaypalError();
            ErrorType et = response.getErrors(0);
            if (et != null) {
                error.setErrorCode(et.getErrorCode().toString());
                error.setShortMessage(et.getShortMessage());
                error.setLongMessage(et.getLongMessage());
            }
            ecr.setError(error);
        }
        return ecr;
    }

    public ECDetailResponse populateECDetailResponse(GetExpressCheckoutDetailsResponseType response) {
        ECDetailResponse ecdr = new ECDetailResponse();
        if (response == null) {
            return ecdr;
        }
        ecdr.setTimestamp(response.getTimestamp().toString());
        ecdr.setAck(response.getAck().toString());
        if (PaymentConstants.RESPONSE_SUCCESS.equals(ecdr.getAck())) {
            BasicAmountType bat;
            GetExpressCheckoutDetailsResponseDetailsType responseDetails = response.getGetExpressCheckoutDetailsResponseDetails();
            ecdr.setToken(responseDetails.getToken().toString());
            PayerInfoType payerInfo = responseDetails.getPayerInfo();
            Payer payer = new Payer();
            if (payerInfo != null) {
                payer.setBusiness(payerInfo.getPayerBusiness());
                payer.setPayerId(payerInfo.getPayerID());
                PersonNameType personName = payerInfo.getPayerName();
                if (personName != null) {
                    payer.setFirstName(personName.getFirstName());
                    payer.setLastName(personName.getLastName());
                }
                ecdr.setPayer(payer);
            }
            AddressType addressType = responseDetails.getBillingAddress();
            Address address = new Address();
            if (addressType != null) {
                address.setName(addressType.getName());
                address.setStreet1(addressType.getStreet1());
                address.setStreet2(addressType.getStreet2());
                address.setCity(addressType.getCityName());
                address.setCountry(addressType.getCountryName());
                address.setPostalCode(addressType.getPostalCode());
                address.setState(addressType.getStateOrProvince());
                address.setPhone(addressType.getPhone());
            }
            ecdr.setAddress(address);
            PaymentDetailsType paymentDetails = responseDetails.getPaymentDetails();
            if (paymentDetails != null && (bat = paymentDetails.getOrderTotal()) != null) {
                ecdr.setOrderTotal(bat.get_value());
            }
        } else {
            PaypalError error = new PaypalError();
            ErrorType et = response.getErrors(0);
            if (et != null) {
                error.setErrorCode(et.getErrorCode().toString());
                error.setShortMessage(et.getShortMessage());
                error.setLongMessage(et.getLongMessage());
            }
            ecdr.setError(error);
        }
        return ecdr;
    }

    public TransactionResponse populateDoECResponse(DoExpressCheckoutPaymentResponseType response) {
        TransactionResponse tr = new TransactionResponse();
        tr.setTimestamp(response.getTimestamp().toString());
        tr.setAck(response.getAck().toString());
        if (PaymentConstants.RESPONSE_SUCCESS.equals(tr.getAck())) {
            DoExpressCheckoutPaymentResponseDetailsType responseDetails = response.getDoExpressCheckoutPaymentResponseDetails();
            tr.setToken(responseDetails.getToken());
            tr.setTransactionId(responseDetails.getPaymentInfo().getTransactionID());
            PaymentInfoType paymentInfo = responseDetails.getPaymentInfo();
            tr.setAmount(paymentInfo.getGrossAmount().get_value());
            tr.setPaymentStatus(paymentInfo.getPaymentStatus().toString());
            log.debug((Object)("Payment Status: " + paymentInfo.getPaymentStatus().toString()));
        } else {
            ErrorType et = response.getErrors(0);
            PaypalError error = new PaypalError();
            error.setErrorCode(et.getErrorCode().toString());
            error.setShortMessage(et.getShortMessage());
            error.setLongMessage(et.getLongMessage());
            tr.setError(error);
        }
        return tr;
    }
}

