/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.osgi.security;

import java.security.AllPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.permissionadmin.PermissionAdmin;
import org.osgi.service.permissionadmin.PermissionInfo;

public class PermissionManager
implements BundleListener {
    private BundleContext context;

    public PermissionManager(BundleContext context) {
        this.context = context;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        int event = bundleEvent.getType();
        if (event == 1) {
            Bundle installedBundle = bundleEvent.getBundle();
            String bundleLocation = installedBundle.getLocation();
            PermissionAdmin permissionAdmin = this.getPermissionAdmin(this.context);
            if (permissionAdmin != null && bundleLocation.startsWith("reference:file:plugins/")) {
                PermissionInfo[] superTenantPermInfos = new PermissionInfo[]{new PermissionInfo(AllPermission.class.getName(), "", "")};
                permissionAdmin.setPermissions(bundleLocation, superTenantPermInfos);
            }
        }
    }

    public PermissionAdmin getPermissionAdmin(BundleContext context) {
        return (PermissionAdmin)context.getService(context.getServiceReference(PermissionAdmin.class.getName()));
    }
}

