/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryTaskAvailabilityManager {
    private static final Log log = LogFactory.getLog(RegistryTaskAvailabilityManager.class);
    public static final String REG_TASK_AVAIL_MANAGE_BASE_PATH = "/repository/components/org.wso2.carbon.tasks/availability";
    private Registry registry = TaskUtils.getGovRegistryForTenant(-1234);

    public Registry getRegistry() {
        return this.registry;
    }

    private String generateTaskAvailablePath(int tenantId) {
        return "/repository/components/org.wso2.carbon.tasks/availability/" + tenantId;
    }

    public boolean checkTasksAvailable(int tenantId) throws TaskException {
        try {
            boolean result = this.registry.resourceExists(this.generateTaskAvailablePath(tenantId));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Checking tasks available for tenant: " + tenantId + ", result: " + result));
            }
            return result;
        }
        catch (RegistryException e) {
            throw new TaskException("Error in checking tasks availability: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    public void setTasksAvailable(int tenantId, boolean exists) throws TaskException {
        try {
            if (exists) {
                this.getRegistry().put(this.generateTaskAvailablePath(tenantId), this.getRegistry().newResource());
            } else {
                this.getRegistry().delete(this.generateTaskAvailablePath(tenantId));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting tasks available for tenant: " + tenantId + ", exists: " + exists));
            }
        }
        catch (Exception e) {
            throw new TaskException("Error in setting tasks availability: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }
}

