/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.coordination.common.CoordinationException;
import org.wso2.carbon.coordination.core.sync.Group;
import org.wso2.carbon.coordination.core.sync.GroupEventListener;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskInfo;
import org.wso2.carbon.ntask.core.TaskLocationResolver;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskRepository;
import org.wso2.carbon.ntask.core.TaskServiceContext;
import org.wso2.carbon.ntask.core.impl.AbstractQuartzTaskManager;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

public class ClusteredTaskManager
extends AbstractQuartzTaskManager {
    private static final String TASK_SERVER_COUNT_SYS_PROP = "task.server.count";
    private static final Log log = LogFactory.getLog(ClusteredTaskManager.class);
    public static final String TASK_GROUP_BASE_NAME = "__TASK_GROUP_";
    private ClusterGroupCommunicator clusterComm;
    private Map<String, String> taskNameMemberIdMap = new HashMap<String, String>();

    public ClusteredTaskManager(TaskRepository taskRepository, boolean checkServerCount) throws TaskException {
        super(taskRepository);
        String taskType = this.getTaskRepository().getTasksType();
        try {
            Group group = TasksDSComponent.getCoordinationService().createGroup(TASK_GROUP_BASE_NAME + taskType);
            if (checkServerCount) {
                this.checkServerCount(group);
            }
            this.clusterComm = new ClusterGroupCommunicator(group);
        }
        catch (Exception e) {
            throw new TaskException("Error in creating clustered task manager for task type: " + taskType, TaskException.Code.UNKNOWN, e);
        }
    }

    private void checkServerCount(Group group) throws Exception {
        int serverCount = 1;
        try {
            String countVal = System.getProperty(TASK_SERVER_COUNT_SYS_PROP);
            if (countVal != null) {
                serverCount = Integer.parseInt(countVal);
            }
        }
        catch (Exception ignore) {
            log.warn((Object)"Invalid value for Java system property: task.server.count");
        }
        log.info((Object)("Waiting for " + serverCount + " task servers..."));
        group.waitForMemberCount(serverCount);
        log.info((Object)"All task servers activated.");
    }

    public Map<String, String> getTaskNameMemberIdMap() {
        return this.taskNameMemberIdMap;
    }

    public ClusterGroupCommunicator getClusterComm() {
        return this.clusterComm;
    }

    @Override
    public void scheduleAllTasks() throws TaskException {
        if (this.getClusterComm().isLeader()) {
            log.info((Object)"Scheduling all tasks...");
            List<TaskInfo> tasks = this.getAllTasks();
            for (TaskInfo task : tasks) {
                this.scheduleTask(task.getName());
            }
        }
    }

    private void scheduleMissingTasks() throws TaskException {
        List<List<TaskInfo>> tasksInServers = this.getAllTasksInServers();
        ArrayList<TaskInfo> scheduledTasks = new ArrayList<TaskInfo>();
        for (List<TaskInfo> entry : tasksInServers) {
            scheduledTasks.addAll(entry);
        }
        List<TaskInfo> allTasks = this.getAllTasks();
        ArrayList<TaskInfo> missingTasks = new ArrayList<TaskInfo>(allTasks);
        missingTasks.removeAll(scheduledTasks);
        for (TaskInfo task : missingTasks) {
            this.scheduleTask(task.getName());
        }
    }

    @Override
    public void scheduleTask(String taskName) throws TaskException {
        try {
            String memberId = this.getClusterComm().getMemberIdFromTaskName(taskName);
            this.getClusterComm().scheduleTask(memberId, taskName);
        }
        catch (Exception e) {
            throw new TaskException("Error in scheduling task: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void rescheduleTask(String taskName) throws TaskException {
        try {
            String memberId = this.getClusterComm().getMemberIdFromTaskName(taskName);
            this.getClusterComm().rescheduleTask(memberId, taskName);
        }
        catch (Exception e) {
            throw new TaskException("Error in rescheduling task: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public List<TaskInfo> getTasksInServer(int location) throws TaskException {
        try {
            List ids = this.getClusterComm().getGroup().getMemberIds();
            String memberId = (String)ids.get(location % ids.size());
            return this.getClusterComm().getTasksInServer(memberId);
        }
        catch (Exception e) {
            throw new TaskException("Error in getting tasks in server: " + location + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public Map<String, TaskManager.TaskState> getAllTaskStates() throws TaskException {
        try {
            List<TaskInfo> tasks = this.getAllTasks();
            HashMap<String, TaskManager.TaskState> result = new HashMap<String, TaskManager.TaskState>();
            for (TaskInfo task : tasks) {
                result.put(task.getName(), this.getTaskState(task.getName()));
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskException("Error in getting all task states: " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public TaskManager.TaskState getTaskState(String taskName) throws TaskException {
        try {
            String memberId = this.getClusterComm().getMemberIdFromTaskName(taskName);
            return this.getClusterComm().getTaskState(memberId, taskName);
        }
        catch (Exception e) {
            throw new TaskException("Error in getting task state: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void deleteTask(String taskName) throws TaskException {
        try {
            String memberId = this.getClusterComm().getMemberIdFromTaskName(taskName);
            this.getClusterComm().deleteTask(memberId, taskName);
            this.getTaskRepository().deleteTask(taskName);
        }
        catch (Exception e) {
            throw new TaskException("Error in deleting task: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void pauseTask(String taskName) throws TaskException {
        try {
            String memberId = this.getClusterComm().getMemberIdFromTaskName(taskName);
            this.getClusterComm().pauseTask(memberId, taskName);
        }
        catch (Exception e) {
            throw new TaskException("Error in pausing task: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void resumeTask(String taskName) throws TaskException {
        try {
            String memberId = this.getClusterComm().getMemberIdFromTaskName(taskName);
            this.getClusterComm().resumeTask(memberId, taskName);
        }
        catch (Exception e) {
            throw new TaskException("Error in resuming task: " + taskName + " : " + e.getMessage(), TaskException.Code.UNKNOWN, e);
        }
    }

    @Override
    public void registerTask(TaskInfo taskInfo) throws TaskException {
        this.registerLocalTask(taskInfo);
    }

    @Override
    public TaskInfo getTask(String taskName) throws TaskException {
        return this.getTaskRepository().getTask(taskName);
    }

    @Override
    public List<TaskInfo> getAllTasks() throws TaskException {
        return this.getTaskRepository().getAllTasks();
    }

    @Override
    public int getServerCount() throws TaskException {
        try {
            return this.getClusterComm().getGroup().getMemberIds().size();
        }
        catch (CoordinationException e) {
            throw new TaskException("Error in getting server count: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
    }

    private TaskServiceContext getTaskServiceContext() throws Exception {
        TaskServiceContext context = new TaskServiceContext(this.getAllTasks(), this.getServerCount());
        return context;
    }

    private String locateMemberForTask(String taskName) throws Exception {
        int location = this.getTaskLocation(taskName);
        List ids = this.getClusterComm().getGroup().getMemberIds();
        int index = location % ids.size();
        return (String)ids.get(index);
    }

    private int getTaskLocation(String taskName) throws Exception {
        TaskInfo taskInfo = this.getTask(taskName);
        TaskLocationResolver locationResolver = (TaskLocationResolver)Class.forName(taskInfo.getLocationResolverClass()).newInstance();
        return locationResolver.getLocation(this.getTaskServiceContext(), taskInfo);
    }

    @Override
    public List<List<TaskInfo>> getAllTasksInServers() throws TaskException {
        ArrayList<List<TaskInfo>> result = new ArrayList<List<TaskInfo>>();
        try {
            List ids = this.getClusterComm().getGroup().getMemberIds();
            for (int i = 0; i < ids.size(); ++i) {
                result.add(this.getTasksInServer(i));
            }
        }
        catch (CoordinationException e) {
            throw new TaskException("Error in retreiving all tasks in servers: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
        }
        return result;
    }

    @Override
    public boolean isTaskScheduled(String taskName) throws TaskException {
        return false;
    }

    private static byte[] objectToBytes(Object obj) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream objOut = new ObjectOutputStream(byteOut);
        objOut.writeObject(obj);
        objOut.close();
        return byteOut.toByteArray();
    }

    private static Object bytesToObject(byte[] data) throws Exception {
        ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
        ObjectInputStream objIn = new ObjectInputStream(byteIn);
        Object obj = objIn.readObject();
        objIn.close();
        return obj;
    }

    public static final class OperationNames {
        public static final String MEMBER_ID_FROM_TASK_NAME = "MEMBER_ID_FROM_TASK_NAME";
        public static final String SCHEDULE_TASK = "SCHEDULE_TASK";
        public static final String RESCHEDULE_TASK = "RESCHEDULE_TASK";
        public static final String DELETE_TASK = "DELETE_TASK";
        public static final String PAUSE_TASK = "PAUSE_TASK";
        public static final String RESUME_TASK = "RESUME_TASK";
        public static final String GET_TASKS_IN_SERVER = "GET_TASKS_IN_SERVER";
        public static final String GET_TASK_STATE = "GET_TASK_STATE";
    }

    public static class OperationResponse
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private byte[] payload;

        public OperationResponse(byte[] payload) {
            this.payload = payload;
        }

        public byte[] getPayload() {
            return this.payload;
        }
    }

    public static class OperationRequest
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String opName;
        private byte[] payload;

        public OperationRequest(String opName, byte[] payload) {
            this.opName = opName;
            this.payload = payload;
        }

        public String getOpName() {
            return this.opName;
        }

        public byte[] getPayload() {
            return this.payload;
        }
    }

    private class ClusterGroupCommunicator
    implements GroupEventListener {
        private Group group;
        private boolean leader;

        public ClusterGroupCommunicator(Group group) throws TaskException {
            this.group = group;
            this.getGroup().setGroupEventListener((GroupEventListener)this);
            try {
                this.leader = this.getGroup().getLeaderId().equals(this.getGroup().getMemberId());
            }
            catch (CoordinationException e) {
                throw new TaskException("Error in creating cluster group communicator: " + e.getMessage(), TaskException.Code.UNKNOWN, (Exception)((Object)e));
            }
        }

        public boolean isLeader() {
            return this.leader;
        }

        public Group getGroup() {
            return this.group;
        }

        public void onGroupMessage(byte[] data) {
        }

        public void onLeaderChange(String leaderId) {
            if (log.isDebugEnabled()) {
                log.info((Object)("Task server leader changed: " + leaderId));
            }
            this.leader = leaderId.equals(this.getGroup().getMemberId());
            try {
                if (this.isLeader()) {
                    log.info((Object)"Task server leader changed, rescheduling missing tasks...");
                    ClusteredTaskManager.this.scheduleMissingTasks();
                }
            }
            catch (TaskException e) {
                log.error((Object)("Error in scheduling missing tasks: " + e.getMessage()), (Throwable)e);
            }
        }

        public void onMemberArrival(String mid) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("New task member arrived: " + mid));
            }
        }

        public void onMemberDeparture(String mid) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Task member departed: " + mid));
            }
            try {
                if (this.isLeader()) {
                    this.adjustTaskNameMemberIdMapWithRemoval(mid);
                    log.info((Object)"Task member departed, rescheduling missing tasks...");
                    ClusteredTaskManager.this.scheduleMissingTasks();
                }
            }
            catch (TaskException e) {
                log.error((Object)("Error in scheduling missing tasks: " + e.getMessage()), (Throwable)e);
            }
        }

        private void adjustTaskNameMemberIdMapWithRemoval(String mid) {
            Iterator<Map.Entry<String, String>> itr = ClusteredTaskManager.this.getTaskNameMemberIdMap().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, String> entry = itr.next();
                if (!entry.getValue().equals(mid)) continue;
                itr.remove();
            }
        }

        private byte[] sendReceive(String memberId, String messageHeader, byte[] payload) throws Exception {
            OperationRequest req = new OperationRequest(messageHeader, payload);
            byte[] result = this.getGroup().sendReceive(memberId, ClusteredTaskManager.objectToBytes(req));
            OperationResponse res = (OperationResponse)ClusteredTaskManager.bytesToObject(result);
            return res.getPayload();
        }

        public String getMemberIdFromTaskName(String taskName) throws Exception {
            byte[] result = this.sendReceive(this.getGroup().getLeaderId(), "MEMBER_ID_FROM_TASK_NAME", taskName.getBytes());
            return new String(result);
        }

        private String getMemberIdFromTaskNameServer(String taskName) throws Exception {
            String value = ClusteredTaskManager.this.getTaskNameMemberIdMap().get(taskName);
            if (value == null) {
                value = ClusteredTaskManager.this.locateMemberForTask(taskName);
                ClusteredTaskManager.this.getTaskNameMemberIdMap().put(taskName, value);
            }
            return value;
        }

        public List<TaskInfo> getTasksInServer(String memberId) throws Exception {
            byte[] data = this.sendReceive(memberId, "GET_TASKS_IN_SERVER", new byte[0]);
            return (List)ClusteredTaskManager.bytesToObject(data);
        }

        public List<TaskInfo> getTasksInServerServer() throws Exception {
            return ClusteredTaskManager.this.getAllLocalScheduledTasks();
        }

        public TaskManager.TaskState getTaskState(String memberId, String taskName) throws Exception {
            byte[] data = this.sendReceive(memberId, "GET_TASK_STATE", new byte[0]);
            return (TaskManager.TaskState)((Object)ClusteredTaskManager.bytesToObject(data));
        }

        public TaskManager.TaskState getTaskStateServer(String taskName) throws Exception {
            return ClusteredTaskManager.this.getLocalTaskState(taskName);
        }

        public void scheduleTask(String memberId, String taskName) throws Exception {
            this.sendReceive(memberId, "SCHEDULE_TASK", taskName.getBytes());
        }

        private void scheduleTaskServer(String taskName) throws Exception {
            ClusteredTaskManager.this.scheduleLocalTask(taskName);
        }

        public void rescheduleTask(String memberId, String taskName) throws Exception {
            this.sendReceive(memberId, "RESCHEDULE_TASK", taskName.getBytes());
        }

        private void rescheduleTaskServer(String taskName) throws Exception {
            ClusteredTaskManager.this.rescheduleLocalTask(taskName);
        }

        public void deleteTask(String memberId, String taskName) throws Exception {
            this.sendReceive(memberId, "DELETE_TASK", taskName.getBytes());
        }

        private void deleteTaskServer(String taskName) throws Exception {
            ClusteredTaskManager.this.deleteLocalTask(taskName, false);
        }

        public void pauseTask(String memberId, String taskName) throws Exception {
            this.sendReceive(memberId, "PAUSE_TASK", taskName.getBytes());
        }

        private void pauseTaskServer(String taskName) throws Exception {
            ClusteredTaskManager.this.pauseLocalTask(taskName);
        }

        public void resumeTask(String memberId, String taskName) throws Exception {
            this.sendReceive(memberId, "RESUME_TASK", taskName.getBytes());
        }

        private void resumeTaskServer(String taskName) throws Exception {
            ClusteredTaskManager.this.resumeLocalTask(taskName);
        }

        public byte[] onPeerMessage(byte[] buff) throws CoordinationException {
            try {
                byte[] result = null;
                OperationRequest req = (OperationRequest)ClusteredTaskManager.bytesToObject(buff);
                if ("MEMBER_ID_FROM_TASK_NAME".equals(req.getOpName())) {
                    result = this.getMemberIdFromTaskNameServer(new String(req.getPayload())).getBytes();
                } else if ("SCHEDULE_TASK".equals(req.getOpName())) {
                    this.scheduleTaskServer(new String(req.getPayload()));
                    result = new byte[]{};
                } else if ("RESCHEDULE_TASK".equals(req.getOpName())) {
                    this.rescheduleTaskServer(new String(req.getPayload()));
                    result = new byte[]{};
                } else if ("DELETE_TASK".equals(req.getOpName())) {
                    this.deleteTaskServer(new String(req.getPayload()));
                    result = new byte[]{};
                } else if ("PAUSE_TASK".equals(req.getOpName())) {
                    this.pauseTaskServer(new String(req.getPayload()));
                    result = new byte[]{};
                } else if ("RESUME_TASK".equals(req.getOpName())) {
                    this.resumeTaskServer(new String(req.getPayload()));
                    result = new byte[]{};
                } else if ("GET_TASKS_IN_SERVER".equals(req.getOpName())) {
                    List<TaskInfo> tasks = this.getTasksInServerServer();
                    result = ClusteredTaskManager.objectToBytes(tasks);
                } else if ("GET_TASK_STATE".equals(req.getOpName())) {
                    TaskManager.TaskState taskState = this.getTaskStateServer(new String(req.getPayload()));
                    result = ClusteredTaskManager.objectToBytes((Object)taskState);
                }
                OperationResponse res = new OperationResponse(result);
                return ClusteredTaskManager.objectToBytes(res);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CoordinationException("Error in handling peer message: " + e.getMessage(), CoordinationException.ExceptionCode.GENERIC_ERROR, e);
            }
        }
    }
}

