/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.coordination.core.services.CoordinationService;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.ntask.common.TaskException;
import org.wso2.carbon.ntask.core.TaskManager;
import org.wso2.carbon.ntask.core.TaskUtils;
import org.wso2.carbon.ntask.core.impl.AbstractQuartzTaskManager;
import org.wso2.carbon.ntask.core.impl.ClusteredTaskManager;
import org.wso2.carbon.ntask.core.impl.RegistryBasedTaskRepository;
import org.wso2.carbon.ntask.core.impl.StandaloneTaskManager;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;
import org.wso2.carbon.ntask.core.service.TaskService;
import org.wso2.carbon.ntask.core.service.impl.RegistryTaskAvailabilityManager;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;

public class TaskServiceImpl
implements TaskService {
    private static final Log log = LogFactory.getLog(TaskServiceImpl.class);
    private Map<TaskManagerId, TaskManager> taskManagerMap;
    private Set<String> registeredTaskTypes = new HashSet<String>();
    private RegistryTaskAvailabilityManager taskAvailabilityManager;

    public TaskServiceImpl() throws TaskException {
        this.taskManagerMap = new HashMap<TaskManagerId, TaskManager>();
        this.taskAvailabilityManager = new RegistryTaskAvailabilityManager();
        this.initTaskManagers();
    }

    public Set<String> getRegisteredTaskTypes() {
        return this.registeredTaskTypes;
    }

    private Map<TaskManagerId, TaskManager> getTaskManagerMap() throws TaskException {
        return this.taskManagerMap;
    }

    private void initTaskManagers() throws TaskException {
        List<Integer> tenants = this.getAllTenantIds();
        for (int tid : tenants) {
            this.initTaskManagersForTenant(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTaskManagersForTenant(int tid) throws TaskException {
        try {
            SuperTenantCarbonContext.startTenantFlow();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tid);
            List<String> taskTypes = this.getTaskTypesForTenant(tid);
            for (String taskType : taskTypes) {
                TaskManagerId tmId = new TaskManagerId(tid, taskType);
                if (this.getTaskManagerMap().containsKey(tmId)) continue;
                TaskManager taskManager = this.createTaskManager(tmId, true);
                this.getTaskManagerMap().put(tmId, taskManager);
            }
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    private RegistryTaskAvailabilityManager getTaskAvailabilityManager() {
        return this.taskAvailabilityManager;
    }

    private List<String> getTaskTypesForTenant(int tid) throws TaskException {
        ArrayList<String> types = new ArrayList<String>();
        types.addAll(this.getRegisteredTaskTypes());
        Registry registry = TaskUtils.getGovRegistryForTenant(tid);
        try {
            String[] children;
            Resource tmpRes = registry.get("/repository/components/org.wso2.carbon.tasks/types");
            if (tmpRes == null || !(tmpRes instanceof Collection)) {
                return new ArrayList<String>();
            }
            Collection typeCollection = (Collection)tmpRes;
            for (String path : children = typeCollection.getChildren()) {
                types.add(path.substring(path.lastIndexOf(47) + 1));
            }
            return types;
        }
        catch (ResourceNotFoundException e) {
            return types;
        }
        catch (Exception e) {
            throw new TaskException("Error in getting task type for tenant: " + tid, TaskException.Code.UNKNOWN, e);
        }
    }

    private List<Integer> getAllTenantIds() throws TaskException {
        try {
            Tenant[] tenants = TasksDSComponent.getRealmService().getTenantManager().getAllTenants();
            ArrayList<Integer> tids = new ArrayList<Integer>();
            for (Tenant tenant : tenants) {
                tids.add(tenant.getId());
            }
            tids.add(-1234);
            return tids;
        }
        catch (UserStoreException e) {
            throw new TaskException("Error in listing all the tenants", TaskException.Code.CONFIG_ERROR, (Exception)((Object)e));
        }
    }

    private TaskManager createTaskManager(TaskManagerId taskManagerId, boolean isStartup) throws TaskException {
        RegistryBasedTaskRepository taskRepo = new RegistryBasedTaskRepository(taskManagerId.getTenantId(), taskManagerId.getTaskType(), this.getTaskAvailabilityManager());
        CoordinationService coordinationService = TasksDSComponent.getCoordinationService();
        AbstractQuartzTaskManager taskManager = coordinationService.isEnabled() ? new ClusteredTaskManager(taskRepo, isStartup) : new StandaloneTaskManager(taskRepo);
        if (this.getTaskAvailabilityManager().checkTasksAvailable(taskManagerId.getTenantId())) {
            taskManager.scheduleAllTasks();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Scheduling all tasks in creating a task manager for tenant: " + taskManagerId.getTenantId()));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No tasks available to schedule in creating a task manager for tenant: " + taskManagerId.getTenantId()));
        }
        return taskManager;
    }

    @Override
    public synchronized TaskManager getTaskManager(String taskType) throws TaskException {
        int tid = SuperTenantCarbonContext.getCurrentContext().getTenantId();
        TaskManagerId taskManagerId = new TaskManagerId(tid, taskType);
        if (!this.getTaskManagerMap().containsKey(taskManagerId)) {
            this.getTaskManagerMap().put(taskManagerId, this.createTaskManager(taskManagerId, false));
        }
        return this.getTaskManagerMap().get(taskManagerId);
    }

    @Override
    public void newTenantArrived(int tid) throws TaskException {
        this.initTaskManagersForTenant(tid);
    }

    @Override
    public void registerTaskType(String taskType) throws TaskException {
        this.registeredTaskTypes.add(taskType);
        this.initTaskManagers();
    }

    private class TaskManagerId {
        private int tenantId;
        private String taskType;

        public TaskManagerId(int tenantId, String taskType) {
            this.tenantId = tenantId;
            this.taskType = taskType;
        }

        public int getTenantId() {
            return this.tenantId;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public int hashCode() {
            return (this.getTaskType() + ":" + this.getTenantId()).hashCode();
        }

        public boolean equals(Object rhs) {
            return this.hashCode() == rhs.hashCode();
        }

        public String toString() {
            return this.getTaskType() + ":" + this.getTenantId();
        }
    }
}

