/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.ui;

import java.rmi.RemoteException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminDataSourceException;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminStub;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceInfo;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceMetaInfo;
import org.wso2.carbon.ui.CarbonUIUtil;

public class NDataSourceAdminServiceClient {
    private NDataSourceAdminStub stub = null;
    private static Log log = LogFactory.getLog(NDataSourceAdminServiceClient.class);

    public NDataSourceAdminServiceClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "NDataSourceAdmin";
        this.stub = new NDataSourceAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public static NDataSourceAdminServiceClient getInstance(ServletConfig config, HttpSession session) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        return new NDataSourceAdminServiceClient(cookie, backendServerURL, configContext);
    }

    public void addDataSource(WSDataSourceMetaInfo dataSourceMetaInfo) throws RemoteException, DataSourceException {
        NDataSourceAdminServiceClient.validateDataSourceMetaInformation(dataSourceMetaInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to add Datasource :" + dataSourceMetaInfo.getName()));
        }
        try {
            this.stub.addDataSource(dataSourceMetaInfo);
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
        }
    }

    public boolean testDataSourceConnection(WSDataSourceMetaInfo dataSourceMetaInfo) throws RemoteException, DataSourceException {
        NDataSourceAdminServiceClient.validateDataSourceMetaInformation(dataSourceMetaInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going test connection of Datasource :" + dataSourceMetaInfo.getName()));
        }
        try {
            return this.stub.testDataSourceConnection(dataSourceMetaInfo);
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
            return false;
        }
    }

    public void deleteDataSource(String dsName) throws RemoteException, DataSourceException {
        NDataSourceAdminServiceClient.validateName(dsName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Going to delete a Datasource with name : " + dsName));
        }
        try {
            this.stub.deleteDataSource(dsName);
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
        }
    }

    public WSDataSourceInfo[] getAllDataSources() throws RemoteException, DataSourceException {
        WSDataSourceInfo[] allDataSources = null;
        try {
            allDataSources = this.stub.getAllDataSources();
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
        }
        return allDataSources;
    }

    public WSDataSourceInfo getDataSource(String dsName) throws RemoteException, DataSourceException {
        NDataSourceAdminServiceClient.validateName(dsName);
        WSDataSourceInfo wsDataSourceInfo = null;
        try {
            wsDataSourceInfo = this.stub.getDataSource(dsName);
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
        }
        return wsDataSourceInfo;
    }

    public WSDataSourceInfo[] getAllDataSourcesForType(String dsType) throws RemoteException, DataSourceException {
        NDataSourceAdminServiceClient.validateType(dsType);
        WSDataSourceInfo[] allDataSources = null;
        try {
            allDataSources = this.stub.getAllDataSourcesForType(dsType);
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
        }
        return allDataSources;
    }

    public String[] getDataSourceTypes() throws RemoteException, DataSourceException {
        String[] dataSourceTypes = null;
        try {
            dataSourceTypes = this.stub.getDataSourceTypes();
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
        }
        return dataSourceTypes;
    }

    public boolean reloadAllDataSources() throws RemoteException, DataSourceException {
        try {
            return this.stub.reloadAllDataSources();
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
            return false;
        }
    }

    public boolean reloadDataSource(String dsName) throws RemoteException, DataSourceException {
        NDataSourceAdminServiceClient.validateName(dsName);
        try {
            return this.stub.reloadDataSource(dsName);
        }
        catch (NDataSourceAdminDataSourceException e) {
            if (e.getFaultMessage().getDataSourceException().isErrorMessageSpecified()) {
                NDataSourceAdminServiceClient.handleException(e.getFaultMessage().getDataSourceException().getErrorMessage(), e);
            }
            NDataSourceAdminServiceClient.handleException(e.getMessage(), e);
            return false;
        }
    }

    private static void validateDataSourceMetaInformation(WSDataSourceMetaInfo dataSourceMetaInfo) {
        if (dataSourceMetaInfo == null) {
            NDataSourceAdminServiceClient.handleException("WSDataSourceMetaInfo can not be found.");
        }
    }

    private static void validateName(String name) {
        if (name == null || "".equals(name)) {
            NDataSourceAdminServiceClient.handleException("Name is null or empty");
        }
    }

    private static void validateType(String type) {
        if (type == null || "".equals(type)) {
            NDataSourceAdminServiceClient.handleException("Type is null or empty");
        }
    }

    private static void handleException(String msg) {
        log.error((Object)msg);
        throw new IllegalArgumentException(msg);
    }

    private static void handleException(String msg, Exception e) throws DataSourceException {
        throw new DataSourceException(msg, e);
    }
}

