/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay.mediators.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.wso2.carbon.relay.MessageBuilder;
import org.wso2.carbon.relay.RelayConstants;
import org.wso2.carbon.relay.StreamingOnRequestDataSource;

public class BuilderMediator
extends AbstractMediator {
    private MessageBuilder messageBuilder = new MessageBuilder();
    private Builder specifiedBuilder;
    private MessageFormatter specifiedFormatter;

    public boolean mediate(org.apache.synapse.MessageContext msgCtx) {
        SynapseLog synLog = this.getLog(msgCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Build mediator : start");
        }
        SOAPEnvelope envelope = msgCtx.getEnvelope();
        MessageContext messageContext = ((Axis2MessageContext)msgCtx).getAxis2MessageContext();
        OMElement contentEle = envelope.getBody().getFirstChildWithName(RelayConstants.BINARY_CONTENT_QNAME);
        if (contentEle != null) {
            OMNode node = contentEle.getFirstOMChild();
            if (node != null && node instanceof OMText) {
                block19: {
                    OMText binaryDataNode = (OMText)node;
                    DataHandler dh = (DataHandler)binaryDataNode.getDataHandler();
                    if (dh == null) {
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.auditWarn((Object)"Message has the Binary content element. But doesn't have binary content embedded within it");
                        }
                        return true;
                    }
                    DataSource dataSource = dh.getDataSource();
                    if (dataSource instanceof StreamingOnRequestDataSource) {
                        ((StreamingOnRequestDataSource)dataSource).setLastUse(true);
                    }
                    InputStream in = null;
                    try {
                        in = dh.getInputStream();
                    }
                    catch (IOException e) {
                        this.handleException("Error retrieving InputStream from data handler", e, msgCtx);
                    }
                    String contentType = (String)messageContext.getProperty("ContentType");
                    OMElement element = null;
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("Trying to build a message with content type :" + contentType));
                    }
                    try {
                        element = this.specifiedBuilder != null ? this.specifiedBuilder.processDocument(in, contentType, messageContext) : this.messageBuilder.getDocument(contentType, messageContext, in);
                    }
                    catch (Exception e) {
                        synLog.auditWarn((Object)("Error buidling message with content type :" + contentType));
                    }
                    if (element != null) {
                        try {
                            messageContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)element));
                            if (this.specifiedFormatter != null) {
                                messageContext.setProperty("__FORCED_RELAY_FORMATTER", (Object)this.specifiedFormatter);
                                break block19;
                            }
                            messageContext.setProperty("__REALY_FORMATTERS_MAP", (Object)this.messageBuilder.getFormatters());
                        }
                        catch (AxisFault axisFault) {
                            this.handleException("Failed to set the built SOAP Envelope to the message context", (Exception)((Object)axisFault), msgCtx);
                        }
                    } else {
                        synLog.auditWarn((Object)"Error occurred while trying to build the message, trying to send the message throgh");
                    }
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)"Build mediator : end");
                }
            } else if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)"not wrapped binary content, there is nothing to be done");
            }
        }
        return true;
    }

    public Builder getSpecifiedBuilder() {
        return this.specifiedBuilder;
    }

    public void setSpecifiedBuilder(Builder specifiedBuilder) {
        this.specifiedBuilder = specifiedBuilder;
    }

    public MessageFormatter getSpecifiedFormatter() {
        return this.specifiedFormatter;
    }

    public void setSpecifiedFormatter(MessageFormatter specifiedFormatter) {
        this.specifiedFormatter = specifiedFormatter;
    }

    public void addFormatter(String contentType, MessageFormatter formatter) {
        this.messageBuilder.addFormatter(contentType, formatter);
    }

    public void addBuilder(String contentType, Builder builder) {
        this.messageBuilder.addBuilder(contentType, builder);
    }

    public Map<String, Builder> getMessageBuilders() {
        return this.messageBuilder.getBuilders();
    }

    public Map<String, MessageFormatter> getMessageFormatters() {
        return this.messageBuilder.getFormatters();
    }
}

