/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.axiom.attachments.ByteArrayDataSource;
import org.wso2.carbon.relay.BinaryRelayBuilder;

public class StreamingOnRequestDataSource
implements DataSource {
    private InputStream in;
    private boolean lastUse = false;
    private ByteArrayDataSource cachedData = null;

    public StreamingOnRequestDataSource(InputStream in) {
        this.in = in;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public InputStream getInputStream() throws IOException {
        if (this.cachedData != null) {
            return this.cachedData.getInputStream();
        }
        if (this.lastUse && this.in != null) {
            InputStream returnStram = this.in;
            this.in = null;
            return returnStram;
        }
        if (this.in != null) {
            byte[] data = BinaryRelayBuilder.readAllFromInputSteam(this.in);
            this.cachedData = new ByteArrayDataSource(data);
            return this.cachedData.getInputStream();
        }
        throw new IOException("Input stream has being already consumed");
    }

    public String getName() {
        return "StreamingOnRequestDataSource";
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void setLastUse(boolean lastUse) {
        this.lastUse = lastUse;
    }
}

