/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.ApplicationXMLBuilder;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.MIMEBuilder;
import org.apache.axis2.builder.MTOMBuilder;
import org.apache.axis2.builder.SOAPBuilder;
import org.apache.axis2.builder.XFormURLEncodedBuilder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.json.JSONBuilder;
import org.apache.axis2.json.JSONFormatter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.ApplicationXMLFormatter;
import org.apache.axis2.transport.http.MultipartFormDataFormatter;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.axis2.transport.http.XFormURLEncodedFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageBuilder {
    private static Log log = LogFactory.getLog(MessageBuilder.class);
    private Map<String, Builder> builders = new HashMap<String, Builder>();
    private Map<String, MessageFormatter> formatters = new HashMap<String, MessageFormatter>();
    public static final String RELAY_FORMATTERS_MAP = "__REALY_FORMATTERS_MAP";
    public static final String FORCED_RELAY_FORMATTER = "__FORCED_RELAY_FORMATTER";

    public MessageBuilder() {
        this.builders.put("multipart/related", (Builder)new MIMEBuilder());
        this.builders.put("application/soap+xml", (Builder)new SOAPBuilder());
        this.builders.put("text/xml", (Builder)new SOAPBuilder());
        this.builders.put("application/xop+xml", (Builder)new MTOMBuilder());
        this.builders.put("application/xml", (Builder)new ApplicationXMLBuilder());
        this.builders.put("application/x-www-form-urlencoded", (Builder)new XFormURLEncodedBuilder());
        this.builders.put("application/json", (Builder)new JSONBuilder());
        this.formatters.put("application/x-www-form-urlencoded", (MessageFormatter)new XFormURLEncodedFormatter());
        this.formatters.put("multipart/form-data", (MessageFormatter)new MultipartFormDataFormatter());
        this.formatters.put("application/xml", (MessageFormatter)new ApplicationXMLFormatter());
        this.formatters.put("text/xml", (MessageFormatter)new SOAPMessageFormatter());
        this.formatters.put("application/soap+xml", (MessageFormatter)new SOAPMessageFormatter());
        this.formatters.put("application/json", (MessageFormatter)new JSONFormatter());
    }

    public Map<String, Builder> getBuilders() {
        return this.builders;
    }

    public void addBuilder(String contentType, Builder builder) {
        this.builders.put(contentType, builder);
    }

    public void addFormatter(String contentType, MessageFormatter messageFormatter) {
        this.formatters.put(contentType, messageFormatter);
    }

    public Map<String, MessageFormatter> getFormatters() {
        return this.formatters;
    }

    public OMElement getDocument(String contentType, MessageContext msgCtx, InputStream in) throws XMLStreamException, AxisFault {
        Builder builder;
        OMElement element = null;
        if (contentType != null && (builder = this.getBuilderForContentType(contentType)) != null) {
            try {
                element = builder.processDocument(in, contentType, msgCtx);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error building message", (Throwable)axisFault);
                throw axisFault;
            }
        }
        if (element == null) {
            if (msgCtx.isDoingREST()) {
                try {
                    element = BuilderUtil.getPOXBuilder((InputStream)in, null).getDocumentElement();
                }
                catch (XMLStreamException e) {
                    log.error((Object)"Errpr building message using POX Builder", (Throwable)e);
                    throw e;
                }
            }
            builder = new SOAPBuilder();
            try {
                element = builder.processDocument(in, contentType, msgCtx);
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Error building message using SOAP builder");
                throw axisFault;
            }
        }
        if (element instanceof SOAPEnvelope) {
            SOAPEnvelope env = (SOAPEnvelope)element;
            env.hasFault();
        }
        return element;
    }

    private Builder getBuilderForContentType(String contentType) {
        int index = contentType.indexOf(59);
        String type = index > 0 ? contentType.substring(0, index) : contentType;
        Builder builder = this.builders.get(type);
        if (builder == null) {
            builder = this.builders.get(type.toLowerCase());
        }
        if (builder == null) {
            Iterator<Map.Entry<String, Builder>> iterator = this.builders.entrySet().iterator();
            while (iterator.hasNext() && builder == null) {
                Map.Entry<String, Builder> entry = iterator.next();
                String key = entry.getKey();
                if (!contentType.matches(key)) continue;
                builder = entry.getValue();
            }
        }
        return builder;
    }

    public static Builder createBuilder(String className) throws AxisFault {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            if (o instanceof Builder) {
                return (Builder)o;
            }
        }
        catch (ClassNotFoundException e) {
            MessageBuilder.handleException("Builder class not found :" + className, e);
        }
        catch (IllegalAccessException e) {
            MessageBuilder.handleException("Cannot initiate Builder class :" + className, e);
        }
        catch (InstantiationException e) {
            MessageBuilder.handleException("Cannot initiate Builder class :" + className, e);
        }
        return null;
    }

    public static MessageFormatter createFormatter(String className) throws AxisFault {
        try {
            Class<?> c = Class.forName(className);
            Object o = c.newInstance();
            if (o instanceof MessageFormatter) {
                return (MessageFormatter)o;
            }
        }
        catch (ClassNotFoundException e) {
            MessageBuilder.handleException("MessageFormatter class not found :" + className, e);
        }
        catch (IllegalAccessException e) {
            MessageBuilder.handleException("Cannot initiate MessageFormatter class :" + className, e);
        }
        catch (InstantiationException e) {
            MessageBuilder.handleException("Cannot initiate MessageFormatter class :" + className, e);
        }
        return null;
    }

    private static void handleException(String message, Exception e) throws AxisFault {
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }
}

