/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.SOAPMessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.relay.RelayConstants;
import org.wso2.carbon.relay.StreamingOnRequestDataSource;

public class ExpandingMessageFormatter
extends SOAPMessageFormatter {
    private Log log = LogFactory.getLog(ExpandingMessageFormatter.class);
    private static final String MESSAGE_AS_BYTES = "MESSAGE_AS_BYTES";

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        SOAPEnvelope envelope = messageContext.getEnvelope();
        if (this.hasASoapMessageEmbeded(envelope)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.findAndWrite2OutputStream(messageContext, out, false);
            return out.toByteArray();
        }
        return super.getBytes(messageContext, format);
    }

    public String getContentType(MessageContext msgCtxt, OMOutputFormat format, String soapActionString) {
        String contentType = (String)msgCtxt.getProperty("ContentType");
        if (contentType == null) {
            MessageFormatter formatter = ExpandingMessageFormatter.getMessageFormatter(msgCtxt);
            if (formatter != null) {
                contentType = formatter.getContentType(msgCtxt, format, soapActionString);
            } else {
                String messageType = ExpandingMessageFormatter.getMessageFormatterProperty(msgCtxt);
                if (messageType.equals("application/x-www-form-urlencoded")) {
                    contentType = messageType;
                    String encoding = format.getCharSetEncoding();
                    if (encoding != null) {
                        contentType = contentType + "; charset=" + encoding;
                    }
                } else {
                    contentType = super.getContentType(msgCtxt, format, soapActionString);
                }
            }
        }
        return contentType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        try {
            byte[] messageAsBytes = (byte[])messageContext.getOperationContext().getProperty(MESSAGE_AS_BYTES);
            if (messageAsBytes != null) {
                outputStream.write(messageAsBytes);
                return;
            }
            SOAPEnvelope envelope = messageContext.getEnvelope();
            if (this.hasASoapMessageEmbeded(envelope)) {
                this.findAndWrite2OutputStream(messageContext, outputStream, preserve);
                return;
            }
            Object forcedFormatter = messageContext.getProperty("__FORCED_RELAY_FORMATTER");
            if (forcedFormatter != null) {
                if (forcedFormatter instanceof MessageFormatter) {
                    ((MessageFormatter)forcedFormatter).writeTo(messageContext, format, outputStream, preserve);
                    return;
                }
                String msg = "Invalid formatter is forced by __FORCED_RELAY_FORMATTER property.";
                this.log.error((Object)msg);
                throw new AxisFault(msg);
            }
            if (messageContext.isDoingREST()) {
                this.writeAsREST(messageContext, format, outputStream, preserve);
                return;
            }
            MessageFormatter formatter = ExpandingMessageFormatter.getMessageFormatter(messageContext);
            if (formatter != null) {
                formatter.writeTo(messageContext, format, outputStream, preserve);
                return;
            }
            super.writeTo(messageContext, format, outputStream, preserve);
            return;
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        if (!msgCtxt.isDoingREST()) {
            return super.getTargetAddress(msgCtxt, format, targetURL);
        }
        return targetURL;
    }

    public void writeAsREST(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement element = messageContext.getEnvelope().getBody().getFirstElement();
        try {
            if (element != null) {
                if (preserve) {
                    element.serialize(outputStream, format);
                } else {
                    element.serializeAndConsume(outputStream, format);
                }
            }
            outputStream.flush();
        }
        catch (XMLStreamException e) {
            String msg = "Error writing Rest message";
            this.log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        catch (IOException e) {
            String msg = "Error writing text message to stream";
            this.log.error((Object)msg);
            throw new AxisFault(msg, (Throwable)e);
        }
    }

    private boolean hasASoapMessageEmbeded(SOAPEnvelope envelope) {
        OMElement contentEle = envelope.getBody().getFirstElement();
        return contentEle != null && contentEle.getQName().equals(RelayConstants.BINARY_CONTENT_QNAME);
    }

    private void findAndWrite2OutputStream(MessageContext messageContext, OutputStream out, boolean preserve) throws AxisFault {
        try {
            SOAPEnvelope envelope = messageContext.getEnvelope();
            OMElement contentEle = envelope.getBody().getFirstElement();
            if (contentEle != null) {
                OMNode node = contentEle.getFirstOMChild();
                if (!(node instanceof OMText)) {
                    String msg = "Wrong Input for the Validator, the content of the first child element of the Body should have the zip file";
                    this.log.error((Object)msg);
                    throw new AxisFault(msg);
                }
                OMText binaryDataNode = (OMText)node;
                DataHandler dh = (DataHandler)binaryDataNode.getDataHandler();
                DataSource dataSource = dh.getDataSource();
                if (!preserve && dataSource instanceof StreamingOnRequestDataSource) {
                    ((StreamingOnRequestDataSource)dataSource).setLastUse(true);
                }
                dh.writeTo(out);
            }
        }
        catch (OMException e) {
            this.log.error((Object)e);
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            this.log.error((Object)e);
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private static String getMessageFormatterProperty(MessageContext msgContext) {
        Parameter parameter;
        String messageFormatterProperty = null;
        Object property = msgContext.getProperty("messageType");
        if (property != null) {
            messageFormatterProperty = (String)property;
        }
        if (messageFormatterProperty == null && (parameter = msgContext.getParameter("messageType")) != null) {
            messageFormatterProperty = (String)parameter.getValue();
        }
        return messageFormatterProperty;
    }

    private static MessageFormatter getMessageFormatter(MessageContext messageContext) {
        Object o = messageContext.getProperty("__REALY_FORMATTERS_MAP");
        if (o != null && o instanceof Map) {
            Map map = (Map)o;
            String messageFormatString = ExpandingMessageFormatter.getMessageFormatterProperty(messageContext);
            if (messageFormatString != null) {
                return (MessageFormatter)map.get(messageFormatString);
            }
        }
        return null;
    }
}

