/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.multiple.instance.endpoint.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.multiple.instance.endpoint.mgt.EndPointManager;
import org.wso2.carbon.utils.CarbonUtils;

public class EndPointManagerServiceComponent {
    private static Log log = LogFactory.getLog(EndPointManagerServiceComponent.class);
    private static SynapseConfigurationService scService;
    private static SynapseEnvironmentService synEnvService;

    protected void activate(ComponentContext ctxt) {
        if (!CarbonUtils.isChildNode()) {
            EndPointManager endPointManager = new EndPointManager();
            try {
                endPointManager.start();
            }
            catch (Exception e) {
                log.error((Object)"Error Occure while running Multiple Instance Port updator", (Throwable)e);
            }
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deactivated SynapseAppServiceComponent");
        }
    }

    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        scService = synapseConfigurationService;
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        scService = null;
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synEnvironmentService) {
        synEnvService = synEnvironmentService;
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synEnvironmentService) {
        synEnvService = null;
    }

    public static SynapseConfigurationService getScService() throws Exception {
        return scService;
    }

    public static SynapseEnvironmentService getSynapseEnvService() throws Exception {
        return synEnvService;
    }
}

