/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.multiple.instance.endpoint.mgt.autoscale;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.multiple.instance.endpoint.mgt.PortSelector;
import org.wso2.carbon.multiple.instance.endpoint.mgt.autoscale.LocalInstance;
import org.wso2.carbon.multiple.instance.endpoint.mgt.autoscale.StreamHandler;

public class LocalInstanceManager {
    private static final Log log = LogFactory.getLog(LocalInstanceManager.class);
    private static final String IMPL_PREFIX = "impl.prefix";
    private static final String JAVA_ENDORSED_DIR = "java.endorsed.dirs";
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String WSO2_SERVER_STANDALONE = "wso2.server.standalone";
    private static final String JAVA_COMMAND = "java.command";
    private static final String JAVA_OPTS = "java.opts";
    private static final String CARBON_XBOOTCLASSPATH = "carbon.xbootclasspath";
    private static final String CARBON_REGISTRY_ROOT = "carbon.registry.root";
    private static final String CARBON_CLASSPATH = "carbon.classpath";
    private static final String CARBON_HOME = "carbon.home";
    private static final String WSO2_CARBON_XML = "wso2.carbon.xml";
    private static final String WSO2_TRANSPORTS_XML = "wso2.transports.xml";
    private static final String JAVA_UTILS_LOGGING_CONFIG_FILE = "java.util.logging.config.file";
    private static final String CARBON_CONFIG_DIR_PATH = "carbon.config.dir.path";
    private static final String CARBON_LOGS_PATH = "carbon.logs.path";
    private static final String AXIS2_REPO = "axis2.repo";
    private static final String COMPONENTS_REPO = "components.repo";
    private static final String LAUNCHER_CLASS = "org.wso2.carbon.server.Main";
    private static final String WSO2_REGISTRY_XML = "wso2.registry.xml";
    private static final String WSO2_USER_MGT_XML = "wso2.user.mgt.xml";
    private static final String INSTANCE = "instance";
    private static final String INSTANCE_LOG_FILE = "instance.log";
    private static final String LOGS_PATH = "carbon.logs.path";
    public static String MASTER_NODE_INSTANCE_ID = null;
    private static Map<String, LocalInstance> instances;
    private static int startedInstanceNumber;
    Runtime runtime = Runtime.getRuntime();
    Process MasterNode = null;

    public List start() throws Exception {
        PortSelector.init();
        LocalInstance instance = new LocalInstance();
        Process process = null;
        if (this.TestMasterNode()) {
            process = this.runtime.exec(LocalInstanceManager.createCommand("false"));
        } else {
            this.MasterNode = process = this.runtime.exec(LocalInstanceManager.createCommand("true"));
        }
        StreamHandler s1 = new StreamHandler("stdin", process.getInputStream());
        StreamHandler s2 = new StreamHandler("stderr", process.getErrorStream());
        s1.start();
        s2.start();
        instance.setJavaprocess(process);
        instances.put(UUID.randomUUID().toString(), instance);
        return null;
    }

    private boolean TestMasterNode() {
        if (this.MasterNode == null) {
            return false;
        }
        try {
            int ExitValue = this.MasterNode.exitValue();
            return ExitValue == 1;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public List terminate(String[] instanceIds) throws Exception {
        for (String instanceId : instanceIds) {
            Process process = instances.get(instanceId).getJavaprocess();
            process.destroy();
            instances.remove(instanceId);
        }
        return null;
    }

    public List describeInstances() throws Exception {
        String[] keyarray;
        ArrayList<LocalInstance> instancelist = new ArrayList<LocalInstance>();
        Set<String> keys = instances.keySet();
        for (String key : keyarray = (String[])keys.toArray()) {
            instancelist.add(instances.get(key));
        }
        return instancelist;
    }

    public static String createCommand(String isMaster) {
        StringBuffer command = new StringBuffer("");
        command.append(LocalInstanceManager.getProperty(JAVA_COMMAND));
        command.append("-Xbootclasspath/a:");
        command.append(System.getProperty(CARBON_XBOOTCLASSPATH));
        command.append(" -Xms256m -Xmx512m -XX:MaxPermSize=128m ");
        command.append(LocalInstanceManager.getProperty(JAVA_OPTS));
        command.append(LocalInstanceManager.createSystemPropertyParam(IMPL_PREFIX));
        command.append("-Dcom.sun.management.jmxremote ");
        command.append("-classpath" + LocalInstanceManager.getProperty(CARBON_CLASSPATH));
        command.append(LocalInstanceManager.createSystemPropertyParam(JAVA_ENDORSED_DIR));
        command.append(LocalInstanceManager.createSystemPropertyParam(JAVA_IO_TMPDIR));
        command.append(LocalInstanceManager.createSystemPropertyParam(WSO2_SERVER_STANDALONE));
        command.append(LocalInstanceManager.createSystemPropertyParam(JAVA_COMMAND));
        command.append(LocalInstanceManager.createSystemPropertyParam(JAVA_OPTS));
        command.append(LocalInstanceManager.createSystemPropertyParam(CARBON_XBOOTCLASSPATH));
        command.append(LocalInstanceManager.createSystemPropertyParam(CARBON_REGISTRY_ROOT));
        command.append(LocalInstanceManager.createSystemPropertyParam(CARBON_CLASSPATH));
        command.append(LocalInstanceManager.createSystemPropertyParam(CARBON_HOME));
        command.append(LocalInstanceManager.createSystemPropertyParam(WSO2_CARBON_XML));
        command.append(LocalInstanceManager.createSystemPropertyParam(WSO2_REGISTRY_XML));
        command.append(LocalInstanceManager.createSystemPropertyParam(WSO2_USER_MGT_XML));
        command.append(LocalInstanceManager.createSystemPropertyParam(WSO2_TRANSPORTS_XML));
        command.append(LocalInstanceManager.createSystemPropertyParam(JAVA_UTILS_LOGGING_CONFIG_FILE));
        command.append(LocalInstanceManager.createSystemPropertyParam(CARBON_CONFIG_DIR_PATH));
        command.append(LocalInstanceManager.createSystemPropertyParam("carbon.logs.path"));
        command.append(LocalInstanceManager.createSystemPropertyParam(AXIS2_REPO));
        command.append(LocalInstanceManager.createSystemPropertyParam(COMPONENTS_REPO));
        command.append(LocalInstanceManager.createSystemPropertyParam("carbon.logs.path"));
        command.append(LocalInstanceManager.createSystemPropertyParam("master", isMaster));
        command.append(LocalInstanceManager.createSystemPropertyParam(INSTANCE, "true"));
        String instanceLog = LocalInstanceManager.getInstancelogFileName();
        command.append(LocalInstanceManager.createSystemPropertyParam(INSTANCE_LOG_FILE, instanceLog));
        String instanceId = UUID.randomUUID().toString();
        if ("true".equals(isMaster)) {
            MASTER_NODE_INSTANCE_ID = instanceId = instanceId + "-master";
        }
        command.append(LocalInstanceManager.createSystemPropertyParam("instance.ID", instanceId));
        command.append(PortSelector.genaratePort(instanceId, instanceLog));
        command.append(LAUNCHER_CLASS);
        return command.toString();
    }

    private static String getProperty(String key) {
        if (System.getProperty(key) != null) {
            return " " + System.getProperty(key) + " ";
        }
        return "";
    }

    private static String createSystemPropertyParam(String key) {
        if (System.getProperty(key) != null) {
            return " -D" + key + "=" + System.getProperty(key) + " ";
        }
        return "";
    }

    private static String createSystemPropertyParam(String name, String value) {
        return " -D" + name + "=" + value + " ";
    }

    public Map<String, LocalInstance> getInstances() {
        return instances;
    }

    public void setInstances(Map<String, LocalInstance> instances) {
        LocalInstanceManager.instances = instances;
    }

    private static String getInstancelogFileName() {
        return "Instance" + Integer.toString(++startedInstanceNumber);
    }

    static {
        startedInstanceNumber = 0;
    }
}

