/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.multiple.instance.endpoint.mgt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.utils.CarbonUtils;

public class PortSelector {
    private static final String INSTANCE_LOG_FILE = "instance.log";
    private static final String PORTS_GIVEN = "ports.given";
    private static final String[] transports = new String[]{"http", "https"};
    private static final String[] transportTypes = new String[]{"nioports", "mgtports"};
    public static List<String> normalEndpointList = new ArrayList<String>();
    public static List<String> nioEndpointList = new ArrayList<String>();
    private static int start = 49152;
    private static int end = 65353;
    private static int range = 16383;
    private static final Log log = LogFactory.getLog(PortSelector.class);

    public static void init() {
        PortSelector.setPortRange();
    }

    public static int getPortFromConfig(String transport, String transportType, String instanceLog) {
        try {
            String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "ports-config.xml";
            File file = new File(path);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            NodeList instancePortConfig = doc.getElementsByTagName(instanceLog);
            Element inner = (Element)instancePortConfig.item(0);
            NodeList innerList = inner.getElementsByTagName(transportType);
            Element finalElement = (Element)innerList.item(0);
            NodeList port = finalElement.getElementsByTagName(transport);
            return Integer.parseInt(port.item(0).getTextContent());
        }
        catch (Exception e) {
            log.error((Object)"Error Parsing ports-config.xml", (Throwable)e);
            return 0;
        }
    }

    public static void setPortRange() {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "ports-config.xml";
        File file = new File(path);
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            NodeList rangeNode = doc.getElementsByTagName("range");
            Element rangeElement = (Element)rangeNode.item(0);
            NodeList startNode = rangeElement.getElementsByTagName("start");
            NodeList endNode = rangeElement.getElementsByTagName("end");
            start = Integer.parseInt(startNode.item(0).getTextContent());
            end = Integer.parseInt(endNode.item(0).getTextContent());
            range = end - start;
        }
        catch (Exception e) {
            log.warn((Object)("Error reading ports range from ports-config.xml, Default port range will be: " + start + " - " + end));
        }
    }

    public static int getPortNumber() {
        Random candidateInt = new Random();
        int candidatePort = candidateInt.nextInt(start) + range;
        if (candidatePort < start || candidatePort > end) {
            while ((candidatePort = candidateInt.nextInt(start) + range) < start || candidatePort > end || PortSelector.isPortSelected(candidatePort)) {
            }
            return candidatePort;
        }
        return candidatePort;
    }

    public static String genaratePort(String instanceId, String instanceLog) {
        int port = 0;
        StringBuffer portSystemProperties = new StringBuffer();
        for (String transport : transports) {
            for (String transportType : transportTypes) {
                port = "set".equals(System.getProperty(PORTS_GIVEN)) ? PortSelector.getPortFromConfig(transport, transportType, instanceLog) : PortSelector.getPortNumber();
                if ("nioports".equals(transportType)) {
                    portSystemProperties.append(PortSelector.createSystemPropertyParam("nio" + transport + "Port", Integer.toString(port)));
                    nioEndpointList.add(Integer.toString(port) + " " + transport + " " + instanceId);
                    continue;
                }
                portSystemProperties.append(PortSelector.createSystemPropertyParam(transport + "Port", Integer.toString(port)));
                normalEndpointList.add(Integer.toString(port) + " " + transport + " " + instanceId);
            }
        }
        return portSystemProperties.toString();
    }

    public static boolean isPortSelected(int port) {
        String[] normalList = normalEndpointList.toArray(new String[normalEndpointList.size()]);
        String[] nioList = nioEndpointList.toArray(new String[nioEndpointList.size()]);
        for (String endpoint : normalList) {
            if (!Integer.toString(port).equals(endpoint.split(" ")[0])) continue;
            return true;
        }
        for (String endpoint : nioList) {
            if (!Integer.toString(port).equals(endpoint.split(" ")[0])) continue;
            return true;
        }
        return false;
    }

    private static String createSystemPropertyParam(String name, String value) {
        return " -D" + name + "=" + value + " ";
    }
}

