/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay.module.handler;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.relay.RelayConstants;
import org.wso2.carbon.relay.StreamingOnRequestDataSource;
import org.wso2.carbon.relay.module.RelayConfiguration;

public class SkipAdminServiceHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(TransportUtils.class);
    public static final String ADMIN_SERVICE_PARAM_NAME = "adminService";
    public static final String HIDDEN_SERVICE_PARAM_NAME = "hiddenService";

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            RelayConfiguration relConf;
            Parameter relayParam = msgContext.getParameter("__relay_configuration__");
            if (relayParam == null) {
                this.handleException("Relay not initialized");
            }
            if ((relConf = (RelayConfiguration)relayParam.getValue()) == null) {
                this.handleException("Relay not initialized");
            }
            if (this.isFilteredOutService(msgContext.getAxisService(), relConf)) {
                SOAPEnvelope envelope = msgContext.getEnvelope();
                OMElement contentEle = envelope.getBody().getFirstChildWithName(RelayConstants.BINARY_CONTENT_QNAME);
                if (contentEle != null) {
                    OMNode node = contentEle.getFirstOMChild();
                    if (node != null && node instanceof OMText) {
                        OMText binaryDataNode = (OMText)node;
                        DataHandler dh = (DataHandler)binaryDataNode.getDataHandler();
                        if (dh == null) {
                            if (log.isDebugEnabled()) {
                                log.warn((Object)"Message has the Binary content element. But doesn't have binary content embedded within it");
                            }
                            return Handler.InvocationResponse.CONTINUE;
                        }
                        DataSource dataSource = dh.getDataSource();
                        if (dataSource instanceof StreamingOnRequestDataSource) {
                            ((StreamingOnRequestDataSource)dataSource).setLastUse(true);
                        }
                        InputStream in = dh.getInputStream();
                        String contentType = (String)msgContext.getProperty("ContentType");
                        OMElement element = relConf.getMessageBuilder().getDocument(contentType, msgContext, in);
                        if (element != null) {
                            msgContext.setEnvelope(TransportUtils.createSOAPEnvelope((OMElement)element));
                            msgContext.setProperty("__REALY_FORMATTERS_MAP", (Object)relConf.getMessageBuilder().getFormatters());
                        } else {
                            log.warn((Object)"Error building the message, skipping message building");
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Undo wrapping done by Relay");
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"not wrapped binary content, there is nothing to be done");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)"Body of the Soap Envelope is empty, nothing to unwrap");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Not a admin service, nothing to be done");
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (OMException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public void init(HandlerDescription handlerdesc) {
    }

    public boolean isFilteredOutService(AxisService service, RelayConfiguration relConf) {
        String hiddenParamValue;
        if (relConf.getServices().contains(service.getName())) {
            return true;
        }
        AxisServiceGroup axisServiceGroup = (AxisServiceGroup)service.getParent();
        String adminParamValue = (String)axisServiceGroup.getParameterValue(ADMIN_SERVICE_PARAM_NAME);
        if (adminParamValue == null) {
            adminParamValue = (String)service.getParameterValue(ADMIN_SERVICE_PARAM_NAME);
        }
        if ((hiddenParamValue = (String)axisServiceGroup.getParameterValue(HIDDEN_SERVICE_PARAM_NAME)) == null) {
            hiddenParamValue = (String)service.getParameterValue(HIDDEN_SERVICE_PARAM_NAME);
        }
        if (Boolean.parseBoolean(adminParamValue)) {
            return true;
        }
        return relConf.isIncludeHiddenServices() && Boolean.parseBoolean(hiddenParamValue);
    }

    private void handleException(String msg) throws AxisFault {
        log.error((Object)msg);
        throw new AxisFault(msg);
    }
}

