/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay.module;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.modules.Module;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.wso2.caching.CachingException;
import org.wso2.carbon.relay.module.RelayConfiguration;
import org.wso2.carbon.relay.module.policy.PolicyProcessor;

public class RelayModule
implements Module {
    private Log log = LogFactory.getLog(RelayModule.class);

    public void init(ConfigurationContext configurationContext, AxisModule axisModule) throws AxisFault {
        PolicySubject policy = axisModule.getPolicySubject();
        RelayConfiguration configuration = null;
        if (policy != null) {
            try {
                configuration = PolicyProcessor.processCachingPolicy(policy);
            }
            catch (CachingException e) {
                this.handleException("Unable to initialize the caching module : Error in processing caching policy", e);
            }
        }
        if (configuration == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Using the default initializer for the CacheConfiguration");
            }
            configuration = new RelayConfiguration();
        }
        configuration.init();
        configurationContext.getAxisConfiguration().addParameter("__relay_configuration__", (Object)configuration);
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return false;
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
    }

    private void handleException(String message, Throwable cause) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)message, cause);
        }
        throw new AxisFault(message, cause);
    }
}

