/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.transport.MessageFormatter;
import org.wso2.carbon.relay.MessageBuilder;

public class RelayConfiguration {
    private List<String> services = new ArrayList<String>();
    private Map<String, String> builders = new HashMap<String, String>();
    private Map<String, String> formatters = new HashMap<String, String>();
    private boolean includeHiddenServices = true;
    private MessageBuilder messageBuilder = new MessageBuilder();

    public List<String> getServices() {
        return this.services;
    }

    public boolean isIncludeHiddenServices() {
        return this.includeHiddenServices;
    }

    public void setIncludeHiddenServices(boolean includeHiddenServices) {
        this.includeHiddenServices = includeHiddenServices;
    }

    public void addService(String service) {
        this.services.add(service);
    }

    public Map<String, String> getBuilders() {
        return this.builders;
    }

    public void addBuilder(String contentType, String className) {
        this.builders.put(contentType, className);
    }

    public void addFormatter(String contentType, String className) {
        this.formatters.put(contentType, className);
    }

    public Map<String, String> getFormatters() {
        return this.formatters;
    }

    public MessageBuilder getMessageBuilder() {
        return this.messageBuilder;
    }

    public void setMessageBuilder(MessageBuilder messageBuilder) {
        this.messageBuilder = messageBuilder;
    }

    public void init() throws AxisFault {
        for (String key : this.builders.keySet()) {
            Builder builder = MessageBuilder.createBuilder((String)this.builders.get(key));
            this.messageBuilder.addBuilder(key, builder);
            if (!this.formatters.containsKey(key)) continue;
            MessageFormatter formatter = MessageBuilder.createFormatter((String)this.formatters.get(key));
            this.messageBuilder.addFormatter(key, formatter);
        }
    }
}

