/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.multiple.instance.endpoint.mgt.autoscale;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.startup.Task;
import org.wso2.carbon.multiple.instance.endpoint.mgt.autoscale.LocalInstance;
import org.wso2.carbon.multiple.instance.endpoint.mgt.autoscale.LocalInstanceManager;
import org.wso2.carbon.utils.CarbonUtils;

public class LocalLoadAnalyzerTask
implements Task,
ManagedLifecycle {
    private static final Log log = LogFactory.getLog(LocalInstanceManager.class);
    private static LocalInstanceManager imanager;
    private static boolean initialized;
    private String pLoadBalancerGroup = "default";
    private String pAvailabilityZone = "us-east-1b";
    private long pMessageExpiryTime = -1L;
    private int pMinLoadBalancerInstances = 2;
    private int pMinAppInstances = 0;
    private int pMaxAppInstances = 1;
    private int pQueueLengthPerNode = 10;
    private int pRoundsToAverage = 10;
    private int pInstancesPerScaleUp = 1;
    Map runInstanceData = new HashMap();

    public boolean doSanityCheck() {
        int currentLoadBalancerInstances = this.getRunningInstances();
        if (currentLoadBalancerInstances < this.getPMinAppInstances()) {
            log.warn((Object)("Sanity check failed. Min Application Instances is: " + currentLoadBalancerInstances + ". Specified Min Application Instances is: " + this.getPMinAppInstances()));
            int diff = this.getPMinAppInstances() - currentLoadBalancerInstances;
            log.info((Object)("Launching " + diff + " Application instances"));
            try {
                for (int i = 0; i < diff; ++i) {
                    imanager.start();
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to start the required number of instances", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public void execute() {
        if (CarbonUtils.isMultipleInstanceCase()) {
            this.doSanityCheck();
        }
    }

    private synchronized int getRunningInstances() {
        Map<String, LocalInstance> instanceList = imanager.getInstances();
        Iterator<String> it = instanceList.keySet().iterator();
        int noOfProcesses = 0;
        while (it.hasNext()) {
            String key = it.next();
            Process process = instanceList.get(key).getJavaprocess();
            try {
                int exit = process.exitValue();
                if (exit != 1) {
                    log.info((Object)("1 Instance has been killed due to some reason and another Instance will start soon. Exit Value :" + exit));
                    it.remove();
                    continue;
                }
                ++noOfProcesses;
            }
            catch (IllegalThreadStateException e) {
                ++noOfProcesses;
            }
        }
        return noOfProcesses;
    }

    public List<LocalInstance> getRunningApplicationInstances() throws Exception {
        this.getRunningInstances();
        return new ArrayList<LocalInstance>(imanager.getInstances().values());
    }

    public List<LocalInstance> getPendingApplicationInstances() throws Exception {
        return new ArrayList<LocalInstance>();
    }

    public void init(SynapseEnvironment synEnv) {
        if (CarbonUtils.isMultipleInstanceCase()) {
            log.debug((Object)"Initializing LocalLoadAnalyzer Task ...");
            this.setMinAppInstances(System.getProperty("instances.value"));
            if (!initialized) {
                imanager = new LocalInstanceManager();
                imanager.setInstances(new HashMap<String, LocalInstance>());
                initialized = true;
            }
        }
    }

    public void destroy() {
        if (CarbonUtils.isMultipleInstanceCase()) {
            // empty if block
        }
    }

    public int getPMinAppInstances() {
        return this.pMinAppInstances;
    }

    public static LocalInstanceManager getImanager() {
        return imanager;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public String getPLoadBalancerGroup() {
        return this.pLoadBalancerGroup;
    }

    public String getPAvailabilityZone() {
        return this.pAvailabilityZone;
    }

    public long getPMessageExpiryTime() {
        return this.pMessageExpiryTime;
    }

    public int getPMinLoadBalancerInstances() {
        return this.pMinLoadBalancerInstances;
    }

    public int getPMaxAppInstances() {
        return this.pMaxAppInstances;
    }

    public int getPQueueLengthPerNode() {
        return this.pQueueLengthPerNode;
    }

    public int getPRoundsToAverage() {
        return this.pRoundsToAverage;
    }

    public int getPInstancesPerScaleUp() {
        return this.pInstancesPerScaleUp;
    }

    public Map getRunInstanceData() {
        return this.runInstanceData;
    }

    public static void setImanager(LocalInstanceManager imanager) {
        LocalLoadAnalyzerTask.imanager = imanager;
    }

    public static void setInitialized(boolean initialized) {
        LocalLoadAnalyzerTask.initialized = initialized;
    }

    public void setPLoadBalancerGroup(String pLoadBalancerGroup) {
        this.pLoadBalancerGroup = pLoadBalancerGroup;
    }

    public void setPAvailabilityZone(String pAvailabilityZone) {
        this.pAvailabilityZone = pAvailabilityZone;
    }

    public void setPMessageExpiryTime(long pMessageExpiryTime) {
        this.pMessageExpiryTime = pMessageExpiryTime;
    }

    public void setPMinLoadBalancerInstances(int pMinLoadBalancerInstances) {
        this.pMinLoadBalancerInstances = pMinLoadBalancerInstances;
    }

    public void setPMinAppInstances(int pMinAppInstances) {
        this.pMinAppInstances = pMinAppInstances;
    }

    public void setPMaxAppInstances(int pMaxAppInstances) {
        this.pMaxAppInstances = pMaxAppInstances;
    }

    public void setPQueueLengthPerNode(int pQueueLengthPerNode) {
        this.pQueueLengthPerNode = pQueueLengthPerNode;
    }

    public void setPRoundsToAverage(int pRoundsToAverage) {
        this.pRoundsToAverage = pRoundsToAverage;
    }

    public void setPInstancesPerScaleUp(int pInstancesPerScaleUp) {
        this.pInstancesPerScaleUp = pInstancesPerScaleUp;
    }

    public void setRunInstanceData(Map runInstanceData) {
        this.runInstanceData = runInstanceData;
    }

    public void setMinLoadBalancerInstances(String minInstances) {
        int iMinInstances = Integer.parseInt(minInstances);
        if (iMinInstances < 1) {
            this.handleException("minLoadBalancerInstances in the LoadAnalyzerTask configuration should be at least 1");
        }
        this.pMinLoadBalancerInstances = iMinInstances;
    }

    public void setMinAppInstances(String minInstances) {
        int iMinInstances = Integer.parseInt(minInstances);
        if (iMinInstances < 1) {
            this.handleException("minAppInstances in the LoadAnalyzerTask configuration should be at least 1");
        }
        this.pMinAppInstances = iMinInstances;
    }

    public void setMaxAppInstances(String maxInstances) {
        int iMaxInstances = Integer.parseInt(maxInstances);
        if (iMaxInstances < 1) {
            this.handleException("maxAppInstances in the LoadAnalyzerTask configuration should be at least 1");
        }
        this.pMaxAppInstances = iMaxInstances;
    }

    public void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    static {
        initialized = false;
    }
}

