/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.multiple.instance.endpoint.mgt;

import java.net.BindException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.axis2.clustering.Member;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.AnonymousListMediator;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.LoadbalanceEndpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.algorithms.RoundRobin;
import org.apache.synapse.mediators.ListMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.builtin.DropMediator;
import org.apache.synapse.mediators.builtin.LogMediator;
import org.apache.synapse.mediators.builtin.PropertyMediator;
import org.apache.synapse.mediators.builtin.SendMediator;
import org.apache.synapse.mediators.filters.FilterMediator;
import org.apache.synapse.mediators.filters.InMediator;
import org.apache.synapse.mediators.filters.OutMediator;
import org.apache.synapse.mediators.transform.HeaderMediator;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.multiple.instance.endpoint.mgt.PortSelector;
import org.wso2.carbon.multiple.instance.endpoint.mgt.internal.EndPointManagerServiceComponent;
import org.wso2.carbon.utils.NetworkUtils;

public class EndPointManager
extends Thread {
    private static Log log = LogFactory.getLog(EndPointManager.class);
    private static final String NIO_PORTS = "nioportlist.txt";
    private static final String NORMAL_PORTS = "normalportlist.txt";
    private static List<String> addedEndPointNameList = new ArrayList<String>();
    private static Map<String, Member> addedEndpointList = new HashMap<String, Member>();

    @Override
    public void run() {
        this.updateEndpoints();
    }

    public void updateEndpoints() {
        try {
            while (true) {
                this.setStartedEndpoints(PortSelector.nioEndpointList);
                Thread.sleep(5000L);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error Updating Endpoints in to SynapseConfiguration", (Throwable)e);
            return;
        }
    }

    private void setStartedEndpoints(List<String> portList) throws Exception {
        SynapseConfigurationService synCfgService = EndPointManagerServiceComponent.getScService();
        String hostName = NetworkUtils.getLocalHostname();
        if (synCfgService != null) {
            SynapseConfiguration synCfg = synCfgService.getSynapseConfiguration();
            Iterator<String> it = portList.iterator();
            ArrayList<Member> childEndpoints = new ArrayList<Member>();
            while (it.hasNext()) {
                String nextLine = it.next();
                if (addedEndPointNameList.contains(nextLine)) continue;
                String[] portData = nextLine.split(" ");
                try {
                    ServerSocket testSocket = new ServerSocket(Integer.parseInt(portData[0]));
                    testSocket.close();
                }
                catch (BindException e) {
                    StringBuffer url = new StringBuffer();
                    url.append(portData[1]);
                    url.append("://" + hostName + ":");
                    url.append(portData[0] + "/");
                    Member member = null;
                    member = addedEndpointList.get(portData[2]);
                    if (member == null) {
                        member = new Member(hostName, -1);
                        addedEndpointList.put(portData[2], member);
                    }
                    if ("http".equals(portData[1])) {
                        member.setHttpPort(Integer.parseInt(portData[0]));
                    } else if ("https".equals(portData[1])) {
                        member.setHttpsPort(Integer.parseInt(portData[0]));
                    }
                    if (!"set".equals(System.getProperty("lb.disable"))) {
                        log.info((Object)("Following Endpoint added to Load Balancing configuration: " + url.toString()));
                    }
                    addedEndPointNameList.add(nextLine);
                    childEndpoints.add(member);
                }
            }
            if (childEndpoints.size() != 0) {
                synCfg.removeSequence("main");
                SequenceMediator mainSeq = new SequenceMediator();
                mainSeq.setName("main");
                InMediator in = new InMediator();
                OutMediator out = new OutMediator();
                out.addChild((Mediator)new SendMediator());
                mainSeq.addChild((Mediator)in);
                mainSeq.addChild((Mediator)out);
                SendMediator send = new SendMediator();
                LoadbalanceEndpoint lb = new LoadbalanceEndpoint();
                FilterMediator filterMediator = new FilterMediator();
                in.addChild((Mediator)filterMediator);
                SynapseXPath xpath = new SynapseXPath("get-property('To')");
                filterMediator.setSource(xpath);
                filterMediator.setRegex(Pattern.compile("/carbon"));
                PropertyMediator httpSCProperty = new PropertyMediator();
                httpSCProperty.setName("HTTP_SC");
                httpSCProperty.setScope("axis2");
                httpSCProperty.setValue("302");
                PropertyMediator locationHeader = new PropertyMediator();
                locationHeader.setName("Location");
                locationHeader.setScope("transport");
                locationHeader.setValue(this.getMasterHttpsEndpoint(PortSelector.normalEndpointList));
                PropertyMediator responseProperty = new PropertyMediator();
                responseProperty.setName("RESPONSE");
                responseProperty.setValue("true");
                HeaderMediator headerMediator = new HeaderMediator();
                headerMediator.setQName(new QName("To"));
                headerMediator.setAction(1);
                SendMediator sendMediator = new SendMediator();
                DropMediator dropMediator = new DropMediator();
                filterMediator.addChild((Mediator)locationHeader);
                filterMediator.addChild((Mediator)httpSCProperty);
                filterMediator.addChild((Mediator)responseProperty);
                filterMediator.addChild((Mediator)headerMediator);
                filterMediator.addChild((Mediator)sendMediator);
                filterMediator.addChild((Mediator)dropMediator);
                AnonymousListMediator elseMediator = new AnonymousListMediator();
                filterMediator.setElseMediator((ListMediator)elseMediator);
                elseMediator.addChild((Mediator)new LogMediator());
                elseMediator.addChild((Mediator)send);
                RoundRobin algorithm = new RoundRobin(childEndpoints);
                lb.setAlgorithm((LoadbalanceAlgorithm)algorithm);
                if (!"set".equals(System.getProperty("lb.disable"))) {
                    lb.setMembers(new ArrayList<Member>(addedEndpointList.values()));
                }
                send.setEndpoint((Endpoint)lb);
                synCfg.addSequence(mainSeq.getName(), (Mediator)mainSeq);
                if (!"set".equals(System.getProperty("lb.disable"))) {
                    log.info((Object)"Adding new Endpoint from the newly Started Instance to Load Balance");
                }
                mainSeq.init(EndPointManagerServiceComponent.getSynapseEnvService().getSynapseEnvironment());
            }
        }
    }

    private String getMasterHttpsEndpoint(List<String> portList) throws Exception {
        String hostName = NetworkUtils.getLocalHostname();
        Iterator<String> it = portList.iterator();
        String[] split = null;
        while (it.hasNext()) {
            String nextLine = it.next();
            if (!nextLine.split(" ")[2].contains("-master") || !"https".equals(nextLine.split(" ")[1])) continue;
            split = nextLine.split(" ");
        }
        String masterEndpoint = (String)split[1] + "://" + hostName + ":" + (String)split[0] + "/carbon";
        log.info((Object)("Adding master Endpoint for the Redirect: " + masterEndpoint));
        return masterEndpoint;
    }
}

