/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.module.mgt.ui.fileupload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.module.mgt.stub.types.ModuleUploadData;
import org.wso2.carbon.module.mgt.ui.client.ModuleManagementClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.FileItemData;

public class ModuleFileUploadExecutor
extends AbstractFileUploadExecutor {
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".mar"};
    private static final Log log = LogFactory.getLog(ModuleFileUploadExecutor.class);

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed.";
            log.error((Object)msg);
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/modulemgt/index.jsp?errorMessage=" + msg);
            return false;
        }
        ModuleManagementClient moduleUploaderClient = new ModuleManagementClient(this.configurationContext, serverURL, cookie, true);
        ArrayList<ModuleUploadData> moduleUploadDataList = new ArrayList<ModuleUploadData>();
        try {
            for (FileItemData fieldData : (ArrayList)fileItemsMap.get("marFilename")) {
                String fileName = this.getFileName(fieldData.getFileItem().getName());
                this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                if (!fileName.endsWith(".mar")) {
                    throw new CarbonException("File with extension " + fileName + " is not supported!");
                }
                ModuleUploadData tempModuleData = new ModuleUploadData();
                tempModuleData.setDataHandler(fieldData.getDataHandler());
                tempModuleData.setFileName(fileName);
                moduleUploadDataList.add(tempModuleData);
            }
            moduleUploaderClient.uploadService(moduleUploadDataList.toArray(new ModuleUploadData[moduleUploadDataList.size()]));
            response.setContentType("text/html; charset=utf-8");
            response.sendRedirect(this.getContextRoot(request) + "/" + webContext + "/modulemgt/index.jsp?restart=true");
            return true;
        }
        catch (Exception e) {
            String msg = "File upload failed. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/modulemgt/index.jsp"));
            return false;
        }
    }
}

