/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.sqs.internal.module;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.MultipleEntryHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.utils.Base64;
import org.wso2.carbon.messagebox.MessageBoxConstants;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.sqs.internal.FaultResponse;
import org.wso2.carbon.messagebox.sqs.internal.module.SQSAuthenticationException;
import org.wso2.carbon.messagebox.sqs.internal.util.Utils;

public class AuthenticationHandler
extends AbstractHandler {
    private static final Log log = LogFactory.getLog(AuthenticationHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        block8: {
            if (messageContext.isEngaged("sqsAuthentication")) {
                MultipleEntryHashMap multipleEntryHashMap = (MultipleEntryHashMap)messageContext.getProperty("requestParameterMap");
                if (multipleEntryHashMap != null) {
                    try {
                        if (!this.verifySignatureOnRestBasedRequest(messageContext, multipleEntryHashMap)) {
                            throw new FaultResponse(new MessageBoxException("AuthFailure"), messageContext.getMessageID()).createAxisFault();
                        }
                        break block8;
                    }
                    catch (SQSAuthenticationException e) {
                        throw new AxisFault(e.getMessage());
                    }
                }
                try {
                    if (!this.verifySignatureOnSOAPHeader(messageContext)) {
                        throw new FaultResponse(new MessageBoxException("AuthFailure"), messageContext.getMessageID()).createAxisFault();
                    }
                }
                catch (SQSAuthenticationException e) {
                    throw new AxisFault(e.getMessage());
                }
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private boolean verifySignatureOnSOAPHeader(MessageContext messageContext) throws SQSAuthenticationException {
        String accessKeyId = null;
        String timestamp = null;
        String signatureOnSoapMessage = null;
        SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        String actionName = messageContext.getSoapAction();
        if (soapHeader != null) {
            Iterator iterator = soapHeader.getChildrenWithName(MessageBoxConstants.ACCESS_KEY_ID_QNAME);
            if (iterator != null && iterator.hasNext()) {
                accessKeyId = ((OMElement)iterator.next()).getText().trim();
            }
            if ((iterator = soapHeader.getChildrenWithName(MessageBoxConstants.TIMESTAMP_QNAME)) != null && iterator.hasNext()) {
                timestamp = ((OMElement)iterator.next()).getText().trim();
            }
            if ((iterator = soapHeader.getChildrenWithName(MessageBoxConstants.SIGNATURE_QNAME)) != null && iterator.hasNext()) {
                signatureOnSoapMessage = ((OMElement)iterator.next()).getText().trim();
            }
            if (accessKeyId != null && actionName != null && timestamp != null && signatureOnSoapMessage != null) {
                if (this.compareSignatures(messageContext, accessKeyId, timestamp, actionName, signatureOnSoapMessage, "HmacSHA1", "0")) {
                    String userName = Utils.getUserName(accessKeyId, messageContext);
                    Utils.onSuccessAdminLogin(messageContext, userName);
                    log.info((Object)(userName + " is successfully authenticated for request " + "with action, " + actionName));
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private boolean verifySignatureOnRestBasedRequest(MessageContext messageContext, MultipleEntryHashMap multipleEntryHashMap) throws SQSAuthenticationException {
        Object accessKeyIdProperty = multipleEntryHashMap.get((Object)"AWSAccessKeyId");
        Object actionNameProperty = multipleEntryHashMap.get((Object)"Action");
        Object timestampProperty = multipleEntryHashMap.get((Object)"Timestamp");
        Object signatureProperty = multipleEntryHashMap.get((Object)"Signature");
        Object signatureMethod = multipleEntryHashMap.get((Object)"SignatureMethod");
        Object signatureVersion = multipleEntryHashMap.get((Object)"SignatureVersion");
        if (accessKeyIdProperty != null && actionNameProperty != null && timestampProperty != null && signatureProperty != null && signatureVersion != null) {
            multipleEntryHashMap.put((Object)"AWSAccessKeyId", accessKeyIdProperty);
            multipleEntryHashMap.put((Object)"Action", actionNameProperty);
            multipleEntryHashMap.put((Object)"Timestamp", timestampProperty);
            multipleEntryHashMap.put((Object)"Signature", signatureProperty);
            multipleEntryHashMap.put((Object)"SignatureMethod", signatureMethod);
            multipleEntryHashMap.put((Object)"SignatureVersion", signatureVersion);
            String accessKeyId = accessKeyIdProperty.toString().trim();
            String timestamp = timestampProperty.toString().trim();
            String actionName = actionNameProperty.toString().trim();
            String signatureOnSoapMessage = signatureProperty.toString().trim();
            if (signatureMethod == null) {
                throw new SQSAuthenticationException("Signature method can not be null in request!");
            }
            if (this.compareSignatures(messageContext, accessKeyId, timestamp, actionName, signatureOnSoapMessage, signatureMethod.toString(), signatureVersion.toString())) {
                String userName = Utils.getUserName(accessKeyId, messageContext);
                Utils.onSuccessAdminLogin(messageContext, userName);
                log.info((Object)(userName + " is successfully authenticated for request " + "with action, " + actionName));
                return true;
            }
            log.info((Object)("Failed to authenticate request with access key id: " + accessKeyId + " and action:" + actionName));
            return false;
        }
        return true;
    }

    private boolean compareSignatures(MessageContext messageContext, String accessKeyId, String timestamp, String actionName, String signatureOnSoapMessage, String signatureMethod, String signatureVersion) throws SQSAuthenticationException {
        String dataTobeSigned;
        MultipleEntryHashMap multipleEntryHashMap = (MultipleEntryHashMap)messageContext.getProperty("requestParameterMap");
        if ("0".equals(signatureVersion)) {
            dataTobeSigned = actionName + timestamp;
        } else if ("1".equals(signatureVersion)) {
            dataTobeSigned = this.getDataTobeSignedUsingVersion1(this.convertMultipleEntryHashMapToMap(multipleEntryHashMap));
        } else if ("2".equals(signatureVersion)) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            dataTobeSigned = this.getDataTobeSignedUsingVersion2(multipleEntryHashMap, httpServletRequest.getRequestURL().toString());
        } else {
            throw new SQSAuthenticationException("Signature version " + signatureVersion + " is not supported.");
        }
        String secretAccessKey = Utils.getUserSecretAccessKey(accessKeyId, messageContext);
        if (secretAccessKey == null) {
            throw new SQSAuthenticationException("Failed to get secretAccessKey of access key id:" + accessKeyId);
        }
        String signature = AuthenticationHandler.calculateRFC2104HMAC(dataTobeSigned, secretAccessKey, signatureMethod);
        return signature.equals(signatureOnSoapMessage);
    }

    private String getDataTobeSignedUsingVersion1(Map<String, String> parameters) {
        StringBuilder dataTobeSigned = new StringBuilder();
        TreeMap<String, String> sorted = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        sorted.putAll(parameters);
        for (Map.Entry entry : sorted.entrySet()) {
            dataTobeSigned.append(entry.getKey());
            dataTobeSigned.append(entry.getValue());
        }
        return dataTobeSigned.toString();
    }

    private String getDataTobeSignedUsingVersion2(MultipleEntryHashMap multipleEntryHashMap, String queueUrl) throws SQSAuthenticationException {
        URI endpoint;
        try {
            endpoint = new URI(queueUrl);
        }
        catch (URISyntaxException e) {
            throw new SQSAuthenticationException("Queue URL:" + queueUrl + " is not valid.", e);
        }
        StringBuilder dataTobeSigned = new StringBuilder();
        dataTobeSigned.append("POST").append("\n");
        dataTobeSigned.append(this.getCanonicalizedEndpoint(endpoint)).append("\n");
        dataTobeSigned.append(this.getCanonicalizedResourcePath(endpoint)).append("\n");
        Map<String, String> parameterMap = this.convertMultipleEntryHashMapToMap(multipleEntryHashMap);
        parameterMap.remove("Signature");
        dataTobeSigned.append(this.getCanonicalizedQueryString(parameterMap));
        return dataTobeSigned.toString();
    }

    private static String calculateRFC2104HMAC(String data, String key, String signatureMethod) throws SQSAuthenticationException {
        String result;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), signatureMethod);
            Mac mac = Mac.getInstance(signatureMethod);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            result = Base64.encode((byte[])rawHmac);
        }
        catch (Exception e) {
            throw new SQSAuthenticationException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    private Map<String, String> convertMultipleEntryHashMapToMap(MultipleEntryHashMap multipleEntryHashMap) throws SQSAuthenticationException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : multipleEntryHashMap.keySet()) {
            if (!(key instanceof String)) continue;
            try {
                String entryKey = (String)key;
                Object entryValue = multipleEntryHashMap.get((Object)entryKey);
                if (entryValue == null) continue;
                multipleEntryHashMap.put((Object)entryKey, entryValue);
                entryKey = URLDecoder.decode(entryKey, "UTF-8");
                map.put(entryKey, URLDecoder.decode((String)entryValue, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SQSAuthenticationException("Failed to decode string " + e.getMessage(), e);
            }
        }
        return map;
    }

    private String getCanonicalizedQueryString(Map<String, String> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        StringBuilder builder = new StringBuilder();
        Iterator pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            String key = (String)pair.getKey();
            String value = (String)pair.getValue();
            builder.append(this.urlEncode(key, false));
            builder.append("=");
            builder.append(this.urlEncode(value, false));
            if (!pairs.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    private String getCanonicalizedResourcePath(URI endpoint) {
        String uri = endpoint.getPath();
        if (uri == null || uri.length() == 0) {
            return "/";
        }
        return this.urlEncode(uri, true);
    }

    private String getCanonicalizedEndpoint(URI endpoint) {
        String endpointForStringToSign = endpoint.getHost().toLowerCase();
        if (this.isUsingNonDefaultPort(endpoint)) {
            endpointForStringToSign = endpointForStringToSign + ":" + endpoint.getPort();
        }
        return endpointForStringToSign;
    }

    private String urlEncode(String value, boolean path) {
        try {
            String encoded = URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
            if (path) {
                encoded = encoded.replace("%2F", "/");
            }
            return encoded;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isUsingNonDefaultPort(URI uri) {
        String scheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        return !(port <= 0 || scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443);
    }

    public void flowComplete(MessageContext msgContext) {
        boolean authenticated;
        Object sqsAuthenticated = msgContext.getProperty("sqsAuthenticated");
        msgContext.removeProperty("sqsAuthenticated");
        if (sqsAuthenticated != null && (authenticated = ((Boolean)sqsAuthenticated).booleanValue())) {
            Object servletRequest = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            httpServletRequest.getSession().invalidate();
        }
    }
}

