/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.sqs.internal;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.SQSMessage;
import org.wso2.carbon.messagebox.sqs.internal.AddPermission;
import org.wso2.carbon.messagebox.sqs.internal.AddPermissionResponse;
import org.wso2.carbon.messagebox.sqs.internal.Attribute_type0;
import org.wso2.carbon.messagebox.sqs.internal.ChangeMessageVisibility;
import org.wso2.carbon.messagebox.sqs.internal.ChangeMessageVisibilityResponse;
import org.wso2.carbon.messagebox.sqs.internal.DeleteMessage;
import org.wso2.carbon.messagebox.sqs.internal.DeleteMessageResponse;
import org.wso2.carbon.messagebox.sqs.internal.DeleteQueue;
import org.wso2.carbon.messagebox.sqs.internal.DeleteQueueResponse;
import org.wso2.carbon.messagebox.sqs.internal.FaultResponse;
import org.wso2.carbon.messagebox.sqs.internal.GetQueueAttributes;
import org.wso2.carbon.messagebox.sqs.internal.GetQueueAttributesResponse;
import org.wso2.carbon.messagebox.sqs.internal.GetQueueAttributesResult_type0;
import org.wso2.carbon.messagebox.sqs.internal.Message_type0;
import org.wso2.carbon.messagebox.sqs.internal.ReceiveMessage;
import org.wso2.carbon.messagebox.sqs.internal.ReceiveMessageResponse;
import org.wso2.carbon.messagebox.sqs.internal.ReceiveMessageResult_type0;
import org.wso2.carbon.messagebox.sqs.internal.RemovePermission;
import org.wso2.carbon.messagebox.sqs.internal.RemovePermissionResponse;
import org.wso2.carbon.messagebox.sqs.internal.ResponseMetadata_type0;
import org.wso2.carbon.messagebox.sqs.internal.SendMessage;
import org.wso2.carbon.messagebox.sqs.internal.SendMessageResponse;
import org.wso2.carbon.messagebox.sqs.internal.SendMessageResult_type0;
import org.wso2.carbon.messagebox.sqs.internal.SetQueueAttributes;
import org.wso2.carbon.messagebox.sqs.internal.SetQueueAttributesResponse;
import org.wso2.carbon.messagebox.sqs.internal.util.Utils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class MessageQueueSkeleton {
    private static final Log log = LogFactory.getLog(MessageQueueSkeleton.class);

    public SetQueueAttributesResponse setQueueAttributes(SetQueueAttributes setQueueAttributes) throws AxisFault {
        String messageBoxId = Utils.getQueueNameFromRequestURI();
        Attribute_type0[] attributes = setQueueAttributes.getAttribute();
        ConcurrentHashMap<String, String> attributeMap = new ConcurrentHashMap<String, String>(attributes.length);
        for (Attribute_type0 attribute : attributes) {
            String attributeName = attribute.getName();
            if (!(attributeName.equals("VisibilityTimeout") || attributeName.equals("MessageRetentionPeriod") || attributeName.equals("MaximumMessageSize"))) {
                throw new FaultResponse(Utils.getMessageRequestId(), "InvalidAttributeName", "Unknown attribute").createAxisFault();
            }
            String attributeValue = attribute.getValue();
            attributeMap.put(attributeName, attributeValue);
        }
        try {
            Utils.getMessageBoxService().setMessageBoxAttributes(messageBoxId, attributeMap);
            SetQueueAttributesResponse setQueueAttributesResponse = new SetQueueAttributesResponse();
            setQueueAttributesResponse.setResponseMetadata(this.getResponseMetadata_type0());
            if (log.isInfoEnabled()) {
                log.info((Object)("Queue attributes successfully set in queue, " + messageBoxId));
            }
            return setQueueAttributesResponse;
        }
        catch (MessageBoxException e) {
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    public DeleteQueueResponse deleteQueue(DeleteQueue deleteQueue) {
        DeleteQueueResponse deleteQueueResponse = new DeleteQueueResponse();
        deleteQueueResponse.setResponseMetadata(this.getResponseMetadata_type0());
        String messageboxId = Utils.getQueueNameFromRequestURI();
        try {
            Utils.getMessageBoxService().deleteMessageBox(messageboxId);
            if (log.isInfoEnabled()) {
                log.info((Object)(messageboxId + " ,queue is successfully deleted."));
            }
        }
        catch (MessageBoxException e) {
            log.debug((Object)("Failed to delete messagebox with id " + messageboxId));
        }
        return deleteQueueResponse;
    }

    public ChangeMessageVisibilityResponse changeMessageVisibility(ChangeMessageVisibility changeMessageVisibility) throws AxisFault {
        String messageBoxId = Utils.getQueueNameFromRequestURI();
        String receiptHandler = changeMessageVisibility.getReceiptHandle();
        long visibilityTimeout = 0L;
        BigInteger timeoutValue = changeMessageVisibility.getVisibilityTimeout();
        if (timeoutValue != null && (visibilityTimeout = timeoutValue.longValue()) > 43200L && visibilityTimeout < 0L) {
            throw new FaultResponse(Utils.getMessageRequestId(), "InvalidParameterValue", "One or more parameters cannot be validated.").createAxisFault();
        }
        try {
            Utils.getMessageBoxService().changeVisibility(messageBoxId, receiptHandler, visibilityTimeout);
            ChangeMessageVisibilityResponse changeMessageVisibilityResponse = new ChangeMessageVisibilityResponse();
            changeMessageVisibilityResponse.setResponseMetadata(this.getResponseMetadata_type0());
            if (log.isInfoEnabled()) {
                log.info((Object)("Message visibility time out was changed in messages in queue, " + messageBoxId));
            }
            return changeMessageVisibilityResponse;
        }
        catch (MessageBoxException e) {
            log.debug((Object)("unable to change visibilityTimeout with receiptHandler: " + receiptHandler + " in message box: " + messageBoxId));
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    private ResponseMetadata_type0 getResponseMetadata_type0() {
        ResponseMetadata_type0 responseMetadata_type0 = new ResponseMetadata_type0();
        responseMetadata_type0.setRequestId(Utils.getMessageRequestId());
        return responseMetadata_type0;
    }

    public AddPermissionResponse addPermission(AddPermission addPermission) throws AxisFault {
        String permissionLabel = addPermission.getLabel();
        if (!Utils.validQueueName(permissionLabel)) {
            throw new FaultResponse(Utils.getMessageRequestId(), "InvalidParameterValue", "One or more parameters cannot be validated.").createAxisFault();
        }
        List<String> operationsList = Arrays.asList(addPermission.getActionName());
        this.checkValidOperationNames(operationsList);
        if (operationsList.contains("*")) {
            operationsList.clear();
            this.getAllOperations(operationsList);
        }
        List<String> sharedUsers = Arrays.asList(addPermission.getAWSAccountId());
        String messageBoxId = Utils.getQueueNameFromRequestURI();
        try {
            Utils.getMessageBoxService().addPermission(messageBoxId, operationsList, permissionLabel, sharedUsers);
            AddPermissionResponse addPermissionResponse = new AddPermissionResponse();
            addPermissionResponse.setResponseMetadata(this.getResponseMetadata_type0());
            if (log.isInfoEnabled()) {
                log.info((Object)("New permissions is added to queue, " + messageBoxId + " with permission label, " + permissionLabel));
            }
            return addPermissionResponse;
        }
        catch (MessageBoxException e) {
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    private void getAllOperations(List<String> operationsList) {
        operationsList.add("ChangeMessageVisibility");
        operationsList.add("DeleteMessage");
        operationsList.add("GetQueueAttributes");
        operationsList.add("ReceiveMessage");
        operationsList.add("SendMessage");
    }

    private void checkValidOperationNames(List<String> operationsList) throws AxisFault {
        for (String operation : operationsList) {
            if ("*".equals(operation) || "ChangeMessageVisibility".equals(operation) || "DeleteMessage".equals(operation) || "GetQueueAttributes".equals(operation) || "ReceiveMessage".equals(operation) || "SendMessage".equals(operation)) continue;
            throw new FaultResponse(Utils.getMessageRequestId(), "InvalidActionName", "The action specified was invalid. ").createAxisFault();
        }
    }

    public GetQueueAttributesResponse getQueueAttributes(GetQueueAttributes getQueueAttributes) throws AxisFault {
        String[] attributeNames = getQueueAttributes.getAttributeName();
        List<String> attributeNameList = Arrays.asList(attributeNames);
        this.checkValidAttributeNames(attributeNames);
        int attributeNamesLength = attributeNames.length;
        GetQueueAttributesResponse getQueueAttributesResponse = new GetQueueAttributesResponse();
        GetQueueAttributesResult_type0 getQueueAttributesResult_type0 = new GetQueueAttributesResult_type0();
        Attribute_type0[] attribute_type0s = new Attribute_type0[attributeNamesLength];
        String messageBoxId = Utils.getQueueNameFromRequestURI();
        try {
            Map attributeMap = Utils.getMessageBoxService().getMessageBoxAttributes(messageBoxId);
            if (attributeNameList.contains("All")) {
                for (int index = 0; index < attributeNamesLength; ++index) {
                    String attributeName = attributeNames[index];
                    String attributeValue = "";
                    if (attributeMap.get(attributeName) != null) {
                        attributeValue = (String)attributeMap.get(attributeName);
                    }
                    attribute_type0s[index] = new Attribute_type0();
                    attribute_type0s[index].setName(attributeName);
                    attribute_type0s[index].setValue(attributeValue);
                }
            } else {
                for (int index = 0; index < attributeNamesLength; ++index) {
                    String attributeName = attributeNames[index];
                    if (!attributeNameList.contains(attributeName)) continue;
                    String attributeValue = "";
                    if (attributeMap.get(attributeName) != null) {
                        attributeValue = (String)attributeMap.get(attributeName);
                    }
                    attribute_type0s[index] = new Attribute_type0();
                    attribute_type0s[index].setName(attributeName);
                    attribute_type0s[index].setValue(attributeValue);
                }
            }
            getQueueAttributesResult_type0.setAttribute(attribute_type0s);
            getQueueAttributesResponse.setGetQueueAttributesResult(getQueueAttributesResult_type0);
            getQueueAttributesResponse.setResponseMetadata(this.getResponseMetadata_type0());
            if (log.isInfoEnabled()) {
                log.info((Object)("Queue attributes successfully received in queue, " + messageBoxId));
            }
            return getQueueAttributesResponse;
        }
        catch (MessageBoxException e) {
            log.debug((Object)("Failed to retrieve number of messages in " + messageBoxId));
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    private void checkValidAttributeNames(String[] attributeNames) throws AxisFault {
        for (String attributeName : attributeNames) {
            if (attributeName.equals("All") || attributeName.equals("ApproximateNumberOfMessages") || attributeName.equals("ApproximateNumberOfMessagesNotVisible") || attributeName.equals("VisibilityTimeout") || attributeName.equals("CreatedTimestamp") || attributeName.equals("LastModifiedTimestamp") || attributeName.equals("MaximumMessageSize") || attributeName.equals("MessageRetentionPeriod") || attributeName.equals("Policy")) continue;
            throw new FaultResponse(Utils.getMessageRequestId(), "InvalidAttributeName", "Unknown attribute").createAxisFault();
        }
    }

    public DeleteMessageResponse deleteMessage(DeleteMessage deleteMessage) throws AxisFault {
        DeleteMessageResponse deleteMessageResponse = new DeleteMessageResponse();
        String[] receiptHandlers = deleteMessage.getReceiptHandle();
        String messageBoxId = Utils.getQueueNameFromRequestURI();
        try {
            for (String receiptHandler : receiptHandlers) {
                Utils.getMessageBoxService().deleteMessage(messageBoxId, receiptHandler);
                deleteMessageResponse.setResponseMetadata(this.getResponseMetadata_type0());
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Messages are deleted in queue, " + messageBoxId));
            }
            return deleteMessageResponse;
        }
        catch (MessageBoxException e) {
            log.debug((Object)("Unable to delete messages in messagebox: " + messageBoxId));
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    public SendMessageResponse sendMessage(SendMessage sendMessage) throws AxisFault {
        String messageBody = sendMessage.getMessageBody();
        if (!Utils.validMessageBody(messageBody)) {
            throw new FaultResponse(Utils.getMessageRequestId(), "InvalidMessageContents", "The message contains characters outside the allowed set.").createAxisFault();
        }
        String messageboxId = Utils.getQueueNameFromRequestURI();
        String messageId = UUID.randomUUID().toString();
        String receiptHandler = UUID.randomUUID().toString();
        String MD5OfMessage = Utils.getMD5OfMessage(messageBody);
        SQSMessage message = new SQSMessage();
        message.setBody(messageBody);
        message.setMd5ofMessageBody(MD5OfMessage);
        message.setMessageId(messageId);
        message.setReceiptHandle(receiptHandler);
        message.setSenderId(MultitenantUtils.getTenantAwareUsername((String)CarbonContext.getCurrentContext().getUsername()));
        try {
            Utils.getMessageBoxService().putMessage(messageboxId, message);
            SendMessageResponse sendMessageResponse = new SendMessageResponse();
            SendMessageResult_type0 sendMessageResult_type0 = new SendMessageResult_type0();
            sendMessageResult_type0.setMessageId(messageId);
            sendMessageResult_type0.setMD5OfMessageBody(MD5OfMessage);
            sendMessageResponse.setResponseMetadata(this.getResponseMetadata_type0());
            sendMessageResponse.setSendMessageResult(sendMessageResult_type0);
            if (log.isInfoEnabled()) {
                log.info((Object)("Message,  " + message.getBody() + " is sent to queue, " + messageboxId));
            }
            return sendMessageResponse;
        }
        catch (MessageBoxException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to send message:" + messageBody + " to messagebox: " + messageboxId));
            }
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    public ReceiveMessageResponse receiveMessage(ReceiveMessage receiveMessage) throws AxisFault {
        int maxNumberOfMessages = 1;
        BigInteger messageCount = receiveMessage.getMaxNumberOfMessages();
        if (messageCount != null && ((maxNumberOfMessages = messageCount.intValue()) > 10 || maxNumberOfMessages < 1)) {
            throw new FaultResponse(Utils.getMessageRequestId(), "ReadCountOutOfRange", "The value for MaxNumberOfMessages is not valid (must be from 1 to 10).").createAxisFault();
        }
        String messageBoxId = Utils.getQueueNameFromRequestURI();
        long visibilityTimeout = 0L;
        BigInteger timeoutValue = receiveMessage.getVisibilityTimeout();
        if (timeoutValue != null && (visibilityTimeout = timeoutValue.longValue()) > 43200L && visibilityTimeout < 0L) {
            throw new FaultResponse(Utils.getMessageRequestId(), "InvalidParameterValue", "One or more parameters cannot be validated.").createAxisFault();
        }
        ConcurrentHashMap<String, String> attributeMap = new ConcurrentHashMap<String, String>();
        boolean attributesRequired = true;
        if (receiveMessage.getAttributeName() == null) {
            attributesRequired = false;
        }
        try {
            List messageList = Utils.getMessageBoxService().receiveMessage(messageBoxId, maxNumberOfMessages, visibilityTimeout, attributeMap);
            int numberOfMessagesRetreived = messageList.size();
            Message_type0[] message_type0 = new Message_type0[numberOfMessagesRetreived];
            int index = 0;
            for (SQSMessage receivedMessage : messageList) {
                message_type0[index] = new Message_type0();
                message_type0[index].setBody(receivedMessage.getBody());
                message_type0[index].setMessageId(receivedMessage.getMessageId());
                message_type0[index].setMD5OfBody(receivedMessage.getMd5ofMessageBody());
                message_type0[index].setReceiptHandle(receivedMessage.getReceiptHandle());
                if (attributesRequired) {
                    message_type0[index].setAttribute(this.getAttributeValues(attributeMap, receiveMessage.getAttributeName()));
                }
                ++index;
            }
            ReceiveMessageResponse receiveMessageResponse = new ReceiveMessageResponse();
            ReceiveMessageResult_type0 receiveMessageResult_type0 = new ReceiveMessageResult_type0();
            receiveMessageResult_type0.setMessage(message_type0);
            receiveMessageResponse.setReceiveMessageResult(receiveMessageResult_type0);
            receiveMessageResponse.setResponseMetadata(this.getResponseMetadata_type0());
            if (log.isInfoEnabled()) {
                log.info((Object)(numberOfMessagesRetreived + " messages are received from queue,  " + messageBoxId));
            }
            return receiveMessageResponse;
        }
        catch (MessageBoxException e) {
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    private Attribute_type0[] getAttributeValues(Map<String, String> attributeMap, String[] attributeNames) {
        Attribute_type0[] attribute_type0s;
        List<String> attributeList = Arrays.asList(attributeNames);
        if (attributeList.contains("All")) {
            int index = 0;
            attribute_type0s = new Attribute_type0[attributeMap.size()];
            for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
                attribute_type0s[index] = new Attribute_type0();
                attribute_type0s[index].setName(entry.getKey().toString());
                attribute_type0s[index].setValue(entry.getValue().toString());
                ++index;
            }
        } else {
            int index = 0;
            attribute_type0s = new Attribute_type0[attributeList.size()];
            for (String attributeName : attributeNames) {
                attribute_type0s[index] = new Attribute_type0();
                attribute_type0s[index].setName(attributeName);
                attribute_type0s[index].setValue(attributeMap.get(attributeName));
                ++index;
            }
        }
        return attribute_type0s;
    }

    public RemovePermissionResponse removePermission(RemovePermission removePermission) throws AxisFault {
        String permissionLabel = removePermission.getLabel();
        String messageBoxId = Utils.getQueueNameFromRequestURI();
        try {
            Utils.getMessageBoxService().removePermission(messageBoxId, permissionLabel);
            RemovePermissionResponse removePermissionResponse = new RemovePermissionResponse();
            removePermissionResponse.setResponseMetadata(this.getResponseMetadata_type0());
            if (log.isInfoEnabled()) {
                log.info((Object)("Permission is removed from queue, " + messageBoxId + " with permission label, " + permissionLabel));
            }
            return removePermissionResponse;
        }
        catch (MessageBoxException e) {
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }
}

