/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.sqs.internal.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.util.base64.Base64Utils;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.URI;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.messagebox.MessageBoxService;
import org.wso2.carbon.messagebox.sqs.internal.module.SQSAuthenticationException;
import org.wso2.carbon.messagebox.sqs.internal.util.MessageBoxHolder;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class Utils {
    private static final Log log = LogFactory.getLog(Utils.class);

    public static String getMessageRequestId() {
        return UUID.randomUUID().toString();
    }

    public static String getQueueNameFromRequestURI() {
        try {
            String queueUrl = MessageContext.getCurrentMessageContext().getTo().getAddress();
            return queueUrl.split("MessageQueue/")[1];
        }
        catch (Exception e) {
            log.error((Object)"Failed to get Queue Name");
            return null;
        }
    }

    public static MessageBoxService getMessageBoxService() {
        return MessageBoxHolder.getInstance().getMessageboxService();
    }

    public static String getMD5OfMessage(String messageBody) {
        try {
            URLEncoder.encode(messageBody, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Failed to URL encode the message " + messageBody));
        }
        String MD5OfMessage = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(messageBody.getBytes());
            byte[] hash = digest.digest();
            MD5OfMessage = Base64Utils.encode((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("Failed to get MD5 hash in message " + messageBody));
        }
        return MD5OfMessage;
    }

    public static URI constructResponseURL(String queueName) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)MessageContext.getCurrentMessageContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        String finalResponseUrl = httpServletRequest.getRequestURL().toString();
        finalResponseUrl = finalResponseUrl.substring(0, finalResponseUrl.indexOf("QueueService"));
        finalResponseUrl = finalResponseUrl + "MessageQueue/" + queueName;
        return ConverterUtil.convertToURI((String)finalResponseUrl);
    }

    public static boolean validQueueName(String queueName) {
        if (queueName != null) {
            String queueNameRegex = "([a-zA-Z0-9_\\-])+";
            return Pattern.matches(queueNameRegex, queueName);
        }
        return false;
    }

    public static boolean validMessageBody(String messageBody) {
        return true;
    }

    public static Map<String, String> getSQSErrorCodeDescriptionMap() {
        HashMap<String, String> sqsErrorCodes = new HashMap<String, String>();
        sqsErrorCodes.put("AccessDenied", "Access to the resource is denied.");
        sqsErrorCodes.put("AuthFailure", "A value used for authentication could not be validated, such as Signature.");
        sqsErrorCodes.put("InternalError", "There is an internal problem with SQS, which you cannot resolve.");
        sqsErrorCodes.put("AWS.SimpleQueueService.NonExistentQueue", "Queue does not exist.");
        sqsErrorCodes.put("InvalidAccessKeyId", "AWS was not able to validate the \nprovided access credentials. ");
        sqsErrorCodes.put("InvalidAction", "The action specified was invalid. ");
        sqsErrorCodes.put("InvalidParameterValue", "One or more parameters cannot be \nvalidated. ");
        sqsErrorCodes.put("AWS.SimpleQueueService.QueueNameExists", " Queue already exists. SQS returns this error only if the request includes a DefaultVisibilityTimeout value that differs from the value  for the existing queue.");
        return sqsErrorCodes;
    }

    public static String getUserSecretAccessKey(String accessKeyId, MessageContext messageContext) throws SQSAuthenticationException {
        try {
            Collection userCollection;
            UserRegistry registry = MessageBoxHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(SuperTenantCarbonContext.getCurrentContext((MessageContext)messageContext).getTenantId());
            String userName = Utils.getUserName(accessKeyId, messageContext);
            if (registry.resourceExists("/users/" + userName) && (userCollection = (Collection)registry.get("/users/" + userName)) != null) {
                return userCollection.getProperty("secretAccessKeyId");
            }
            return null;
        }
        catch (RegistryException e) {
            throw new SQSAuthenticationException("Failed to get secret id of user " + accessKeyId);
        }
    }

    public static String getUserName(String accessKeyId, MessageContext messageContext) throws SQSAuthenticationException {
        try {
            Collection userCollection;
            UserRegistry registry = MessageBoxHolder.getInstance().getRegistryService().getGovernanceSystemRegistry(SuperTenantCarbonContext.getCurrentContext((MessageContext)messageContext).getTenantId());
            if (registry.resourceExists("/users/access.key.index") && (userCollection = (Collection)registry.get("/users/access.key.index")) != null) {
                return userCollection.getProperty(accessKeyId);
            }
            return null;
        }
        catch (RegistryException e) {
            throw new SQSAuthenticationException("Failed to get secret id of user " + accessKeyId);
        }
    }

    public static void onSuccessAdminLogin(MessageContext messageContext, String accessKeyId) throws SQSAuthenticationException {
        Object servletRequest = messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        messageContext.setProperty("sqsAuthenticated", (Object)Boolean.TRUE);
        if (servletRequest != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
            try {
                SuperTenantCarbonContext carbonContext = SuperTenantCarbonContext.getCurrentContext((MessageContext)messageContext);
                CarbonAuthenticationUtil.onSuccessAdminLogin((HttpSession)httpServletRequest.getSession(), (String)accessKeyId, (int)carbonContext.getTenantId(), (String)carbonContext.getTenantDomain(), null);
            }
            catch (Exception e) {
                throw new SQSAuthenticationException("Failed to set on success admin log in parameters" + e.getMessage());
            }
        }
    }
}

