/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.sqs.internal.dispatcher;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.util.MultipleEntryHashMap;

public class SQSRestBasedHandler
extends AbstractHandler {
    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        MultipleEntryHashMap multipleEntryHashMap = (MultipleEntryHashMap)messageContext.getProperty("requestParameterMap");
        if (multipleEntryHashMap != null) {
            Object accessKeyIdProperty = multipleEntryHashMap.get((Object)"AWSAccessKeyId");
            Object actionNameProperty = multipleEntryHashMap.get((Object)"Action");
            Object messageBodyProperty = multipleEntryHashMap.get((Object)"MessageBody");
            Object maxNumberOfMessagesProperty = multipleEntryHashMap.get((Object)"MaxNumberOfMessages");
            Object visibilityTimeoutProperty = multipleEntryHashMap.get((Object)"VisibilityTimeout");
            Object receiptHandleProperty = multipleEntryHashMap.get((Object)"ReceiptHandle");
            Object queueNamePrefixProperty = multipleEntryHashMap.get((Object)"QueueNamePrefix");
            Object permissionLabelProperty = multipleEntryHashMap.get((Object)"Label");
            Object queueNameProperty = multipleEntryHashMap.get((Object)"QueueName");
            ArrayList<Object> aWSAccountIdList = new ArrayList<Object>();
            ArrayList<Object> actionNameList = new ArrayList<Object>();
            ArrayList<Object> attributeNameList = new ArrayList<Object>();
            ArrayList<Object> setQueueAttributeNameList = new ArrayList<Object>();
            ArrayList<Object> setQueueAttributeValueList = new ArrayList<Object>();
            this.getParametersFromHashMap(multipleEntryHashMap, aWSAccountIdList, actionNameList, attributeNameList, setQueueAttributeNameList, setQueueAttributeValueList);
            if (actionNameProperty != null) {
                String actionName = actionNameProperty.toString();
                this.emptyMultipleHashMap(multipleEntryHashMap);
                if (actionName.equalsIgnoreCase("CreateQueue") || actionName.equalsIgnoreCase("DeleteQueue")) {
                    multipleEntryHashMap.put((Object)"QueueName", queueNameProperty);
                } else if (actionName.equalsIgnoreCase("SendMessage")) {
                    try {
                        String messageBody = URLDecoder.decode(messageBodyProperty.toString(), "UTF-8");
                        multipleEntryHashMap.put((Object)"MessageBody", (Object)messageBody);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new AxisFault("Failed to decode message body " + messageBodyProperty.toString(), (Throwable)e);
                    }
                } else if (actionName.equalsIgnoreCase("ReceiveMessage")) {
                    this.setReceiveMessageParameters(multipleEntryHashMap, maxNumberOfMessagesProperty, visibilityTimeoutProperty, attributeNameList);
                } else if (actionName.equalsIgnoreCase("DeleteMessage")) {
                    multipleEntryHashMap.put((Object)"ReceiptHandle", receiptHandleProperty);
                } else if (actionName.equalsIgnoreCase("ListQueues")) {
                    multipleEntryHashMap.put((Object)"QueueNamePrefix", queueNamePrefixProperty);
                } else if (actionName.equalsIgnoreCase("ChangeMessageVisibility")) {
                    multipleEntryHashMap.put((Object)"ReceiptHandle", receiptHandleProperty);
                    multipleEntryHashMap.put((Object)"VisibilityTimeout", visibilityTimeoutProperty);
                } else if (actionName.equalsIgnoreCase("GetQueueAttributes")) {
                    for (Object e : attributeNameList) {
                        multipleEntryHashMap.put((Object)"AttributeName", e);
                    }
                } else if (actionName.equalsIgnoreCase("SetQueueAttributes")) {
                    this.setSetQueueAttributeParameters(multipleEntryHashMap, setQueueAttributeNameList, setQueueAttributeValueList);
                } else if (actionName.equalsIgnoreCase("AddPermission")) {
                    this.setAddPermissionParameters(multipleEntryHashMap, accessKeyIdProperty, permissionLabelProperty, aWSAccountIdList, actionNameList);
                } else if (actionName.equalsIgnoreCase("RemovePermission")) {
                    multipleEntryHashMap.put((Object)"AWSAccountId", accessKeyIdProperty);
                    multipleEntryHashMap.put((Object)"Label", permissionLabelProperty);
                }
                SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
                messageContext.setEnvelope(BuilderUtil.buildsoapMessage((MessageContext)messageContext, (MultipleEntryHashMap)multipleEntryHashMap, (SOAPFactory)soapFactory));
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setReceiveMessageParameters(MultipleEntryHashMap multipleEntryHashMap, Object maxNumberOfMessagesProperty, Object visibilityTimeoutProperty, List<Object> attributeNameList) {
        multipleEntryHashMap.put((Object)"MaxNumberOfMessages", maxNumberOfMessagesProperty);
        multipleEntryHashMap.put((Object)"VisibilityTimeout", visibilityTimeoutProperty);
        int attributeIndex = 0;
        for (Object attributeNameProperty : attributeNameList) {
            multipleEntryHashMap.put((Object)("AttributeName." + ++attributeIndex), attributeNameProperty);
        }
    }

    private void setSetQueueAttributeParameters(MultipleEntryHashMap multipleEntryHashMap, List<Object> setQueueAttributeNameList, List<Object> setQueueAttributeValueList) {
        for (Object attributeNameProperty : setQueueAttributeNameList) {
            multipleEntryHashMap.put((Object)"AttributeName.Name", attributeNameProperty);
        }
        for (Object attributeValueProperty : setQueueAttributeValueList) {
            multipleEntryHashMap.put((Object)"AttributeName.Value", attributeValueProperty);
        }
    }

    private void setAddPermissionParameters(MultipleEntryHashMap multipleEntryHashMap, Object accessKeyIdProperty, Object permissionLabelProperty, List<Object> aWSAccountIdList, List<Object> actionNameList) {
        for (Object awsAccountIdProperty : aWSAccountIdList) {
            multipleEntryHashMap.put((Object)"AWSAccountId", awsAccountIdProperty);
        }
        for (Object awsActionNameProperty : actionNameList) {
            multipleEntryHashMap.put((Object)"ActionName", awsActionNameProperty);
        }
        multipleEntryHashMap.put((Object)"Label", permissionLabelProperty);
        multipleEntryHashMap.put((Object)"AWSAccountId", accessKeyIdProperty);
    }

    private void getParametersFromHashMap(MultipleEntryHashMap multipleEntryHashMap, List<Object> aWSAccountIdList, List<Object> actionNameList, List<Object> attributeNameList, List<Object> setQueueAttributeNameList, List<Object> setQueueAttributeValueList) {
        int attributeNameIndex = 1;
        int attributeValueIndex = 1;
        for (Object propertyName : multipleEntryHashMap.keySet()) {
            Object propertyValue = multipleEntryHashMap.get(propertyName);
            if (propertyName.toString().startsWith("AWSAccountId") && propertyValue != null) {
                aWSAccountIdList.add(propertyValue);
                continue;
            }
            if (propertyName.toString().startsWith("ActionName") && propertyValue != null) {
                actionNameList.add(propertyValue);
                continue;
            }
            if (propertyName.toString().startsWith("AttributeName") && propertyValue != null) {
                attributeNameList.add(propertyValue);
                continue;
            }
            if (propertyName.toString().startsWith("Attribute." + attributeNameIndex + ".Name") && propertyValue != null) {
                setQueueAttributeNameList.add(propertyValue);
                ++attributeNameIndex;
                continue;
            }
            if (!propertyName.toString().startsWith("Attribute." + attributeValueIndex + ".Value") || propertyValue == null) continue;
            setQueueAttributeValueList.add(propertyValue);
            ++attributeValueIndex;
        }
    }

    private void emptyMultipleHashMap(MultipleEntryHashMap multipleEntryHashMap) {
        for (Object aKeySet : multipleEntryHashMap.keySet()) {
            multipleEntryHashMap.get(aKeySet);
        }
    }
}

