/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.sqs.internal;

import java.math.BigInteger;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.databinding.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.MessageBoxService;
import org.wso2.carbon.messagebox.sqs.internal.CreateQueue;
import org.wso2.carbon.messagebox.sqs.internal.CreateQueueResponse;
import org.wso2.carbon.messagebox.sqs.internal.CreateQueueResult;
import org.wso2.carbon.messagebox.sqs.internal.CreateQueueResult_type0;
import org.wso2.carbon.messagebox.sqs.internal.FaultResponse;
import org.wso2.carbon.messagebox.sqs.internal.ListQueues;
import org.wso2.carbon.messagebox.sqs.internal.ListQueuesResponse;
import org.wso2.carbon.messagebox.sqs.internal.ListQueuesResult_type0;
import org.wso2.carbon.messagebox.sqs.internal.ResponseMetadata_type0;
import org.wso2.carbon.messagebox.sqs.internal.util.MessageBoxHolder;
import org.wso2.carbon.messagebox.sqs.internal.util.Utils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class QueueServiceSkeleton {
    private static final Log log = LogFactory.getLog(QueueServiceSkeleton.class);

    public ListQueuesResponse listQueues(ListQueues listQueues) throws AxisFault {
        String userName = MultitenantUtils.getTenantAwareUsername((String)CarbonContext.getCurrentContext().getUsername());
        MessageBoxService messageBoxService = Utils.getMessageBoxService();
        String queueNamePrefix = listQueues.getQueueNamePrefix();
        if (queueNamePrefix == null) {
            queueNamePrefix = "";
        } else if (!Utils.validQueueName(queueNamePrefix)) {
            throw this.getInvalidParameterValueFault();
        }
        try {
            List list = messageBoxService.listQueues(queueNamePrefix);
            int index = 0;
            URI[] uris = new URI[list.size()];
            for (String queueName : list) {
                uris[index] = Utils.constructResponseURL(queueName);
                ++index;
            }
            ListQueuesResponse listQueuesResponse = new ListQueuesResponse();
            ListQueuesResult_type0 listQueuesResult_type0 = new ListQueuesResult_type0();
            ResponseMetadata_type0 responseMetadata_type0 = new ResponseMetadata_type0();
            responseMetadata_type0.setRequestId(Utils.getMessageRequestId());
            listQueuesResponse.setResponseMetadata(responseMetadata_type0);
            listQueuesResult_type0.setQueueUrl(uris);
            listQueuesResponse.setListQueuesResult(listQueuesResult_type0);
            if (log.isInfoEnabled()) {
                log.info((Object)("List of message boxes successfully retrieved with username :" + userName));
            }
            return listQueuesResponse;
        }
        catch (MessageBoxException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Failed to get list of message boxes.");
            }
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }

    private AxisFault getInvalidParameterValueFault() throws AxisFault {
        return new FaultResponse(Utils.getMessageRequestId(), "InvalidParameterValue ", "One or more parameters cannot be validated. ").createAxisFault();
    }

    public CreateQueueResponse createQueue(CreateQueue createQueue) throws AxisFault {
        String userName = MultitenantUtils.getTenantAwareUsername((String)CarbonContext.getCurrentContext().getUsername());
        String messageBoxName = createQueue.getQueueName();
        if (!Utils.validQueueName(messageBoxName)) {
            throw this.getInvalidParameterValueFault();
        }
        long defaultVisibilityTimeout = 30L;
        BigInteger visibilityTimeout = createQueue.getDefaultVisibilityTimeout();
        if (visibilityTimeout != null && ((defaultVisibilityTimeout = visibilityTimeout.longValue()) > 43200L || defaultVisibilityTimeout < 0L)) {
            throw this.getInvalidParameterValueFault();
        }
        try {
            MessageBoxService messageBoxService = MessageBoxHolder.getInstance().getMessageboxService();
            String queueName = messageBoxService.createMessageBox(messageBoxName, defaultVisibilityTimeout);
            CreateQueueResponse createQueueResponse = new CreateQueueResponse();
            CreateQueueResult createQueueResult = new CreateQueueResult();
            CreateQueueResult_type0 createQueueResult_type0 = new CreateQueueResult_type0();
            ResponseMetadata_type0 responseMetadata_type0 = new ResponseMetadata_type0();
            responseMetadata_type0.setRequestId(Utils.getMessageRequestId());
            createQueueResponse.setResponseMetadata(responseMetadata_type0);
            createQueueResult_type0.setQueueUrl(Utils.constructResponseURL(queueName));
            createQueueResult.setCreateQueueResult(createQueueResult_type0);
            createQueueResponse.setCreateQueueResult(createQueueResult_type0);
            if (log.isInfoEnabled()) {
                log.info((Object)("New Messagebox successfully created with username :" + userName + " and messagebox name:" + messageBoxName));
            }
            return createQueueResponse;
        }
        catch (MessageBoxException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)(messageBoxName + " messagebox already exists with username :" + userName));
            }
            throw new FaultResponse(e, Utils.getMessageRequestId()).createAxisFault();
        }
    }
}

