/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.sqs.internal;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.wso2.carbon.messagebox.MessageBoxException;
import org.wso2.carbon.messagebox.sqs.internal.util.Utils;

public class FaultResponse {
    private String faultCode;
    private String faultString;
    private String requestedId;

    public FaultResponse(MessageBoxException messageBoxException, String requestedId) {
        this.requestedId = requestedId;
        this.faultCode = messageBoxException.getMessage();
        if (this.faultCode != null) {
            this.faultString = Utils.getSQSErrorCodeDescriptionMap().get(this.faultCode);
        }
    }

    public FaultResponse(String requestedId, String faultCode, String faultString) {
        this.requestedId = requestedId;
        this.faultCode = faultCode;
        this.faultString = faultString;
    }

    public AxisFault createAxisFault() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace awsFaultNs = factory.createOMNamespace("http://webservices.amazon.com/AWSFault/2005-15-09", "aws");
        OMElement requestIdElement = factory.createOMElement("RequestId", awsFaultNs);
        requestIdElement.setText(this.requestedId);
        AxisFault axisFault = new AxisFault(this.faultString);
        axisFault.setDetail(requestIdElement);
        axisFault.setFaultCode(this.faultCode);
        return axisFault;
    }
}

