/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.messagebox.internal.qpid;

import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.messagebox.internal.ds.MessageBoxServiceValueHolder;
import org.wso2.carbon.messagebox.internal.qpid.QueueConnectionManagerException;
import org.wso2.carbon.messagebox.internal.qpid.SharedConnection;
import org.wso2.carbon.qpid.service.QpidService;

public class QueueConnectionManager {
    private static final Log log = LogFactory.getLog(QueueConnectionManager.class);
    private static final String QPID_ICF = "org.apache.qpid.jndi.PropertiesFileInitialContextFactory";
    private static final String CF_NAME_PREFIX = "connectionfactory.";
    private static final String CF_NAME = "qpidConnectionfactory";
    public static final String MB_TYPE_LOCAL = "local";
    public static final String MB_TYPE_REMOTE = "remote";
    private String type;
    private String hostName;
    private String qpidPort;
    private String clientID;
    private String virtualHostName;
    private String accessKey;
    private ConcurrentHashMap<String, SharedConnection> connectionCache = new ConcurrentHashMap();
    private static final QueueConnectionManager instance = new QueueConnectionManager();

    private QueueConnectionManager() {
    }

    public static QueueConnectionManager getInstance() {
        return instance;
    }

    public QueueConnection getConnection(String username) throws QueueConnectionManagerException {
        try {
            return this.createNewConnection(username).getConnection();
        }
        catch (NamingException e) {
            throw new QueueConnectionManagerException(e);
        }
        catch (JMSException e) {
            throw new QueueConnectionManagerException(e);
        }
    }

    public void releaseConnection(QueueConnection connection) throws QueueConnectionManagerException {
        try {
            connection.stop();
            connection.close();
        }
        catch (JMSException e) {
            throw new QueueConnectionManagerException(e);
        }
    }

    private SharedConnection createNewConnection(String userName) throws NamingException, JMSException {
        QpidService qpidService = MessageBoxServiceValueHolder.getInstance().getQpidService();
        Properties properties = new Properties();
        properties.put("java.naming.factory.initial", QPID_ICF);
        properties.put("org.wso2.carbon.context.RequestBaseContext", "true");
        String connectionURL = null;
        connectionURL = MB_TYPE_LOCAL.equals(this.type) ? qpidService.getInternalTCPConnectionURL(userName, qpidService.getAccessKey()) : "amqp://" + userName + ":" + this.accessKey + "@" + this.clientID + "/" + this.virtualHostName + "?brokerlist='tcp://" + this.hostName + ":" + this.qpidPort + "'";
        properties.put("connectionfactory.qpidConnectionfactory", connectionURL);
        InitialContext ctx = new InitialContext(properties);
        QueueConnectionFactory connFactory = (QueueConnectionFactory)ctx.lookup(CF_NAME);
        return new SharedConnection(connFactory.createQueueConnection());
    }

    public void closeAllConnections() throws QueueConnectionManagerException {
        try {
            for (SharedConnection sharedConnection : this.connectionCache.values()) {
                sharedConnection.getConnection().close();
            }
        }
        catch (JMSException e) {
            throw new QueueConnectionManagerException(e);
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setQpidPort(String qpidPort) {
        this.qpidPort = qpidPort;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public void setVirtualHostName(String virtualHostName) {
        this.virtualHostName = virtualHostName;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }
}

